/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.ui.client;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.stub.BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException;
import org.wso2.carbon.bam.toolbox.deployer.stub.BAMToolboxDepolyerServiceStub;

public class BAMToolBoxDeployerClient {
    private BAMToolboxDepolyerServiceStub stub;
    private static String BAMToolBoxService = "BAMToolboxDepolyerService";
    private static Log log = LogFactory.getLog(BAMToolBoxDeployerClient.class);

    public BAMToolBoxDeployerClient(String cookie, String backEndServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backEndServerURL + BAMToolBoxService;
        this.stub = new BAMToolboxDepolyerServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public boolean uploadToolBox(DataHandler toolbox, String toolName) throws RemoteException, BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException {
        try {
            return this.stub.uploadBAMToolBox(toolbox, toolName);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
            log.error((Object)e.getFaultMessage().getBAMToolboxDeploymentException().getMessage(), (Throwable)e);
            throw e;
        }
    }

    public BAMToolboxDepolyerServiceStub.ToolBoxStatusDTO getToolBoxStatus(String toolType, String search) throws BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException, RemoteException {
        try {
            return this.stub.getDeployedToolBoxes(toolType, search);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
            log.error((Object)e.getFaultMessage().getBAMToolboxDeploymentException().getMessage(), (Throwable)e);
            throw e;
        }
    }

    public boolean undeployToolBox(String[] toolName) throws RemoteException, BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException {
        try {
            return this.stub.undeployToolBox(toolName);
        }
        catch (RemoteException e) {
            log.error((Object)e);
            throw e;
        }
        catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
            log.error((Object)e.getFaultMessage().getBAMToolboxDeploymentException());
            throw e;
        }
    }

    public void downloadBAMTool(String toolName, HttpServletResponse response) throws BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException {
        try {
            ServletOutputStream out = response.getOutputStream();
            DataHandler downloadData = this.stub.downloadToolBox(toolName);
            if (downloadData != null) {
                int nextChar;
                String fileName = "";
                fileName = !toolName.endsWith(".tbox") ? toolName + ".tbox" : toolName;
                response.setHeader("Content-Disposition", "fileName=" + fileName);
                response.setContentType(downloadData.getContentType());
                InputStream in = downloadData.getDataSource().getInputStream();
                while ((nextChar = in.read()) != -1) {
                    out.write((int)((char)nextChar));
                }
                out.flush();
                in.close();
            } else {
                out.write("The requested service archive was not found on the server".getBytes());
            }
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException((Throwable)e);
        }
    }

    public void deploySample(String sampleId) throws BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException {
        try {
            this.stub.deployBasicToolBox(Integer.parseInt(sampleId));
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException((Throwable)e);
        }
        catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
            log.error((Object)e.getFaultMessage().getBAMToolboxDeploymentException().getMessage(), (Throwable)e);
            throw e;
        }
    }

    public BAMToolboxDepolyerServiceStub.BasicToolBox[] getAllBasicTools() throws BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException {
        try {
            return this.stub.getBasicToolBoxes();
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException((Throwable)e);
        }
    }

    public void installToolBoxFromURL(String url) throws BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException {
        try {
            this.stub.deployToolBoxFromURL(url);
        }
        catch (RemoteException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException((Throwable)e);
        }
        catch (BAMToolboxDepolyerServiceBAMToolboxDeploymentExceptionException e) {
            log.error((Object)e.getFaultMessage().getBAMToolboxDeploymentException().getMessage(), (Throwable)e);
            throw e;
        }
    }
}

