/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.util;

import java.util.ArrayList;
import org.wso2.carbon.bam.toolbox.deployer.util.DashBoardTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.JasperTabDTO;

public class ToolBoxDTO {
    private String name;
    private ArrayList<String> scriptNames;
    private ArrayList<DashBoardTabDTO> dashboardTabs;
    private ArrayList<JasperTabDTO> jasperTabs;
    private ArrayList<String> evenStreamDefs;
    private String scriptsParentDirectory;
    private String gagetsParentDirectory;
    private String jasperParentDirectory;
    private String jaggeryAppParentDirectory;
    private String streamDefnParentDirectory;
    private String hotDeploymentRootDir;
    private String datasource;
    private String dsConfiguration;

    public ToolBoxDTO(String name) {
        this.name = name;
        this.scriptNames = new ArrayList();
        this.dashboardTabs = new ArrayList();
        this.jasperTabs = new ArrayList();
        this.evenStreamDefs = new ArrayList();
        this.datasource = "";
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<DashBoardTabDTO> getDashboardTabs() {
        return this.dashboardTabs;
    }

    public void setDashboardTabs(ArrayList<DashBoardTabDTO> dashboardTabs) {
        this.dashboardTabs = dashboardTabs;
    }

    public ArrayList<JasperTabDTO> getJasperTabs() {
        return this.jasperTabs;
    }

    public void setJasperTabs(ArrayList<JasperTabDTO> jasperTabs) {
        this.jasperTabs = jasperTabs;
    }

    public ArrayList<String> getScriptNames() {
        return this.scriptNames;
    }

    public void addScriptName(String scriptName) {
        this.scriptNames.add(scriptName);
    }

    public void setScriptNames(ArrayList<String> scriptNames) {
        this.scriptNames = scriptNames;
    }

    public String getScriptsParentDirectory() {
        return this.scriptsParentDirectory;
    }

    public void setScriptsParentDirectory(String scriptsParentDirectory) {
        this.scriptsParentDirectory = scriptsParentDirectory;
    }

    public String getGagetsParentDirectory() {
        return this.gagetsParentDirectory;
    }

    public void setGagetsParentDirectory(String gagetsParentDirectory) {
        this.gagetsParentDirectory = gagetsParentDirectory;
    }

    public void addGadgets(int tabId, String gadgetName) {
        for (DashBoardTabDTO aTab : this.dashboardTabs) {
            if (aTab.getTabId() != tabId) continue;
            aTab.addGadget(gadgetName);
        }
    }

    public void addDashboradTab(DashBoardTabDTO dashBoardTabDTO) {
        this.dashboardTabs.add(dashBoardTabDTO);
    }

    public void addJasperTab(JasperTabDTO jasperTabDTO) {
        this.jasperTabs.add(jasperTabDTO);
    }

    public void addGadgetsInTabIndex(int index, String gadgetName) {
        this.dashboardTabs.get(index).addGadget(gadgetName);
    }

    public void replaceGadgetName(String oldName, String newName) {
        for (DashBoardTabDTO tabDTO : this.dashboardTabs) {
            ArrayList<String> newGadgetNames = new ArrayList<String>();
            for (String aGadget : tabDTO.getGadgets()) {
                if (aGadget.equals(oldName)) {
                    newGadgetNames.add(newName);
                    continue;
                }
                newGadgetNames.add(oldName);
            }
        }
    }

    public String getJaggeryAppParentDirectory() {
        return this.jaggeryAppParentDirectory;
    }

    public void setJaggeryAppParentDirectory(String jaggeryAppParentDirectory) {
        this.jaggeryAppParentDirectory = jaggeryAppParentDirectory;
    }

    public String getHotDeploymentRootDir() {
        return this.hotDeploymentRootDir;
    }

    public void setHotDeploymentRootDir(String hotDeploymentRootDir) {
        this.hotDeploymentRootDir = hotDeploymentRootDir;
    }

    public String getJasperParentDirectory() {
        return this.jasperParentDirectory;
    }

    public void setJasperParentDirectory(String jasperParentDirectory) {
        this.jasperParentDirectory = jasperParentDirectory;
    }

    public void setDataSource(String dataSourceName) {
        this.datasource = dataSourceName;
    }

    public String getDataSource() {
        if (null == this.datasource) {
            return "";
        }
        return this.datasource;
    }

    public void setDataSourceConfiguration(String dsConfiguration) {
        this.dsConfiguration = dsConfiguration;
    }

    public String getDataSourceConfiguration() {
        if (null == this.dsConfiguration) {
            return "";
        }
        return this.dsConfiguration;
    }

    public ArrayList<String> getEvenStreamDefs() {
        return this.evenStreamDefs;
    }

    public void setEvenStreamDefs(ArrayList<String> evenStreamDefs) {
        this.evenStreamDefs = evenStreamDefs;
    }

    public String getStreamDefnParentDirectory() {
        return this.streamDefnParentDirectory;
    }

    public void setStreamDefnParentDirectory(String streamDefnParentDirectory) {
        this.streamDefnParentDirectory = streamDefnParentDirectory;
    }
}

