/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.BAMToolBoxDeployerConstants;
import org.wso2.carbon.bam.toolbox.deployer.BasicToolBox;
import org.wso2.carbon.bam.toolbox.deployer.ServiceHolder;
import org.wso2.carbon.bam.toolbox.deployer.config.ToolBoxConfigurationManager;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.util.ToolBoxStatusDTO;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class BAMToolBoxUploaderService
extends AbstractAdmin {
    private static final String BASIC_TOOLBOX_PATH = "/samples/toolboxes";
    private static final Log log = LogFactory.getLog(BAMToolBoxUploaderService.class);

    public boolean uploadBAMToolBox(DataHandler toolbox, String toolboxName) throws BAMToolboxDeploymentException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        String repoPath = "";
        if (tenantId == -1234) {
            repoPath = ServiceHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getRepository().getPath();
        } else {
            String tenantRepoPath = "/repository/tenants/" + tenantId;
            repoPath = CarbonUtils.getCarbonHome() + tenantRepoPath;
        }
        File hotDeploymentDir = new File(repoPath + File.separator + BAMToolBoxDeployerConstants.BAM_DEPLOYMET_FOLDER);
        if (hotDeploymentDir.exists()) {
            File destFile = new File(hotDeploymentDir + File.separator + toolboxName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(destFile);
                toolbox.writeTo((OutputStream)fos);
                fos.flush();
                fos.close();
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        throw new BAMToolboxDeploymentException("No deployment folder found for tenant id:" + tenantId);
    }

    public ToolBoxStatusDTO getDeployedToolBoxes(String type, String searchKey) throws BAMToolboxDeploymentException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        ToolBoxStatusDTO toolBoxStatusDTO = new ToolBoxStatusDTO();
        String repoPath = "";
        if (tenantId == -1234) {
            repoPath = ServiceHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getRepository().getPath();
        } else {
            String tenantRepoPath = "/repository/tenants/" + tenantId;
            repoPath = CarbonUtils.getCarbonHome() + tenantRepoPath;
        }
        File hotDeploymentDir = new File(repoPath + File.separator + BAMToolBoxDeployerConstants.BAM_DEPLOYMET_FOLDER);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".bar");
            }
        };
        String[] toolsInDir = hotDeploymentDir.list(filter);
        if (null == searchKey) {
            searchKey = "";
        }
        ToolBoxConfigurationManager configurationManager = ToolBoxConfigurationManager.getInstance();
        ArrayList<String> toolsInConf = configurationManager.getAllToolBoxNames(tenantId);
        if (null == type || "".equals(type) || type.equals("1")) {
            toolBoxStatusDTO.setDeployedTools(this.getDeployedTools(toolsInDir, toolsInConf, searchKey));
            toolBoxStatusDTO.setToBeDeployedTools(this.getToBeDeployedTools(toolsInDir, toolsInConf, searchKey));
            toolBoxStatusDTO.setToBeUndeployedTools(this.getToBeUnDeployedTools(toolsInDir, toolsInConf, searchKey));
        } else if (type.equalsIgnoreCase("2")) {
            toolBoxStatusDTO.setDeployedTools(this.getDeployedTools(toolsInDir, toolsInConf, searchKey));
        } else if (type.equalsIgnoreCase("3")) {
            toolBoxStatusDTO.setToBeDeployedTools(this.getToBeDeployedTools(toolsInDir, toolsInConf, searchKey));
        } else {
            toolBoxStatusDTO.setToBeUndeployedTools(this.getToBeUnDeployedTools(toolsInDir, toolsInConf, searchKey));
        }
        return toolBoxStatusDTO;
    }

    private String[] getDeployedTools(String[] toolsInDir, ArrayList<String> toolsInConf, String searchKey) {
        ArrayList<String> deployedTools = new ArrayList<String>();
        if (null != toolsInDir) {
            for (String tool : toolsInDir) {
                if (tool.endsWith(".bar")) {
                    tool = tool.replaceAll(".bar", "");
                }
                if (!searchKey.equals("") && !searchKey.equals("*") && !tool.equalsIgnoreCase(searchKey) || !toolsInConf.contains(tool)) continue;
                deployedTools.add(tool);
            }
        }
        return deployedTools.toArray(new String[deployedTools.size()]);
    }

    private String[] getToBeDeployedTools(String[] toolsInDir, ArrayList<String> toolsInConf, String searchKey) {
        ArrayList<String> toBedeployedTools = new ArrayList<String>();
        if (null != toolsInDir) {
            for (String tool : toolsInDir) {
                if (tool.endsWith(".bar")) {
                    tool = tool.replaceAll(".bar", "");
                }
                if (!searchKey.equals("") && !searchKey.equals("*") && !tool.equalsIgnoreCase(searchKey) || toolsInConf.contains(tool)) continue;
                toBedeployedTools.add(tool);
            }
        }
        return toBedeployedTools.toArray(new String[toBedeployedTools.size()]);
    }

    private String[] getToBeUnDeployedTools(String[] toolsInDir, ArrayList<String> toolsInConf, String searchKey) {
        ArrayList<String> toBeUndeployedTools = new ArrayList<String>();
        if (null != toolsInConf) {
            Iterator<String> i$ = toolsInConf.iterator();
            while (i$.hasNext()) {
                String tool;
                String toolName = tool = i$.next();
                tool = tool + ".bar";
                if (null != toolsInDir) {
                    boolean exists = false;
                    for (String toolDir : toolsInDir) {
                        if (!toolDir.equalsIgnoreCase(tool)) continue;
                        exists = true;
                        break;
                    }
                    if (!searchKey.equals("") && !searchKey.equals("*") && !tool.equalsIgnoreCase(searchKey) || exists) continue;
                    toBeUndeployedTools.add(toolName);
                    continue;
                }
                if (searchKey.equals("") || searchKey.equals("*")) {
                    toBeUndeployedTools.addAll(toolsInConf);
                    break;
                }
                if (!tool.equalsIgnoreCase(searchKey)) continue;
                toBeUndeployedTools.add(tool);
            }
        }
        return toBeUndeployedTools.toArray(new String[toBeUndeployedTools.size()]);
    }

    public boolean undeployToolBox(String[] toolboxNames) throws BAMToolboxDeploymentException {
        if (null != toolboxNames) {
            int tenantId = CarbonContext.getCurrentContext().getTenantId();
            String repoPath = "";
            if (tenantId == -1234) {
                repoPath = ServiceHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getRepository().getPath();
            } else {
                String tenantRepoPath = "/repository/tenants/" + tenantId;
                repoPath = CarbonUtils.getCarbonHome() + tenantRepoPath;
            }
            for (String toolboxName : toolboxNames) {
                if (null == toolboxName || toolboxName.trim().equals("")) continue;
                File toolbox = new File(repoPath + File.separator + BAMToolBoxDeployerConstants.BAM_DEPLOYMET_FOLDER + File.separator + toolboxName.trim() + ".bar");
                if (toolbox.exists()) {
                    toolbox.delete();
                    continue;
                }
                throw new BAMToolboxDeploymentException("No Tool Box exists in the deployment folder" + toolboxName);
            }
            return true;
        }
        return true;
    }

    public DataHandler downloadToolBox(String toolboxName) {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        String repoPath = "";
        if (tenantId == -1234) {
            repoPath = ServiceHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getRepository().getPath();
        } else {
            String tenantRepoPath = "/repository/tenants/" + tenantId;
            repoPath = CarbonUtils.getCarbonHome() + tenantRepoPath;
        }
        File toolbox = new File(repoPath + File.separator + BAMToolBoxDeployerConstants.BAM_DEPLOYMET_FOLDER + File.separator + toolboxName + ".bar");
        FileDataSource datasource = new FileDataSource(toolbox);
        return new DataHandler((DataSource)datasource);
    }

    public void deployBasicToolBox(int sample_id) throws BAMToolboxDeploymentException {
        for (BasicToolBox basicToolBox : BasicToolBox.values()) {
            if (basicToolBox.getSampleId() != sample_id) continue;
            String toolboxPath = CarbonUtils.getCarbonHome() + BASIC_TOOLBOX_PATH + File.separator + basicToolBox.getToolboxName();
            this.copyArtifact(toolboxPath, basicToolBox.getToolboxName());
        }
    }

    private void copyArtifact(String toolBoxSrc, String toolName) throws BAMToolboxDeploymentException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        String repoPath = "";
        if (tenantId == -1234) {
            repoPath = ServiceHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration().getRepository().getPath();
        } else {
            String tenantRepoPath = "/repository/tenants/" + tenantId;
            repoPath = CarbonUtils.getCarbonHome() + tenantRepoPath;
        }
        File hotDeploymentDir = new File(repoPath + File.separator + BAMToolBoxDeployerConstants.BAM_DEPLOYMET_FOLDER);
        if (hotDeploymentDir.exists()) {
            FileInputStream in = null;
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".bar");
                }
            };
            String[] toolsInDir = hotDeploymentDir.list(filter);
            if (null != toolsInDir) {
                for (String tool : toolsInDir) {
                    if (null == tool || !tool.equals(toolName)) continue;
                    throw new BAMToolboxDeploymentException("The selected Tool already deployed..");
                }
            }
            try {
                int len;
                in = new FileInputStream(toolBoxSrc);
                FileOutputStream out = new FileOutputStream(hotDeploymentDir + File.separator + toolName);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (FileNotFoundException e) {
                log.error((Object)e);
                throw new BAMToolboxDeploymentException(e.getMessage(), e);
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new BAMToolboxDeploymentException(e.getMessage(), e);
            }
        } else {
            throw new BAMToolboxDeploymentException("No deployment folder found for tenant id:" + tenantId);
        }
    }

    public BasicToolBox[] getBasicToolBoxes() {
        return BasicToolBox.values();
    }
}

