/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.toolbox.deployer.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.toolbox.deployer.exception.BAMToolboxDeploymentException;
import org.wso2.carbon.bam.toolbox.deployer.util.DashBoardTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.JasperTabDTO;
import org.wso2.carbon.bam.toolbox.deployer.util.ToolBoxDTO;

public class BAMArtifactProcessor {
    private static BAMArtifactProcessor instance;
    private static final Log log;

    private BAMArtifactProcessor() {
    }

    public static BAMArtifactProcessor getInstance() {
        if (null == instance) {
            instance = new BAMArtifactProcessor();
        }
        return instance;
    }

    public String extractBAMArtifact(String bamArtifact, String destFolder) throws BAMToolboxDeploymentException {
        return this.unzipFolder(bamArtifact, destFolder);
    }

    private String unzipFolder(String zipFile, String destFolder) throws BAMToolboxDeploymentException {
        try {
            ZipFile bamArtifact = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> zipEnum = bamArtifact.entries();
            while (zipEnum.hasMoreElements()) {
                int ch;
                ZipEntry item = zipEnum.nextElement();
                if (item.isDirectory()) {
                    File newdir = new File(destFolder + File.separator + item.getName());
                    newdir.mkdir();
                    continue;
                }
                String newfilePath = destFolder + File.separator + item.getName();
                File newFile = new File(newfilePath);
                if (!newFile.getParentFile().exists()) {
                    newFile.getParentFile().mkdirs();
                }
                InputStream is = bamArtifact.getInputStream(item);
                FileOutputStream fos = new FileOutputStream(newfilePath);
                while ((ch = is.read()) != -1) {
                    fos.write(ch);
                }
                is.close();
                fos.close();
            }
            bamArtifact.close();
            File file = new File(bamArtifact.getName());
            return destFolder + File.separator + file.getName().replace(".bar", "");
        }
        catch (Exception e) {
            log.error((Object)("Exception while extracting the BAM artifact:" + zipFile), (Throwable)e);
            throw new BAMToolboxDeploymentException("Exception while extracting the BAM artifact:" + zipFile, e);
        }
    }

    public ToolBoxDTO getToolBoxDTO(String barDir) throws BAMToolboxDeploymentException {
        return this.createDTO(barDir);
    }

    private ToolBoxDTO createDTO(String barDir) throws BAMToolboxDeploymentException {
        File file = new File(barDir);
        String name = file.getName();
        ToolBoxDTO toolBoxDTO = new ToolBoxDTO(name);
        this.setScriptsNames(toolBoxDTO, barDir);
        this.setGadgetNames(toolBoxDTO, barDir);
        this.setJaggeryAppNames(toolBoxDTO, barDir);
        this.setStreamDefnNames(toolBoxDTO, barDir);
        String jasperDirectory = barDir + File.separator + "dashboard" + File.separator + "jasper";
        if (new File(jasperDirectory).exists()) {
            this.setJasperResourceNames(toolBoxDTO, barDir);
        }
        return toolBoxDTO;
    }

    private void setScriptsNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        toolBoxDTO.setScriptsParentDirectory(barDir + File.separator + "scripts");
        ArrayList<String> scriptNames = this.getFilesInDirectory(barDir + File.separator + "scripts");
        if (scriptNames.size() == 0) {
            throw new BAMToolboxDeploymentException("No scripts available in the specified directory");
        }
        toolBoxDTO.setScriptNames(scriptNames);
    }

    private void setStreamDefnNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        toolBoxDTO.setStreamDefnParentDirectory(barDir + File.separator + "streamDefn");
        ArrayList<String> streamDefNames = this.getFilesInDirectory(barDir + File.separator + "streamDefn");
        if (streamDefNames.size() == 0) {
            log.warn((Object)"No event streams found in the specified directory");
        } else {
            toolBoxDTO.setEvenStreamDefs(streamDefNames);
        }
    }

    private void setJaggeryAppNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        toolBoxDTO.setJaggeryAppParentDirectory(barDir + File.separator + "dashboard" + File.separator + "jaggery");
    }

    private void setGadgetNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        if (new File(barDir + File.separator + "dashboard").exists()) {
            toolBoxDTO.setGagetsParentDirectory(barDir + File.separator + "dashboard" + File.separator + "gadgets");
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(barDir + File.separator + "dashboard" + File.separator + "dashboard.properties"));
                this.setTabNames(toolBoxDTO, properties);
                int tabIndex = 1;
                for (DashBoardTabDTO aTab : toolBoxDTO.getDashboardTabs()) {
                    String value = properties.getProperty("tab.name" + tabIndex + "." + "gadget.xmls");
                    this.setGadgetNamesForTab(aTab, value);
                    ++tabIndex;
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)("No dashboard.properties found in dir:" + barDir + File.separator + "dashboard"), (Throwable)e);
                throw new BAMToolboxDeploymentException("No dashboard.properties found in dir:" + barDir + File.separator + "dashboard", e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new BAMToolboxDeploymentException(e.getMessage(), e);
            }
        } else {
            toolBoxDTO.setGagetsParentDirectory(null);
            toolBoxDTO.setDashboardTabs(new ArrayList<DashBoardTabDTO>());
        }
    }

    private void setJasperResourceNames(ToolBoxDTO toolBoxDTO, String barDir) throws BAMToolboxDeploymentException {
        toolBoxDTO.setJasperParentDirectory(barDir + File.separator + "dashboard" + File.separator + "jasper");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(barDir + File.separator + "dashboard" + File.separator + "jasper.properties"));
            this.setJasperTabNames(toolBoxDTO, properties);
            int tabIndex = 1;
            for (JasperTabDTO aTab : toolBoxDTO.getJasperTabs()) {
                String value = properties.getProperty("tab.name" + tabIndex + "." + "jrxml");
                aTab.setTabId(tabIndex);
                this.setJRXMLForTab(aTab, value);
                ++tabIndex;
            }
            toolBoxDTO.setDataSource(properties.getProperty("datasource"));
            toolBoxDTO.setDataSourceConfiguration(barDir + File.separator + "dashboard" + File.separator + properties.getProperty("datasource.configuration"));
        }
        catch (FileNotFoundException e) {
            log.error((Object)("No jasper.properties found in dir:" + barDir + File.separator + "dashboard"), (Throwable)e);
            throw new BAMToolboxDeploymentException("No jasper.properties found in dir:" + barDir + File.separator + "dashboard", e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new BAMToolboxDeploymentException(e.getMessage(), e);
        }
    }

    private void setJasperTabNames(ToolBoxDTO toolBoxDTO, Properties props) throws BAMToolboxDeploymentException {
        String tabs = props.getProperty("tab.names").trim();
        String[] tabNames = tabs.split(",");
        if (tabNames == null || tabNames.length == 0) {
            throw new BAMToolboxDeploymentException("Invalid bar artifact. No tab names found in dashboard.properties");
        }
        boolean valid = false;
        for (String aTabName : tabNames) {
            if (aTabName.trim().equals("")) continue;
            valid = true;
            JasperTabDTO tabDTO = new JasperTabDTO();
            tabDTO.setTabName(aTabName.trim());
            toolBoxDTO.addJasperTab(tabDTO);
        }
        if (!valid) {
            throw new BAMToolboxDeploymentException("Invalid bar artifact. No tab names found in dashboard.properties");
        }
    }

    private void setTabNames(ToolBoxDTO toolBoxDTO, Properties props) throws BAMToolboxDeploymentException {
        String tabs = props.getProperty("tab.names").trim();
        String[] tabNames = tabs.split(",");
        if (tabNames == null || tabNames.length == 0) {
            throw new BAMToolboxDeploymentException("Invalid bar artifact. No tab names found in dashboard.properties");
        }
        boolean valid = false;
        for (String aTabName : tabNames) {
            if (aTabName.trim().equals("")) continue;
            valid = true;
            DashBoardTabDTO tabDTO = new DashBoardTabDTO();
            tabDTO.setTabName(aTabName.trim());
            toolBoxDTO.addDashboradTab(tabDTO);
        }
        if (!valid) {
            throw new BAMToolboxDeploymentException("Invalid bar artifact. No tab names found in dashboard.properties");
        }
    }

    private void setGadgetNamesForTab(DashBoardTabDTO dashBoardTabDTO, String gagetXmlsNames) throws BAMToolboxDeploymentException {
        if (gagetXmlsNames != null && !gagetXmlsNames.trim().equals("")) {
            String[] gadgets = gagetXmlsNames.split(",");
            if (gadgets == null || gadgets.length == 0) {
                throw new BAMToolboxDeploymentException("Invalid bar artifact. No gadget names found for tab :" + dashBoardTabDTO + " in dashboard.properties");
            }
            boolean valid = false;
            for (String aGadget : gadgets) {
                if (aGadget.trim().equals("")) continue;
                valid = true;
                dashBoardTabDTO.addGadget(aGadget.trim());
            }
            if (!valid) {
                throw new BAMToolboxDeploymentException("Invalid bar artifact. No gadget names found for tab :" + dashBoardTabDTO + " in dashboard.properties");
            }
        } else {
            throw new BAMToolboxDeploymentException("No jrxml files specified for tab :" + dashBoardTabDTO.getTabName());
        }
    }

    private void setJRXMLForTab(JasperTabDTO jasperTabDTO, String jrxmlFileName) throws BAMToolboxDeploymentException {
        if (jrxmlFileName == null || jrxmlFileName.trim().equals("")) {
            throw new BAMToolboxDeploymentException("No jrxml file specified for tab :" + jasperTabDTO.getTabName());
        }
        String jrxmlFile = jrxmlFileName.trim();
        jasperTabDTO.setJrxmlFileName(jrxmlFile);
    }

    private ArrayList<String> getFilesInDirectory(String dirPath) throws BAMToolboxDeploymentException {
        File dir = new File(dirPath);
        ArrayList<String> files = new ArrayList<String>();
        String[] children = dir.list();
        if (children == null) {
            throw new BAMToolboxDeploymentException("No files exists in the directory:" + dirPath + " BAM artifacts expects files in the directory");
        }
        for (String aChildren : children) {
            if (new File(aChildren).isDirectory()) continue;
            files.add(aChildren);
        }
        return files;
    }

    static {
        log = LogFactory.getLog(BAMArtifactProcessor.class);
    }
}

