/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.service.data.publisher.stub.ServiceDataPublisherAdminStub;
import org.wso2.carbon.bam.service.data.publisher.stub.conf.EventingConfigData;

public class ServiceDataPublisherAdminClient {
    private static final Log log = LogFactory.getLog(ServiceDataPublisherAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.bam.service.data.publisher.ui.i18n.Resources";
    private ServiceDataPublisherAdminStub stub;
    private ResourceBundle bundle;

    public ServiceDataPublisherAdminClient(String cookie, String backendServerURL, ConfigurationContext configContext, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ServiceDataPublisherAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ServiceDataPublisherAdminStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void setEventingConfigData(EventingConfigData eventingConfigData) throws RemoteException {
        try {
            this.stub.configureEventing(eventingConfigData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.set.eventing.config"), e);
        }
    }

    public EventingConfigData getEventingConfigData() throws RemoteException {
        try {
            return this.stub.getEventingConfigData();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.eventing.config"), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

