/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.modules;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.service.data.publisher.conf.EventingConfigData;
import org.wso2.carbon.bam.service.data.publisher.data.BAMServerInfo;
import org.wso2.carbon.bam.service.data.publisher.data.Event;
import org.wso2.carbon.bam.service.data.publisher.data.EventData;
import org.wso2.carbon.bam.service.data.publisher.data.PublishData;
import org.wso2.carbon.bam.service.data.publisher.internal.StatisticsServiceComponent;
import org.wso2.carbon.bam.service.data.publisher.publish.EventPublisher;
import org.wso2.carbon.bam.service.data.publisher.publish.ServiceAgentUtil;
import org.wso2.carbon.bam.service.data.publisher.util.TenantEventConfigData;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.statistics.services.util.OperationStatistics;
import org.wso2.carbon.statistics.services.util.ServiceStatistics;
import org.wso2.carbon.statistics.services.util.SystemStatistics;

public class StatisticsHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(StatisticsHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
            int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
            Map<Integer, EventingConfigData> tenantSpecificEventConfig = TenantEventConfigData.getTenantSpecificEventingConfigData();
            EventingConfigData eventingConfigData = tenantSpecificEventConfig.get(tenantID);
            if (eventingConfigData != null && eventingConfigData.isServiceStatsEnable()) {
                EventData eventData;
                OperationStatistics operationStatistics;
                SystemStatisticsUtil systemStatisticsUtil = StatisticsServiceComponent.getSystemStatisticsUtil();
                SystemStatistics systemStatistics = systemStatisticsUtil.getSystemStatistics(axisConfiguration);
                AxisOperation axisOperation = msgContext.getAxisOperation();
                if (axisOperation != null) {
                    operationStatistics = systemStatisticsUtil.getOperationStatistics(axisOperation);
                    if (operationStatistics.getTotalRequestCount() == 0) {
                        return Handler.InvocationResponse.CONTINUE;
                    }
                } else {
                    return Handler.InvocationResponse.CONTINUE;
                }
                MessageContext inMessageContext = MessageContext.getCurrentMessageContext();
                PublishData publishData = (PublishData)msgContext.getProperty("event_data");
                if (publishData != null) {
                    eventData = publishData.getEventData();
                } else {
                    publishData = new PublishData();
                    eventData = new EventData();
                }
                if (!eventingConfigData.isMsgDumpingEnable()) {
                    Timestamp timestamp = null;
                    if (inMessageContext != null) {
                        timestamp = new Timestamp(Long.parseLong(inMessageContext.getProperty("wso2statistics.request.received.time").toString()));
                        Object requestProperty = inMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                        ServiceAgentUtil.extractInfoFromHttpHeaders(eventData, requestProperty);
                    } else {
                        Date date = new Date();
                        timestamp = new Timestamp(date.getTime());
                    }
                    eventData.setTimestamp(timestamp);
                    eventData.setOperationName(axisOperation.getName().getLocalPart());
                    eventData.setServiceName(msgContext.getAxisService().getName());
                }
                ServiceStatistics serviceStatistics = systemStatisticsUtil.getServiceStatistics(msgContext.getAxisService());
                eventData.setSystemStatistics(systemStatistics);
                eventData.setServiceStatistics(serviceStatistics);
                eventData.setOperationStatistics(operationStatistics);
                publishData.setEventData(eventData);
                if (!eventingConfigData.isMsgDumpingEnable()) {
                    BAMServerInfo bamServerInfo = ServiceAgentUtil.addBAMServerInfo(eventingConfigData);
                    publishData.setBamServerInfo(bamServerInfo);
                }
                Event event = ServiceAgentUtil.makeEventList(publishData, eventingConfigData);
                EventPublisher publisher = new EventPublisher();
                publisher.publish(event, eventingConfigData);
            }
        }
        catch (Throwable ignore) {
            log.error((Object)("Error at SystemStatisticsHandler. But continuing message processing for message id: " + msgContext.getMessageID()), ignore);
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

