/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.modules;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.service.data.publisher.conf.EventingConfigData;
import org.wso2.carbon.bam.service.data.publisher.data.BAMServerInfo;
import org.wso2.carbon.bam.service.data.publisher.data.Event;
import org.wso2.carbon.bam.service.data.publisher.data.EventData;
import org.wso2.carbon.bam.service.data.publisher.data.PublishData;
import org.wso2.carbon.bam.service.data.publisher.publish.EventPublisher;
import org.wso2.carbon.bam.service.data.publisher.publish.ServiceAgentUtil;
import org.wso2.carbon.bam.service.data.publisher.util.TenantEventConfigData;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class ActivityOutHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(ActivityOutHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        AxisConfiguration axisConfiguration = messageContext.getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        Map<Integer, EventingConfigData> tenantSpecificEventConfig = TenantEventConfigData.getTenantSpecificEventingConfigData();
        EventingConfigData eventingConfigData = tenantSpecificEventConfig.get(tenantID);
        if (eventingConfigData != null && eventingConfigData.isMsgDumpingEnable()) {
            AxisService service = messageContext.getAxisService();
            Parameter adminServiceParam = service.getParameter("adminService");
            Parameter hiddenServiceParam = service.getParameter("hiddenService");
            if (adminServiceParam == null && hiddenServiceParam == null) {
                EventData eventData;
                if (messageContext.getMessageID() == null) {
                    UUID msgUUID = UUID.randomUUID();
                    messageContext.setMessageID(msgUUID.toString());
                }
                MessageContext inMessageContext = messageContext.getOperationContext().getMessageContext("In");
                Iterator itr = inMessageContext.getEnvelope().getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
                String activityID = null;
                if (itr.hasNext()) {
                    OMElement element = (OMElement)itr.next();
                    activityID = element.getAttributeValue(new QName("activityID"));
                }
                PublishData publishData = null;
                Timestamp timestamp = null;
                if (inMessageContext != null) {
                    publishData = (PublishData)inMessageContext.getProperty("event_data");
                } else {
                    Date date = new Date();
                    timestamp = new Timestamp(date.getTime());
                }
                if (publishData != null) {
                    eventData = publishData.getEventData();
                } else {
                    publishData = new PublishData();
                    eventData = new EventData();
                }
                this.addDetailsOfTheMessage(eventData, timestamp, activityID, messageContext);
                publishData.setEventData(eventData);
                if (!this.isInFlowDataPresent(messageContext)) {
                    BAMServerInfo bamServerInfo = ServiceAgentUtil.addBAMServerInfo(eventingConfigData);
                    publishData.setBamServerInfo(bamServerInfo);
                }
                if (!eventingConfigData.isServiceStatsEnable()) {
                    Event event = ServiceAgentUtil.makeEventList(publishData, eventingConfigData);
                    EventPublisher publisher = new EventPublisher();
                    publisher.publish(event, eventingConfigData);
                } else {
                    messageContext.setProperty("event_data", (Object)publishData);
                }
                this.engageSOAPHeaders(messageContext, activityID);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void engageSOAPHeaders(MessageContext messageContext, String activityID) {
        SOAPFactory soapFactory = null;
        SOAPHeaderBlock soapHeaderBlock = null;
        SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
        String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
        if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            log.error((Object)"Not a standard soap message");
        }
        if (soapEnvelope.getHeader() != null) {
            Iterator itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
            if (!itr.hasNext()) {
                OMFactory fac = OMAbstractFactory.getOMFactory();
                OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
                soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                soapHeaderBlock.addAttribute("activityID", activityID, null);
            } else {
                OMElement element = (OMElement)itr.next();
                String aid = element.getAttributeValue(new QName("activityID"));
                if (aid != null) {
                    if (aid.equals("")) {
                        element.addAttribute("activityID", activityID, null);
                    }
                } else {
                    element.addAttribute("activityID", activityID, null);
                }
            }
        } else if (soapFactory != null) {
            soapFactory.createSOAPHeader(soapEnvelope);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
            soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
            soapHeaderBlock.addAttribute("activityID", activityID, null);
        }
    }

    private EventData addDetailsOfTheMessage(EventData eventData, Timestamp timestamp, String activityID, MessageContext outMessageContext) throws AxisFault {
        if (!this.isInFlowDataPresent(outMessageContext)) {
            eventData.setTimestamp(timestamp);
            eventData.setActivityId(activityID);
            eventData.setOperationName(outMessageContext.getAxisService().getName());
            eventData.setServiceName(outMessageContext.getAxisOperation().getName().getLocalPart());
        }
        eventData.setOutMessageId(outMessageContext.getMessageID());
        eventData.setOutMessageBody(outMessageContext.getEnvelope().getBody().toString());
        return eventData;
    }

    private boolean isInFlowDataPresent(MessageContext outMessageContext) throws AxisFault {
        MessageContext inMessageContext = outMessageContext.getOperationContext().getMessageContext("In");
        return inMessageContext != null && inMessageContext.getProperty("event_data") != null;
    }
}

