/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.modules;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.service.data.publisher.conf.EventingConfigData;
import org.wso2.carbon.bam.service.data.publisher.data.BAMServerInfo;
import org.wso2.carbon.bam.service.data.publisher.data.Event;
import org.wso2.carbon.bam.service.data.publisher.data.EventData;
import org.wso2.carbon.bam.service.data.publisher.data.PublishData;
import org.wso2.carbon.bam.service.data.publisher.modules.StatisticsHandler;
import org.wso2.carbon.bam.service.data.publisher.publish.EventPublisher;
import org.wso2.carbon.bam.service.data.publisher.publish.ServiceAgentUtil;
import org.wso2.carbon.bam.service.data.publisher.util.TenantEventConfigData;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class ActivityInHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(StatisticsHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        AxisConfiguration axisConfiguration = messageContext.getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        Map<Integer, EventingConfigData> tenantSpecificEventConfig = TenantEventConfigData.getTenantSpecificEventingConfigData();
        EventingConfigData eventingConfigData = tenantSpecificEventConfig.get(tenantID);
        if (eventingConfigData != null && eventingConfigData.isMsgDumpingEnable()) {
            AxisService service = messageContext.getAxisService();
            Parameter adminServiceParam = service.getParameter("adminService");
            Parameter hiddenServiceParam = service.getParameter("hiddenService");
            if (adminServiceParam == null && hiddenServiceParam == null) {
                Timestamp timestamp;
                SOAPFactory soapFactory = null;
                SOAPHeaderBlock soapHeaderBlock = null;
                SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
                String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
                UUID activityUUID = UUID.randomUUID();
                if (messageContext.getMessageID() == null) {
                    UUID msgUUID = UUID.randomUUID();
                    messageContext.setMessageID(msgUUID.toString());
                }
                if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    soapFactory = OMAbstractFactory.getSOAP11Factory();
                } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
                    soapFactory = OMAbstractFactory.getSOAP12Factory();
                } else {
                    log.error((Object)"Not a standard soap message");
                }
                if (soapEnvelope.getHeader() != null) {
                    Iterator itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
                    if (!itr.hasNext()) {
                        OMFactory fac = OMAbstractFactory.getOMFactory();
                        OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
                        soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                        soapHeaderBlock.addAttribute("activityID", activityUUID.toString(), null);
                    } else {
                        OMElement element = (OMElement)itr.next();
                        String aid = element.getAttributeValue(new QName("activityID"));
                        if (aid != null) {
                            if (aid.equals("")) {
                                element.addAttribute("activityID", activityUUID.toString(), null);
                            }
                        } else {
                            element.addAttribute("activityID", activityUUID.toString(), null);
                        }
                    }
                } else if (soapFactory != null) {
                    soapFactory.createSOAPHeader(soapEnvelope);
                    OMFactory fac = OMAbstractFactory.getOMFactory();
                    OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
                    soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    soapHeaderBlock.addAttribute("activityID", activityUUID.toString(), null);
                }
                MessageContext inMessageContext = messageContext.getOperationContext().getMessageContext("In");
                EventData eventData = new EventData();
                if (inMessageContext != null) {
                    timestamp = new Timestamp(Long.parseLong(inMessageContext.getProperty("wso2statistics.request.received.time").toString()));
                    Object requestProperty = inMessageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                    ServiceAgentUtil.extractInfoFromHttpHeaders(eventData, requestProperty);
                } else {
                    Date currentDate = new Date();
                    timestamp = new Timestamp(currentDate.getTime());
                }
                this.addDetailsOfTheMessage(eventData, timestamp, activityUUID, messageContext);
                BAMServerInfo bamServerInfo = ServiceAgentUtil.addBAMServerInfo(eventingConfigData);
                PublishData publishData = new PublishData();
                publishData.setEventData(eventData);
                publishData.setBamServerInfo(bamServerInfo);
                if (this.isInOnlyMEP(messageContext)) {
                    Event event = ServiceAgentUtil.makeEventList(publishData, eventingConfigData);
                    EventPublisher publisher = new EventPublisher();
                    publisher.publish(event, eventingConfigData);
                } else {
                    inMessageContext.setProperty("event_data", (Object)publishData);
                }
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private EventData addDetailsOfTheMessage(EventData eventData, Timestamp timestamp, UUID randomUUID, MessageContext messageContext) {
        eventData.setActivityId(randomUUID.toString());
        eventData.setTimestamp(timestamp);
        String msgBody = null;
        try {
            msgBody = messageContext.getEnvelope().getBody().toString();
        }
        catch (OMException e) {
            log.warn((Object)"Exception occurred while getting soap envelop", (Throwable)e);
        }
        eventData.setInMessageBody(msgBody);
        eventData.setServiceName(messageContext.getAxisService().getName());
        eventData.setOperationName(messageContext.getAxisOperation().getName().getLocalPart());
        eventData.setInMessageId(messageContext.getMessageID());
        return eventData;
    }

    private boolean isInOnlyMEP(MessageContext messageContext) {
        String mep = messageContext.getOperationContext().getAxisOperation().getMessageExchangePattern();
        return mep.equals("http://www.w3.org/ns/wsdl/in-only") || mep.equals("http://www.w3.org/ns/wsdl/in-opt-out") || mep.equals("http://www.w3.org/ns/wsdl/robust-in-only");
    }
}

