/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.internal;

import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.service.data.publisher.conf.EventingConfigData;
import org.wso2.carbon.bam.service.data.publisher.conf.RegistryPersistenceManager;
import org.wso2.carbon.bam.service.data.publisher.util.TenantEventConfigData;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class ServiceStatisticsAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(ServiceStatisticsAxis2ConfigurationContextObserver.class);

    public void createdConfigurationContext(ConfigurationContext configContext) {
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        this.setEventingConfigDataSpecificForTenant(axisConfiguration);
        AxisModule serviceStatisticsModule = axisConfiguration.getModule("wso2bampublisherservicestats");
        int tenantId = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        if (serviceStatisticsModule != null) {
            try {
                axisConfiguration.engageModule("wso2bampublisherservicestats");
            }
            catch (AxisFault e) {
                log.error((Object)("Cannot engage ServiceStatistics module for the tenant :" + tenantId), (Throwable)e);
            }
        }
    }

    private void setEventingConfigDataSpecificForTenant(AxisConfiguration axisConfiguration) {
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        Map<Integer, EventingConfigData> eventingConfigDataMap = TenantEventConfigData.getTenantSpecificEventingConfigData();
        RegistryPersistenceManager persistenceManager = new RegistryPersistenceManager();
        EventingConfigData eventingConfigData = persistenceManager.getEventingConfigData();
        eventingConfigDataMap.put(tenantID, eventingConfigData);
    }

    public void terminatedConfigurationContext(ConfigurationContext configCtx) {
    }

    public void terminatingConfigurationContext(ConfigurationContext configCtx) {
    }
}

