/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.bam.service.data.publisher.conf.EventingConfigData;
import org.wso2.carbon.bam.service.data.publisher.conf.Property;
import org.wso2.carbon.bam.service.data.publisher.publish.ServiceAgentUtil;
import org.wso2.carbon.bam.service.data.publisher.util.TenantEventConfigData;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryPersistenceManager {
    private static RegistryService registryService;
    private static EventingConfigData eventingConfigData;
    public static final String EMPTY_STRING = "";

    public static void setRegistryService(RegistryService registryServiceParam) {
        registryService = registryServiceParam;
    }

    public void updateConfigurationProperty(String propertyName, String value) throws RegistryException {
        String resourcePath = "/repository/components/org.wso2.carbon.bam.service.data.publisher/service_stats/" + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        if (!registry.resourceExists(resourcePath)) {
            Resource resource = registry.newResource();
            resource.addProperty(propertyName, value);
            registry.put(resourcePath, resource);
        } else {
            Resource resource = registry.get(resourcePath);
            resource.setProperty(propertyName, value);
            registry.put(resourcePath, resource);
        }
    }

    public EventingConfigData load() {
        EventingConfigData eventingConfigData = new EventingConfigData();
        eventingConfigData.setServiceStatsEnable(false);
        eventingConfigData.setMsgDumpingEnable(false);
        eventingConfigData.setUrl(EMPTY_STRING);
        eventingConfigData.setPassword(EMPTY_STRING);
        eventingConfigData.setUserName(EMPTY_STRING);
        eventingConfigData.setProperties(new Property[0]);
        try {
            String serviceStatsStatus = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/service_stats/", "EnableServiceStats");
            String activityStatus = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/activity/", "EnableActivity");
            String bamUrl = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "BAMUrl");
            String bamUserName = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "BAMUserName");
            String bamPassword = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "BAMPassword");
            String streamName = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "streamName");
            String version = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "version");
            String description = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "description");
            String nickName = this.getConfigurationProperty("/repository/components/org.wso2.carbon.bam.service.data.publisher/common/", "nickName");
            Properties properties = this.getAllConfigProperties("/repository/components/org.wso2.carbon.bam.service.data.publisher/properties");
            if (serviceStatsStatus != null && activityStatus != null && bamUrl != null && bamUserName != null && bamPassword != null) {
                eventingConfigData.setServiceStatsEnable(Boolean.parseBoolean(serviceStatsStatus));
                eventingConfigData.setMsgDumpingEnable(Boolean.parseBoolean(activityStatus));
                eventingConfigData.setUrl(bamUrl);
                eventingConfigData.setUserName(bamUserName);
                eventingConfigData.setPassword(bamPassword);
                eventingConfigData.setStreamName(streamName);
                eventingConfigData.setVersion(version);
                eventingConfigData.setDescription(description);
                eventingConfigData.setNickName(nickName);
                if (properties != null) {
                    ArrayList<Property> propertyDTOList = new ArrayList<Property>();
                    String[] keys = properties.keySet().toArray(new String[properties.size()]);
                    for (int i = keys.length - 1; i >= 0; --i) {
                        String key = keys[i];
                        Property propertyDTO = new Property();
                        propertyDTO.setKey(key);
                        propertyDTO.setValue((String)((List)properties.get(key)).get(0));
                        propertyDTOList.add(propertyDTO);
                    }
                    eventingConfigData.setProperties(propertyDTOList.toArray(new Property[propertyDTOList.size()]));
                }
                int tenantId = CarbonContext.getCurrentContext().getTenantId();
                Map<Integer, EventingConfigData> tenantEventConfigData = TenantEventConfigData.getTenantSpecificEventingConfigData();
                tenantEventConfigData.put(tenantId, eventingConfigData);
            } else {
                this.update(eventingConfigData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return eventingConfigData;
    }

    public void updateConfigurationProperty(String propertyName, Object value, String registryPath) throws RegistryException {
        String resourcePath = registryPath + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        if (!registry.resourceExists(resourcePath)) {
            Resource resource = registry.newResource();
            resource.addProperty(propertyName, String.valueOf(value));
            registry.put(resourcePath, resource);
        } else {
            Resource resource = registry.get(resourcePath);
            resource.setProperty(propertyName, String.valueOf(value));
            registry.put(resourcePath, resource);
        }
    }

    public void updateAllProperties(Properties properties, String registryPath) throws RegistryException {
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        Resource resource = registry.newResource();
        resource.setProperties(properties);
        registry.put(registryPath, resource);
    }

    public void update(EventingConfigData eventingConfigData) throws RegistryException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        Map<Integer, EventingConfigData> tenantEventConfigData = TenantEventConfigData.getTenantSpecificEventingConfigData();
        tenantEventConfigData.put(tenantId, eventingConfigData);
        this.updateConfigurationProperty("EnableServiceStats", eventingConfigData.isServiceStatsEnable(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/service_stats/");
        this.updateConfigurationProperty("EnableActivity", eventingConfigData.isMsgDumpingEnable(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/activity/");
        this.updateConfigurationProperty("BAMUrl", eventingConfigData.getUrl(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        this.updateConfigurationProperty("BAMUserName", eventingConfigData.getUserName(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        this.updateConfigurationProperty("BAMPassword", eventingConfigData.getPassword(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        this.updateConfigurationProperty("streamName", eventingConfigData.getStreamName(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        this.updateConfigurationProperty("version", eventingConfigData.getVersion(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        this.updateConfigurationProperty("nickName", eventingConfigData.getNickName(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        this.updateConfigurationProperty("description", eventingConfigData.getDescription(), "/repository/components/org.wso2.carbon.bam.service.data.publisher/common/");
        Property[] propertiesDTO = eventingConfigData.getProperties();
        if (propertiesDTO != null) {
            Properties properties = new Properties();
            for (int i = 0; i < propertiesDTO.length; ++i) {
                Property property = propertiesDTO[i];
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(property.getValue());
                properties.put(property.getKey(), valueList);
            }
            this.updateAllProperties(properties, "/repository/components/org.wso2.carbon.bam.service.data.publisher/properties");
        } else {
            this.updateAllProperties(null, "/repository/components/org.wso2.carbon.bam.service.data.publisher/properties");
        }
        ServiceAgentUtil.removeExistingEventPublisherConfigValue(eventingConfigData.getUrl() + "_" + eventingConfigData.getUserName() + "_" + eventingConfigData.getPassword());
    }

    public String getConfigurationProperty(String registryPath, String propertyName) throws RegistryException {
        String resourcePath = registryPath + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        String value = null;
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            value = resource.getProperty(propertyName);
        }
        return value;
    }

    public Properties getAllConfigProperties(String registryPath) throws RegistryException {
        Resource resource;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        Properties properties = null;
        Properties filterProperties = null;
        if (registry.resourceExists(registryPath) && (properties = (resource = registry.get(registryPath)).getProperties()) != null) {
            filterProperties = new Properties();
            for (Map.Entry<Object, Object> keyValuePair : properties.entrySet()) {
                if (keyValuePair.getKey().toString().startsWith("registry.")) continue;
                filterProperties.put(keyValuePair.getKey(), keyValuePair.getValue());
            }
        }
        return filterProperties;
    }

    public EventingConfigData getEventingConfigData() {
        return this.load();
    }

    static {
        eventingConfigData = new EventingConfigData();
    }
}

