/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.publish;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.service.data.publisher.conf.EventPublisherConfig;
import org.wso2.carbon.bam.service.data.publisher.conf.EventingConfigData;
import org.wso2.carbon.bam.service.data.publisher.conf.Property;
import org.wso2.carbon.bam.service.data.publisher.data.Event;
import org.wso2.carbon.bam.service.data.publisher.publish.ServiceAgentUtil;
import org.wso2.carbon.bam.service.data.publisher.util.StatisticsType;
import org.wso2.carbon.eventbridge.agent.thrift.DataPublisher;
import org.wso2.carbon.eventbridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.eventbridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.eventbridge.commons.Attribute;
import org.wso2.carbon.eventbridge.commons.AttributeType;
import org.wso2.carbon.eventbridge.commons.EventStreamDefinition;
import org.wso2.carbon.eventbridge.commons.exception.AuthenticationException;
import org.wso2.carbon.eventbridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.eventbridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.eventbridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.eventbridge.commons.exception.TransportException;

public class EventPublisher {
    private static EventStreamDefinition streamDefForActivity;
    private static EventStreamDefinition streamDefForServiceStats;
    private static EventStreamDefinition streamDefForActivityServiceStats;
    private boolean isStreamDefinitionAlreadyExist = false;
    private static Log log;

    public void publish(Event event, EventingConfigData configData) {
        List<Object> correlationData = event.getCorrelationData();
        List<Object> metaData = event.getMetaData();
        List<Object> payLoadData = event.getEventData();
        StatisticsType statisticsType = event.getStatisticsType();
        String key = configData.getUrl() + "_" + configData.getUserName() + "_" + configData.getPassword();
        EventPublisherConfig eventPublisherConfig = ServiceAgentUtil.getEventPublisherConfig(key);
        EventStreamDefinition streamDef = this.getStreamDefinition(configData, statisticsType);
        String streamId = null;
        try {
            if (eventPublisherConfig == null) {
                eventPublisherConfig = new EventPublisherConfig();
                AgentConfiguration agentConfiguration = new AgentConfiguration();
                DataPublisher dataPublisher = new DataPublisher(configData.getUrl(), configData.getUserName(), configData.getPassword());
                eventPublisherConfig.setAgentConfiguration(agentConfiguration);
                eventPublisherConfig.setDataPublisher(dataPublisher);
                ServiceAgentUtil.getEventPublisherConfigMap().put(key, eventPublisherConfig);
            }
            DataPublisher dataPublisher = eventPublisherConfig.getDataPublisher();
            try {
                streamId = dataPublisher.findEventStream(configData.getStreamName(), configData.getVersion());
            }
            catch (NoStreamDefinitionExistException e) {
                streamId = dataPublisher.defineEventStream(streamDef);
            }
            dataPublisher.publish(streamId, this.getObjectArray(metaData), this.getObjectArray(correlationData), this.getObjectArray(payLoadData));
        }
        catch (MalformedURLException e) {
            log.error((Object)"Malformed URL, please check the URL", (Throwable)e);
        }
        catch (AgentException e) {
            log.error((Object)"Error occurred while sending the event", (Throwable)e);
        }
        catch (AuthenticationException e) {
            log.error((Object)"Please check the user name and password", (Throwable)e);
        }
        catch (TransportException e) {
            log.error((Object)"Error occurred while sending the event", (Throwable)e);
        }
        catch (StreamDefinitionException e) {
            log.error((Object)"Error occurred while defining the event", (Throwable)e);
        }
        catch (DifferentStreamDefinitionAlreadyDefinedException e) {
            log.error((Object)"Stream definition already exist", (Throwable)e);
        }
        catch (MalformedStreamDefinitionException e) {
            log.error((Object)"Malformed stream definition", (Throwable)e);
        }
    }

    private Object[] getObjectArray(List<Object> list) {
        if (list.size() > 0) {
            return list.toArray();
        }
        return null;
    }

    private EventStreamDefinition getStreamDefinition(EventingConfigData configData, StatisticsType statisticsType) {
        EventStreamDefinition streamDef = null;
        switch (statisticsType) {
            case ACTIVITY_STATS: {
                if (streamDefForActivity == null) {
                    streamDefForActivity = this.streamDefinitionForActivity(configData);
                }
                streamDef = streamDefForActivity;
                break;
            }
            case SERVICE_STATS: {
                if (streamDefForServiceStats == null) {
                    streamDefForServiceStats = this.streamDefinitionForServiceStats(configData);
                }
                streamDef = streamDefForServiceStats;
                break;
            }
            case ACTIVITY_SERVICE_STATS: {
                if (streamDefForActivityServiceStats == null) {
                    streamDefForActivityServiceStats = this.streamDefinitionForActivityServiceStats(configData);
                }
                streamDef = streamDefForActivityServiceStats;
            }
        }
        return streamDef;
    }

    private EventStreamDefinition streamDefinitionForActivity(EventingConfigData configData) {
        EventStreamDefinition streamDef = null;
        try {
            streamDef = new EventStreamDefinition(configData.getStreamName(), configData.getVersion());
            streamDef.setNickName(configData.getNickName());
            streamDef.setDescription(configData.getDescription());
            ArrayList<Attribute> metaDataAttributeList = new ArrayList<Attribute>();
            this.setUserAgentMetadata(metaDataAttributeList);
            this.setPropertiesAsMetaData(metaDataAttributeList, configData);
            streamDef.setMetaData(metaDataAttributeList);
            List<Attribute> payLoadData = new ArrayList<Attribute>();
            payLoadData = this.addCommonPayLoadData(payLoadData);
            payLoadData = this.addInOnlyPayLoadData(payLoadData);
            payLoadData = this.addOutOnlyPayLoadData(payLoadData);
            streamDef.setPayloadData(payLoadData);
            streamDef.setCorrelationData(this.setActivityCorrelationData());
        }
        catch (MalformedStreamDefinitionException e) {
            log.error((Object)"Malformed Stream Definition", (Throwable)e);
        }
        return streamDef;
    }

    private EventStreamDefinition streamDefinitionForServiceStats(EventingConfigData configData) {
        EventStreamDefinition streamDef = null;
        try {
            streamDef = new EventStreamDefinition(configData.getStreamName(), configData.getVersion());
            streamDef.setNickName(configData.getNickName());
            streamDef.setDescription(configData.getDescription());
            ArrayList<Attribute> metaDataAttributeList = new ArrayList<Attribute>();
            this.setUserAgentMetadata(metaDataAttributeList);
            this.setPropertiesAsMetaData(metaDataAttributeList, configData);
            streamDef.setMetaData(metaDataAttributeList);
            List<Attribute> payLoadData = new ArrayList<Attribute>();
            payLoadData = this.addCommonPayLoadData(payLoadData);
            payLoadData = this.addServiceStatsPayLoadData(payLoadData);
            streamDef.setPayloadData(payLoadData);
        }
        catch (MalformedStreamDefinitionException e) {
            log.error((Object)"Malformed Stream Definition", (Throwable)e);
        }
        return streamDef;
    }

    private EventStreamDefinition streamDefinitionForActivityServiceStats(EventingConfigData configData) {
        EventStreamDefinition streamDef = null;
        try {
            streamDef = new EventStreamDefinition(configData.getStreamName(), configData.getVersion());
            streamDef.setNickName(configData.getNickName());
            streamDef.setDescription(configData.getDescription());
            ArrayList<Attribute> metaDataAttributeList = new ArrayList<Attribute>();
            this.setUserAgentMetadata(metaDataAttributeList);
            this.setPropertiesAsMetaData(metaDataAttributeList, configData);
            streamDef.setMetaData(metaDataAttributeList);
            List<Attribute> payLoadData = new ArrayList<Attribute>();
            payLoadData = this.addCommonPayLoadData(payLoadData);
            payLoadData = this.addInOnlyPayLoadData(payLoadData);
            payLoadData = this.addOutOnlyPayLoadData(payLoadData);
            payLoadData = this.addServiceStatsPayLoadData(payLoadData);
            streamDef.setPayloadData(payLoadData);
            streamDef.setCorrelationData(this.setActivityCorrelationData());
        }
        catch (MalformedStreamDefinitionException e) {
            log.error((Object)"Malformed Stream Definition", (Throwable)e);
        }
        return streamDef;
    }

    private void setPropertiesAsMetaData(List<Attribute> metaDataAttributeList, EventingConfigData configData) {
        Property[] properties = configData.getProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                Property property = properties[i];
                if (property.getKey() == null || property.getKey().isEmpty()) continue;
                metaDataAttributeList.add(new Attribute(property.getKey(), AttributeType.STRING));
            }
        }
    }

    private List<Attribute> setActivityCorrelationData() {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("bam_activity_id", AttributeType.STRING));
        return attributeList;
    }

    private List<Attribute> addInOnlyPayLoadData(List<Attribute> payLoadData) {
        payLoadData.add(new Attribute("in_message_id", AttributeType.STRING));
        payLoadData.add(new Attribute("in_message_body", AttributeType.STRING));
        return payLoadData;
    }

    private List<Attribute> addOutOnlyPayLoadData(List<Attribute> payLoadData) {
        payLoadData.add(new Attribute("out_message_id", AttributeType.STRING));
        payLoadData.add(new Attribute("out_message_body", AttributeType.STRING));
        return payLoadData;
    }

    private List<Attribute> addCommonPayLoadData(List<Attribute> payLoadData) {
        payLoadData.add(new Attribute("service_name", AttributeType.STRING));
        payLoadData.add(new Attribute("operation_name", AttributeType.STRING));
        payLoadData.add(new Attribute("timestamp", AttributeType.LONG));
        return payLoadData;
    }

    private List<Attribute> addServiceStatsPayLoadData(List<Attribute> payLoadData) {
        payLoadData.add(new Attribute("response_time", AttributeType.LONG));
        payLoadData.add(new Attribute("request_count", AttributeType.INT));
        payLoadData.add(new Attribute("response_count", AttributeType.INT));
        payLoadData.add(new Attribute("fault_count", AttributeType.INT));
        return payLoadData;
    }

    private void setUserAgentMetadata(List<Attribute> attributeList) {
        attributeList.add(new Attribute("request_url", AttributeType.STRING));
        attributeList.add(new Attribute("remote_address", AttributeType.STRING));
        attributeList.add(new Attribute("content_type", AttributeType.STRING));
        attributeList.add(new Attribute("user_agent", AttributeType.STRING));
        attributeList.add(new Attribute("host", AttributeType.STRING));
        attributeList.add(new Attribute("referer", AttributeType.STRING));
    }

    static {
        log = LogFactory.getLog(EventPublisher.class);
    }
}

