/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.service.data.publisher.internal;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.service.data.publisher.conf.RegistryPersistenceManager;
import org.wso2.carbon.bam.service.data.publisher.internal.ServiceStatisticsAxis2ConfigurationContextObserver;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class StatisticsServiceComponent {
    private static SystemStatisticsUtil systemStatisticsUtil;
    private static ConfigurationContext configurationContext;
    private static Log log;

    protected void activate(ComponentContext context) {
        try {
            configurationContext.getAxisConfiguration().engageModule("wso2bampublisherservicestats");
            BundleContext bundleContext = context.getBundleContext();
            bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new ServiceStatisticsAxis2ConfigurationContextObserver(), null);
            new RegistryPersistenceManager().load();
            log.info((Object)"BAM service statistics data publisher bundle is activated");
        }
        catch (AxisFault axisFault) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Failed to activate BAM service statistics data publisher bundle", (Throwable)axisFault);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to activate BAM service statistics data publisher bundle", t);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM service statistics data publisher bundle is deactivated");
        }
    }

    protected void setSystemStatisticsUtil(SystemStatisticsUtil systemStatisticsUtil) {
        StatisticsServiceComponent.systemStatisticsUtil = systemStatisticsUtil;
    }

    public static SystemStatisticsUtil getSystemStatisticsUtil() {
        return systemStatisticsUtil;
    }

    protected void unsetSystemStatisticsUtil(SystemStatisticsUtil sysStatUtil) {
        systemStatisticsUtil = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        configurationContext = configurationContextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        configurationContext = null;
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            RegistryPersistenceManager.setRegistryService(registryService);
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryPersistenceManager.setRegistryService(null);
    }

    static {
        log = LogFactory.getLog(StatisticsServiceComponent.class);
    }
}

