
ALTER SESSION SET NLS_DATE_FORMAT = "YYYY-MM-DD HH24:MI:SS"

CREATE TABLE  BAM_ACTIVITY (
  BAM_ID INT NOT NULL,
  BAM_NAME VARCHAR2(255),
  BAM_DESCRIPTION VARCHAR2(1024),
  BAM_USER_DEFINED_ID VARCHAR2(255) NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_ACTIVITY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_ACTIVITY_TRIG
                    BEFORE INSERT
                    ON BAM_ACTIVITY
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                    BEGIN
                    SELECT BAM_ACTIVITY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/



CREATE TABLE BAM_DAY_DIM (
  BAM_ID INT NOT NULL,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_NAME VARCHAR2(24),
  BAM_DAY_OF_WEEK INT NOT NULL,
  BAM_DAY_OF_MONTH INT NOT NULL,
  BAM_DAY_OF_YEAR INT NOT NULL,
  BAM_MONTH INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_DAY_DIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_DAY_DIM_TRIG
                    BEFORE INSERT
                    ON BAM_DAY_DIM
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                      SELECT BAM_DAY_DIM_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
		     END;
/


CREATE TABLE BAM_ENDPOINT_STAT_DAY_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /

CREATE SEQUENCE BAM_ENDPOINT_STAT_DAY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_ENDPOINT_STAT_DAY_TRIG
                    BEFORE INSERT
                    ON BAM_ENDPOINT_STAT_DAY_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                    SELECT BAM_ENDPOINT_STAT_DAY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
		    END;
/


CREATE TABLE  BAM_ENDPOINT_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /

CREATE SEQUENCE BAM_ENDPOINT_STAT_HOUR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_ENDPOINT_STAT_HOUR_TRIG
                    BEFORE INSERT
                    ON BAM_ENDPOINT_STAT_HOUR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                    SELECT BAM_ENDPOINT_STAT_HOUR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                   END;
/


CREATE TABLE BAM_ENDPOINT_STAT_MONTH_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /

CREATE SEQUENCE BAM_ENDPOINT_STAT_MONTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_ENDPOINT_STAT_MONTH_TRIG
                    BEFORE INSERT
                    ON BAM_ENDPOINT_STAT_MONTH_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_ENDPOINT_STAT_MONTH_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_ENDPOINT_STAT_QTR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /

CREATE SEQUENCE BAM_ENDPOINT_STAT_QTR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_ENDPOINT_STAT_QTR_TRIG
                    BEFORE INSERT
                    ON BAM_ENDPOINT_STAT_QTR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_ENDPOINT_STAT_QTR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE  BAM_ENDPOINT_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /

CREATE SEQUENCE BAM_ENDPOINT_STAT_YEAR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_ENDPOINT_STAT_YEAR_TRIG
                    BEFORE INSERT
                    ON BAM_ENDPOINT_STAT_YEAR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_ENDPOINT_STAT_YEAR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE  BAM_HOUR_DIM (
  BAM_ID INT NOT NULL,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_HOUR_NO INT NOT NULL,
  BAM_DAY INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /

CREATE SEQUENCE BAM_HOUR_DIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_HOUR_DIM_TRIG
                    BEFORE INSERT
                    ON BAM_HOUR_DIM
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_HOUR_DIM_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;

/

CREATE TABLE BAM_MESSAGE (
  BAM_ID INT NOT NULL,
  BAM_OP_ID INT NOT NULL,
  BAM_MSG_ID VARCHAR2(255) NOT NULL, -- 'WS-ADDRESSING MESSAGE ID',
  BAM_ACTIVITY_ID INT  NULL,
  BAM_TIMESTAMP TIMESTAMP,
  BAM_IP_ADDRESS VARCHAR2(45),
  BAM_USER_AGENT VARCHAR2(45),
  PRIMARY KEY (BAM_ID))
 /

CREATE SEQUENCE BAM_MESSAGE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_MESSAGE_TRIG
                    BEFORE INSERT
                    ON BAM_MESSAGE
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_MESSAGE_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_MESSAGE_USER_DATA (
  BAM_ID INT NOT NULL,
  BAM_MESSAGE_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_KEY VARCHAR2(255) NOT NULL,
  BAM_VALUE VARCHAR2(1024) NOT NULL,
  PRIMARY KEY (BAM_ID))
/
CREATE SEQUENCE BAM_MESSAGE_USER_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_MESSAGE_USER_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_MESSAGE_USER_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_MESSAGE_USER_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_MESSAGE_DATA (
  BAM_ID INT NOT NULL ,
  BAM_MESSAGE_ID INT  NOT NULL,
  BAM_ACTIVITY_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP,
  BAM_DIRECTION VARCHAR2(10),
  BAM_MESSAGE LONG,
  BAM_IP_ADDRESS VARCHAR2(45),
  BAM_STATUS VARCHAR2(45),
  PRIMARY KEY (BAM_ID))

/
CREATE SEQUENCE BAM_MESSAGE_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_MESSAGE_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_MESSAGE_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_MESSAGE_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_MESSAGE_DATA_ARCHIVE (
  BAM_ID INT NOT NULL ,
  BAM_MESSAGE_ID INT  NOT NULL,
  BAM_ACTIVITY_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP,
  BAM_DIRECTION VARCHAR2(10),
  BAM_MESSAGE LONG,
  BAM_IP_ADDRESS VARCHAR2(45),
  BAM_STATUS VARCHAR2(45),
  PRIMARY KEY (BAM_ID))

/
CREATE SEQUENCE BAM_MESSAGE_DATA_ARCHIVE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_MESSAGE_DATA_ARCHIVE_TRIG
                    BEFORE INSERT
                    ON BAM_MESSAGE_DATA_ARCHIVE
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_MESSAGE_DATA_ARCHIVE_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_MESSAGE_PROPERTIES (
  BAM_ID INT NOT NULL ,
  BAM_MESSAGE_ID INT  NOT NULL,
  BAM_ACTIVITY_ID INT NOT NULL,
  BAM_KEY VARCHAR2(700),
  BAM_VALUE LONG,
  PRIMARY KEY (BAM_ID),
  UNIQUE (BAM_MESSAGE_ID,BAM_ACTIVITY_ID,BAM_KEY))

/
CREATE SEQUENCE BAM_MESSAGE_PROP_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_MESSAGE_PROP_TRIG
                    BEFORE INSERT
                    ON BAM_MESSAGE_PROPERTIES
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_MESSAGE_PROP_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_MONTH_DIM (
  BAM_ID INT NOT NULL,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_NAME VARCHAR2(24),
  BAM_NO INT NOT NULL,
  BAM_QTR INT NOT NULL,
  PRIMARY KEY (BAM_ID))
/
CREATE SEQUENCE BAM_MONTH_DIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_MONTH_DIM_TRIG
                    BEFORE INSERT
                    ON BAM_MONTH_DIM
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_MESSAGE_USER_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_OPERATION (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_OP_NAME VARCHAR2(255) NOT NULL,
  BAM_DESCRIPTION VARCHAR2(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_OPERATION_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_TRIG
                    BEFORE INSERT
                    ON BAM_OPERATION
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_OPERATION_DATA (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_REQ_COUNT INT NOT NULL,
  BAM_CUM_RES_COUNT INT NOT NULL,
  BAM_CUM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_OPERATION_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_OPERATION_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_OPERATION_STAT_DAY_FACT (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_DAY_ID INT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /

CREATE SEQUENCE BAM_OPERATION_STAT_DAY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_STAT_DAY_TRIG
                    BEFORE INSERT
                    ON BAM_OPERATION_STAT_DAY_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_STAT_DAY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_OPERATION_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE  BAM_OPERATION_STAT_HOUR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER  BAM_OPERATION_STAT_HOUR_TRIG
                    BEFORE INSERT
                    ON  BAM_OPERATION_STAT_HOUR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT  BAM_OPERATION_STAT_HOUR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_OPERATION_STAT_MONTH_FACT (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_OPERATION_STAT_MONTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_STAT_MONTH_TRIG
                    BEFORE INSERT
                    ON  BAM_OPERATION_STAT_MONTH_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_STAT_MONTH_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_OPERATION_STAT_QTR_FACT (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_OPERATION_STAT_QTR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_STAT_QTR_TRIG
                    BEFORE INSERT
                    ON  BAM_OPERATION_STAT_QTR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_STAT_QTR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_OPERATION_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_OPERATION_STAT_YEAR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_STAT_YEAR_TRIG
                    BEFORE INSERT
                    ON  BAM_OPERATION_STAT_YEAR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_STAT_YEAR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_OPERATION_USER_DATA (
  BAM_ID INT NOT NULL,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_KEY VARCHAR2(255) NOT NULL,
  BAM_VALUE VARCHAR2(1024) NOT NULL,
  PRIMARY KEY (BAM_ID))
/
CREATE SEQUENCE BAM_OPERATION_USER_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_OPERATION_USER_TRIG
                    BEFORE INSERT
                    ON  BAM_OPERATION_USER_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_OPERATION_USER_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_PROXY_STAT_DAY_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_PROXY_STAT_DAY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_PROXY_STAT_DAY_TRIG
                    BEFORE INSERT
                    ON  BAM_PROXY_STAT_DAY_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_PROXY_STAT_DAY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_PROXY_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_PROXY_STAT_HOUR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_PROXY_STAT_HOUR_TRIG
                    BEFORE INSERT
                    ON  BAM_PROXY_STAT_HOUR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_PROXY_STAT_HOUR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_PROXY_STAT_MONTH_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_PROXY_STAT_MONTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_PROXY_STAT_MONTH_TRIG
                    BEFORE INSERT
                    ON BAM_PROXY_STAT_MONTH_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_PROXY_STAT_MONTH_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_PROXY_STAT_QTR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_PROXY_STAT_QTR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_PROXY_STAT_QTR_TRIG
                    BEFORE INSERT
                    ON BAM_PROXY_STAT_QTR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_PROXY_STAT_QTR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_PROXY_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_PROXY_STAT_YEAR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_PROXY_STAT_YEAR_TRIG
                    BEFORE INSERT
                    ON BAM_PROXY_STAT_YEAR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_PROXY_STAT_YEAR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_QTR_DIM (
  BAM_ID INT NOT NULL,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_NAME VARCHAR2(24),
  BAM_NO INT NOT NULL,
  BAM_YEAR INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_QTR_DIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_QTR_DIM_TRIG
                    BEFORE INSERT
                    ON BAM_QTR_DIM
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_QTR_DIM_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SEQUENCE_STAT_DAY_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SEQUENCE_STAT_DAY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SEQUENCE_STAT_DAY_TRIG
                    BEFORE INSERT
                    ON BAM_SEQUENCE_STAT_DAY_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SEQUENCE_STAT_DAY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SEQUENCE_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SEQUENCE_STAT_HOUR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SEQUENCE_STAT_HOUR_TRIG
                    BEFORE INSERT
                    ON BAM_SEQUENCE_STAT_HOUR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SEQUENCE_STAT_HOUR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SEQUENCE_STAT_MONTH_FACT (
  BAM_ID INT  NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SEQUENCE_STAT_MONTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SEQUENCE_STAT_MONTH_TRIG
                    BEFORE INSERT
                    ON BAM_SEQUENCE_STAT_MONTH_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SEQUENCE_STAT_MONTH_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;

/

CREATE TABLE  BAM_SEQUENCE_STAT_QTR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SEQUENCE_STAT_QTR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SEQUENCE_STAT_QTR_TRIG
                    BEFORE INSERT
                    ON BAM_SEQUENCE_STAT_QTR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SEQUENCE_STAT_QTR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_SEQUENCE_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR2(512) NOT NULL,
  BAM_DIRECTION VARCHAR2(10) NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SEQUENCE_STAT_YEAR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SEQUENCE_STAT_YEAR_TRIG
                    BEFORE INSERT
                    ON BAM_SEQUENCE_STAT_YEAR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SEQUENCE_STAT_YEAR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVER (
  BAM_SERVER_ID INT NOT NULL,
  BAM_TENENT_ID INT DEFAULT NULL,
  BAM_TYPE VARCHAR2(128) NOT NULL,
  BAM_CATEGORY INT DEFAULT NULL,
  BAM_URL VARCHAR2(255) NOT NULL,
  BAM_ACTIVE NUMBER(1) NOT NULL,
  BAM_DESCRIPTION VARCHAR2(1024) DEFAULT NULL,
  BAM_EPR VARCHAR2(255) DEFAULT NULL,
  BAM_SUBSCRIPTION_ID VARCHAR2(255) DEFAULT NULL,
  USERNAME VARCHAR2(255) DEFAULT NULL,
  PASSWORD VARCHAR2(255) DEFAULT NULL,
  PRIMARY KEY (BAM_SERVER_ID))
 /
CREATE SEQUENCE BAM_SERVER_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_SEQ.nextval INTO :NEW.BAM_SERVER_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER BAM_SERVER_ACTIVE_TRIG
 BEFORE INSERT OR UPDATE
 ON BAM_SERVER
 FOR EACH ROW

   BEGIN
      IF INSERTING THEN
      /* Manage Default Values if a new value is NULL */
         IF :new.BAM_ACTIVE IS NULL THEN
            :new.BAM_ACTIVE := '1';
         END IF;
      END IF;
         END;
/

CREATE TABLE BAM_SERVER_CATEGORY (
  BAM_CATEGORY INT NOT NULL ,
  BAM_CATEGORY_NAME VARCHAR(45) NOT NULL ,
  PRIMARY KEY (BAM_CATEGORY))
/
CREATE TABLE  BAM_SERVER_DATA (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_FAULT_COUNT INT NOT NULL,
  BAM_CUM_REQ_COUNT INT NOT NULL,
  BAM_CUM_RES_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVER_DATA_SEQ  START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_SERVER_LOGIN_DATA (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_CUM_LOGIN_ATTEMPTS INT NOT NULL,
  BAM_CUM_FAILED_LOGIN_ATTEMPTS INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVER_LOGIN_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_LOGIN_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_LOGIN_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_LOGIN_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE  BAM_SERVER_STAT_DAY_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVER_STAT_DAY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_STAT_DAY_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_STAT_DAY_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_STAT_DAY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;

/
CREATE TABLE BAM_SERVER_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVER_STAT_HOUR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_STAT_HOUR_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_STAT_HOUR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_STAT_HOUR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVER_STAT_MONTH_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVER_STAT_MONTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_STAT_MONTH_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_STAT_MONTH_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_STAT_MONTH_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVER_STAT_QTR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVER_STAT_QTR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_STAT_QTR_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_STAT_QTR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_STAT_QTR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVER_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVER_STAT_YEAR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_STAT_YEAR_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_STAT_YEAR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_STAT_YEAR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_SERVER_USER_DATA (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_KEY VARCHAR2(255) NOT NULL,
  BAM_VALUE VARCHAR2(1024) NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVER_USER_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_USER_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_USER_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_USER_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVER_USER_LOGIN_DATA (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_USER_NAME VARCHAR2(45) NOT NULL,
  BAM_CUM_LOGIN_ATTEMPTS INT NOT NULL,
  BAM_CUM_FAILED_LOGIN_ATTEMPTS INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVER_USER_LOGIN_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVER_USER_LOGIN_TRIG
                    BEFORE INSERT
                    ON BAM_SERVER_USER_LOGIN_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVER_USER_LOGIN_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_SERVICE (
  BAM_ID INT NOT NULL,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SERVICE_NAME VARCHAR2(255) NOT NULL,
  BAM_DESCRIPTION VARCHAR2(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVICE_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVICE_DATA (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_REQ_COUNT INT NOT NULL,
  BAM_CUM_RES_COUNT INT NOT NULL,
  BAM_CUM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVICE_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVICE_STAT_DAY_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVICE_STAT_DAY_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_STAT_DAY_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_STAT_DAY_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_STAT_DAY_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVICE_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVICE_STAT_HOUR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_STAT_HOUR_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_STAT_HOUR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_STAT_HOUR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_SERVICE_STAT_MONTH_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVICE_STAT_MONTH_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_STAT_MONTH_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_STAT_MONTH_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_STAT_MONTH_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVICE_STAT_QTR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
  /
CREATE SEQUENCE BAM_SERVICE_STAT_QTR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_STAT_QTR_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_STAT_QTR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_STAT_QTR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/


CREATE TABLE BAM_SERVICE_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVICE_STAT_YEAR_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_STAT_YEAR_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_STAT_YEAR_FACT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_STAT_YEAR_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE BAM_SERVICE_USER_DATA (
  BAM_ID INT NOT NULL,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_KEY VARCHAR2(255) NOT NULL,
  BAM_VALUE VARCHAR2(1024) NOT NULL,
  PRIMARY KEY (BAM_ID))
 /
CREATE SEQUENCE BAM_SERVICE_USER_DATA_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_SERVICE_USER_DATA_TRIG
                    BEFORE INSERT
                    ON BAM_SERVICE_USER_DATA
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_SERVICE_USER_DATA_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/

CREATE TABLE  BAM_TENENT (
  BAM_TENENT_ID INT NOT NULL,
  BAM_DESCRIPTION VARCHAR2(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_TENENT_ID))
/
CREATE SEQUENCE BAM_TENENT_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_TENENT_TRIG
                    BEFORE INSERT
                    ON BAM_TENENT
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_TENENT_SEQ.nextval INTO :NEW.BAM_TENENT_ID  FROM dual;
                    END;
/

CREATE TABLE BAM_YEAR_DIM (
  BAM_ID INT NOT NULL,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL,
  BAM_NO INT NOT NULL,
  PRIMARY KEY (BAM_ID))
/
CREATE SEQUENCE BAM_YEAR_DIM_SEQ START WITH 1 INCREMENT BY 1 NOCACHE
/
CREATE OR REPLACE TRIGGER BAM_YEAR_DIM_TRIG
                    BEFORE INSERT
                    ON BAM_YEAR_DIM
                    REFERENCING NEW AS NEW
                    FOR EACH ROW
                     BEGIN
                       SELECT BAM_YEAR_DIM_SEQ.nextval INTO :NEW.BAM_ID FROM dual;
                    END;
/
CREATE OR REPLACE TRIGGER TIMESTAMP_TRIG
    AFTER LOGON ON DATABASE
   BEGIN
      EXECUTE IMMEDIATE 'ALTER SESSION SET NLS_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS"';
   END;

/

 ALTER TABLE BAM_DAY_DIM
  ADD CONSTRAINT BAM_DAY_DIM_IBFK_1 FOREIGN KEY (BAM_MONTH) REFERENCES BAM_MONTH_DIM (BAM_ID)
 /
CREATE INDEX BAM_DAY_DIM_IN_BY_MONTH ON BAM_DAY_DIM(BAM_MONTH)
/

ALTER TABLE BAM_ENDPOINT_STAT_DAY_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_DAY_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)
/
  ALTER TABLE BAM_ENDPOINT_STAT_DAY_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_DAY_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_DAY_IN_BY_SVR_ID ON BAM_ENDPOINT_STAT_DAY_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_DAY_IN_BY_DAY_ID ON BAM_ENDPOINT_STAT_DAY_FACT(BAM_DAY_ID)
/
ALTER TABLE BAM_ENDPOINT_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_HOUR_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)
/
ALTER TABLE BAM_ENDPOINT_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_HOUR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_HR_IN_BY_SVR_ID ON BAM_ENDPOINT_STAT_HOUR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_HR_IN_BY_HR_ID ON BAM_ENDPOINT_STAT_HOUR_FACT(BAM_HOUR_ID)
/

ALTER TABLE BAM_ENDPOINT_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_MONTH_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)
 /
ALTER TABLE BAM_ENDPOINT_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_MONTH_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_MTH_IN_BY_SVR_ID ON BAM_ENDPOINT_STAT_MONTH_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_MTH_IN_BY_MTH_ID ON BAM_ENDPOINT_STAT_MONTH_FACT(BAM_MONTH_ID)
/

ALTER TABLE BAM_ENDPOINT_STAT_QTR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_QTR_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)
/
 ALTER TABLE BAM_ENDPOINT_STAT_QTR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_QTR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_QTR_IN_BY_SVR_ID ON BAM_ENDPOINT_STAT_QTR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_QTR_IN_BY_QTR_ID ON BAM_ENDPOINT_STAT_QTR_FACT(BAM_QTR_ID)
/

ALTER TABLE BAM_ENDPOINT_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_YEAR_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)
 /
  ALTER TABLE BAM_ENDPOINT_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_YEAR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_YR_IN_BY_SVR_ID ON BAM_ENDPOINT_STAT_YEAR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_ENDP_STAT_YR_IN_BY_YR_ID ON BAM_ENDPOINT_STAT_YEAR_FACT(BAM_YEAR_ID)
/

ALTER TABLE BAM_HOUR_DIM
  ADD CONSTRAINT BAM_HOUR_DIM_IBFK_1 FOREIGN KEY (BAM_DAY) REFERENCES BAM_DAY_DIM (BAM_ID)
/
CREATE INDEX BAM_HOUR_DIM_IN_BY_DAY_ID ON BAM_HOUR_DIM(BAM_DAY)
/

ALTER TABLE BAM_MESSAGE
  ADD CONSTRAINT FK_BAM_MESSAGE_1 FOREIGN KEY (BAM_OP_ID) REFERENCES BAM_OPERATION (BAM_ID)
 /
  ALTER TABLE BAM_MESSAGE
  ADD CONSTRAINT FK_BAM_MESSAGE_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID)
/
ALTER TABLE BAM_MESSAGE_USER_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_USER_DATA_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID)
/

ALTER TABLE BAM_MONTH_DIM
  ADD CONSTRAINT BAM_MONTH_DIM_IBFK_1 FOREIGN KEY (BAM_QTR) REFERENCES BAM_QTR_DIM (BAM_ID)
/
CREATE INDEX BAM_MONTH_DIM_IN_BY_QTR_ID ON BAM_MONTH_DIM(BAM_QTR)
/

ALTER TABLE BAM_OPERATION
  ADD CONSTRAINT FK_BAM_OPERATION_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_OPERATION_IN_BY_OP_NAME ON BAM_OPERATION(BAM_OP_NAME)
/
CREATE INDEX BAM_OPERATION_IN_BY_SERVICE_ID ON BAM_OPERATION(BAM_OP_NAME,BAM_SERVICE_ID)
/

ALTER TABLE BAM_OPERATION_DATA
  ADD CONSTRAINT FK_BAM_OPERATION_DATA_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/

ALTER TABLE BAM_OPERATION_STAT_DAY_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_DAY_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)
/
ALTER TABLE   BAM_OPERATION_STAT_DAY_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_DAY_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/
CREATE INDEX BAM_OP_STAT_DAY_IN_BY_DAY_ID ON BAM_OPERATION_STAT_DAY_FACT(BAM_DAY_ID)
/
CREATE INDEX BAM_OP_STAT_DAY_IN_BY_OP_ID ON BAM_OPERATION_STAT_DAY_FACT(BAM_OPERATION_ID,BAM_DAY_ID)
/

ALTER TABLE BAM_OPERATION_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_HOUR_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)
/
  ALTER TABLE BAM_OPERATION_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_HOUR_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/
CREATE INDEX BAM_OP_STAT_HOUR_IN_BY_DAY_ID ON BAM_OPERATION_STAT_HOUR_FACT(BAM_HOUR_ID)
/
CREATE INDEX BAM_OP_STAT_HOUR_IN_BY_OP_ID ON BAM_OPERATION_STAT_HOUR_FACT(BAM_OPERATION_ID,BAM_HOUR_ID)
/

ALTER TABLE BAM_OPERATION_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_MONH_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)
/
   ALTER TABLE BAM_OPERATION_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_MONH_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/
CREATE INDEX BAM_OP_STAT_MONTH_IN_BY_DAY_ID ON BAM_OPERATION_STAT_MONTH_FACT(BAM_MONTH_ID)
/
CREATE INDEX BAM_OP_STAT_MONTH_IN_BY_OP_ID ON BAM_OPERATION_STAT_MONTH_FACT(BAM_OPERATION_ID)
/

ALTER TABLE BAM_OPERATION_STAT_QTR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_QTR_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)
/
    ALTER TABLE BAM_OPERATION_STAT_QTR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_QTR_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/
CREATE INDEX BAM_OP_STAT_QTR_IN_BY_DAY_ID ON BAM_OPERATION_STAT_QTR_FACT(BAM_QTR_ID)
/
CREATE INDEX BAM_OP_STAT_QTR_IN_BY_OP_ID ON BAM_OPERATION_STAT_QTR_FACT(BAM_OPERATION_ID)
/

ALTER TABLE BAM_OPERATION_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_YEAR_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)
/
  ALTER TABLE BAM_OPERATION_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_YEAR_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/
CREATE INDEX BAM_OP_STAT_YR_IN_BY_YR_ID ON BAM_OPERATION_STAT_YEAR_FACT(BAM_YEAR_ID)
/
CREATE INDEX BAM_OP_STAT_YR_IN_BY_OP_ID ON BAM_OPERATION_STAT_YEAR_FACT(BAM_OPERATION_ID)
/

ALTER TABLE BAM_OPERATION_USER_DATA
  ADD CONSTRAINT FK_BAM_OPERATION_USER_DATA_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID)
/
CREATE INDEX BAM_OP_USER_DATA_IN_BY_OP_ID ON BAM_OPERATION_USER_DATA(BAM_KEY)
/

ALTER TABLE BAM_PROXY_STAT_DAY_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)
/
  ALTER TABLE BAM_PROXY_STAT_DAY_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_PXY_STAT_DAY_IN_BY_SR_ID ON BAM_PROXY_STAT_DAY_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_PXY_STAT_DAY_IN_BY_DY_ID ON BAM_PROXY_STAT_DAY_FACT(BAM_DAY_ID)
/
ALTER TABLE BAM_PROXY_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_HOUR_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)
/
  ALTER TABLE BAM_PROXY_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_HOUR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_HR_IN_BY_SER_ID ON BAM_PROXY_STAT_HOUR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_HR_IN_BY_HR_ID ON BAM_PROXY_STAT_HOUR_FACT(BAM_HOUR_ID)
/

ALTER TABLE BAM_PROXY_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_MONTH_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)
/
  ALTER TABLE BAM_PROXY_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_MONTH_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_MTH_IN_BY_SR_ID ON BAM_PROXY_STAT_MONTH_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_MTH_IN_BY_MH_ID ON BAM_PROXY_STAT_MONTH_FACT(BAM_MONTH_ID)
/

ALTER TABLE BAM_PROXY_STAT_QTR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_QTR_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)
/
  ALTER TABLE BAM_PROXY_STAT_QTR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_QTR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_QTR_IN_BY_SR_ID ON BAM_PROXY_STAT_QTR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_QTR_IN_BY_QU_ID ON BAM_PROXY_STAT_QTR_FACT(BAM_QTR_ID)
/

ALTER TABLE BAM_PROXY_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_YEAR_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)
/
  ALTER TABLE BAM_PROXY_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_YEAR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_YR_IN_BY_SR_ID ON BAM_PROXY_STAT_YEAR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_PROXY_STAT_YR_IN_BY_YR_ID ON BAM_PROXY_STAT_YEAR_FACT(BAM_YEAR_ID)
/

ALTER TABLE BAM_QTR_DIM
  ADD CONSTRAINT BAM_QTR_DIM_IBFK_1 FOREIGN KEY (BAM_YEAR) REFERENCES BAM_YEAR_DIM (BAM_ID)
/
CREATE INDEX BAM_QTR_DIM_IN_BY_YR_ID ON BAM_QTR_DIM(BAM_YEAR)
/

ALTER TABLE BAM_SEQUENCE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_DAY_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)
/
  ALTER TABLE BAM_SEQUENCE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_DAY_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_DAY_IN_BY_SR_ID ON BAM_SEQUENCE_STAT_DAY_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_DAY_IN_BY_DAY_ID ON BAM_SEQUENCE_STAT_DAY_FACT(BAM_DAY_ID)
/

ALTER TABLE BAM_SEQUENCE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_HOUR_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)
/
  ALTER TABLE BAM_SEQUENCE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_HOUR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_HR_IN_BY_SR_ID ON BAM_SEQUENCE_STAT_HOUR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_HR_IN_BY_HR_ID ON BAM_SEQUENCE_STAT_HOUR_FACT(BAM_HOUR_ID)
/
ALTER TABLE BAM_SEQUENCE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_MONTH_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)
/
  ALTER TABLE BAM_SEQUENCE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_MONTH_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_MTH_IN_BY_SR_ID ON BAM_SEQUENCE_STAT_MONTH_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_MTH_IN_BY_MTH_ID ON BAM_SEQUENCE_STAT_MONTH_FACT(BAM_MONTH_ID)
/

ALTER TABLE BAM_SEQUENCE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_QTR_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)
/
  ALTER TABLE BAM_SEQUENCE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_QTR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_QTR_IN_BY_SR_ID ON BAM_SEQUENCE_STAT_QTR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_QTR_IN_BY_QU_ID ON BAM_SEQUENCE_STAT_QTR_FACT(BAM_QTR_ID)
/

ALTER TABLE BAM_SEQUENCE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_YEAR_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)
 /
  ALTER TABLE BAM_SEQUENCE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_YEAR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_YR_IN_BY_SR_ID ON BAM_SEQUENCE_STAT_YEAR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SEQ_STAT_YR_IN_BY_YR_ID ON BAM_SEQUENCE_STAT_YEAR_FACT(BAM_YEAR_ID)
/

ALTER TABLE BAM_SERVER_DATA
  ADD CONSTRAINT FK_BAM_SERVER_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_DATA_IN_BY_TIME ON BAM_SERVER_DATA(BAM_TIMESTAMP)
/

ALTER TABLE BAM_SERVER_LOGIN_DATA
  ADD CONSTRAINT FK_BAM_SERVER1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/

ALTER TABLE BAM_SERVER_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_DAY_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVER_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_DAY_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SEVR_STAT_DAY_IN_BY_SR_ID ON BAM_SERVER_STAT_DAY_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SEVR_STAT_DAY_IN_BY_DAY_ID ON BAM_SERVER_STAT_DAY_FACT(BAM_DAY_ID)
/

ALTER TABLE BAM_SERVER_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_HOUR_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)
 /
  ALTER TABLE BAM_SERVER_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_HOUR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_STAT_HR_IN_BY_SR_ID ON BAM_SERVER_STAT_HOUR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_STAT_HR_IN_BY_HR_ID ON BAM_SERVER_STAT_HOUR_FACT(BAM_HOUR_ID)
/

ALTER TABLE BAM_SERVER_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_MONTH_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVER_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_MONTH_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_STAT_MH_IN_BY_SR_ID ON BAM_SERVER_STAT_MONTH_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_STAT_MH_IN_BY_MH_ID ON BAM_SERVER_STAT_MONTH_FACT(BAM_MONTH_ID)
/

ALTER TABLE BAM_SERVER_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_QTR_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVER_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_QTR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SVR_STAT_QTR_IN_BY_SR_ID ON BAM_SERVER_STAT_QTR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SVR_STAT_QTR_IN_BY_QU_ID ON BAM_SERVER_STAT_QTR_FACT(BAM_QTR_ID)
/

ALTER TABLE BAM_SERVER_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_YEAR_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVER_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_YEAR_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_STAT_YR_IN_BY_SR_ID ON BAM_SERVER_STAT_YEAR_FACT(BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_STAT_YR_IN_BY_YR_ID ON BAM_SERVER_STAT_YEAR_FACT(BAM_YEAR_ID)
/

ALTER TABLE BAM_SERVER_USER_DATA
  ADD CONSTRAINT FK_BAM_SERVER_USER_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVER_USR_DATA_IN_BY_KEY ON BAM_SERVER_USER_DATA(BAM_KEY)
/

ALTER TABLE BAM_SERVER_USER_LOGIN_DATA
  ADD CONSTRAINT FK_BAM_SERVER_USER_LOGIN_DATA FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/


ALTER TABLE BAM_SERVER 
  ADD CONSTRAINT FK_BAM_SERVER_1 FOREIGN KEY (BAM_CATEGORY) REFERENCES BAM_SERVER_CATEGORY (BAM_CATEGORY)
/
CREATE INDEX BAM_SERVER_IN_BY_CATEGORY ON BAM_SERVER (BAM_CATEGORY)
/
ALTER TABLE BAM_SERVICE
  ADD CONSTRAINT FK_BAM_SERVICE_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID)
/
CREATE INDEX BAM_SERVICE_IN_BY_NAME ON BAM_SERVICE(BAM_SERVICE_NAME)
/

ALTER TABLE BAM_SERVICE_DATA
  ADD CONSTRAINT FK_BAM_SERVICE_DATA_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/

ALTER TABLE BAM_SERVICE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_DAY_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVICE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_DAY_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_SERVI_STAT_DAY_IN_BY_SR_ID ON BAM_SERVICE_STAT_DAY_FACT(BAM_SERVICE_ID)
/
CREATE INDEX BAM_SERVI_STAT_DAY_IN_BY_DY_ID ON BAM_SERVICE_STAT_DAY_FACT(BAM_DAY_ID)
/

ALTER TABLE BAM_SERVICE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_HOUR_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVICE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_HOUR_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_SERVI_STAT_HR_IN_BY_SR_ID ON BAM_SERVICE_STAT_HOUR_FACT(BAM_SERVICE_ID)
/
CREATE INDEX BAM_SERVI_STAT_HR_IN_BY_HR_ID ON BAM_SERVICE_STAT_HOUR_FACT(BAM_HOUR_ID)
/
ALTER TABLE BAM_SERVICE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_MONTH_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVICE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_MONTH_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_SERVI_STAT_MTH_IN_BY_SR_ID ON BAM_SERVICE_STAT_MONTH_FACT(BAM_SERVICE_ID)
/
CREATE INDEX BAM_SERVI_STAT_MTH_IN_BY_MH_ID ON BAM_SERVICE_STAT_MONTH_FACT(BAM_MONTH_ID)
/
ALTER TABLE BAM_SERVICE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_QTR_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)
/
  ALTER TABLE BAM_SERVICE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_QTR_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_SERV_STAT_QTR_IN_BY_SR_ID ON BAM_SERVICE_STAT_QTR_FACT(BAM_SERVICE_ID)
/
CREATE INDEX BAM_SERV_STAT_QTR_IN_BY_QU_ID ON BAM_SERVICE_STAT_QTR_FACT(BAM_QTR_ID)
/

ALTER TABLE BAM_SERVICE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_YEAR_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)
/
 ALTER TABLE BAM_SERVICE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_YEAR_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_SERV_STAT_YR_IN_BY_SR_ID ON BAM_SERVICE_STAT_YEAR_FACT(BAM_SERVICE_ID)
/
CREATE INDEX BAM_SERV_STAT_YR_IN_BY_YR_ID ON BAM_SERVICE_STAT_YEAR_FACT(BAM_YEAR_ID)
/

ALTER TABLE BAM_SERVICE_USER_DATA
  ADD CONSTRAINT FK_BAM_SERVICE_USER_DATA_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID)
/
CREATE INDEX BAM_SERV_USER_DATA_IN_BY_KEY ON BAM_SERVICE_USER_DATA(BAM_KEY)
/

ALTER TABLE BAM_MESSAGE_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID)
/
ALTER TABLE BAM_MESSAGE_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID)
/

ALTER TABLE BAM_MESSAGE_DATA_ARCHIVE
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_ARCHIVE_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID)
/
ALTER TABLE BAM_MESSAGE_DATA_ARCHIVE
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_ARCHIVE_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID)
/

ALTER TABLE BAM_MESSAGE_PROPERTIES
  ADD CONSTRAINT FK_BAM_MESSAGE_PROP_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID)
/
ALTER TABLE BAM_MESSAGE_PROPERTIES
  ADD CONSTRAINT FK_BAM_MESSAGE_PROP_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID)
/


INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (1, 'service');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (2, 'message');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (4, 'mediation');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (8, 'generic');
