/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;

public class BAMCalendar
extends GregorianCalendar {
    public static final String SQL_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final int QUATER = 50;

    public BAMCalendar() {
    }

    public static BAMCalendar getInstance(Calendar cal) {
        return new BAMCalendar(cal);
    }

    public static BAMCalendar getInstance() {
        return new BAMCalendar(Calendar.getInstance());
    }

    public BAMCalendar(int year, int month, int dayOfMonth) {
        super(year, month, dayOfMonth);
    }

    public BAMCalendar(int year, int month, int dayOfMonth, int hourOfDay, int minute) {
        super(year, month, dayOfMonth, hourOfDay, minute);
    }

    private BAMCalendar(Calendar cal) {
        this.setTime(cal.getTime());
    }

    @Override
    public int get(int field) {
        this.complete();
        if (field == 50) {
            return super.get(2) / 3;
        }
        return super.get(field);
    }

    public static Calendar parseTimestamp(String timestamp) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SQL_DATE_FORMAT, Locale.ENGLISH);
        Date date = dateFormat.parse(timestamp);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public String getBAMTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(SQL_DATE_FORMAT, Locale.ENGLISH);
        String dateString = dateFormat.format(this.getTime());
        return dateString;
    }

    public static BAMCalendar getYear(BAMCalendar cal) {
        return new BAMCalendar(cal.get(1), 0, 1, 0, 0);
    }

    public static BAMCalendar getQuarter(BAMCalendar cal) {
        int startMonth = cal.get(50) * 3;
        return new BAMCalendar(cal.get(1), startMonth, 1, 0, 0);
    }

    public static BAMCalendar getMonth(BAMCalendar cal) {
        return new BAMCalendar(cal.get(1), cal.get(2), 1, 0, 0);
    }

    public static BAMCalendar getDay(BAMCalendar cal) {
        return new BAMCalendar(cal.get(1), cal.get(2), cal.get(5), 0, 0);
    }

    public static BAMCalendar getHour(BAMCalendar cal) {
        return new BAMCalendar(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0);
    }

    @Override
    public void add(int field, int amount) {
        if (field == 50) {
            super.add(2, amount * 3);
        } else {
            super.add(field, amount);
        }
    }

    public static long timeTillMidNight() {
        Calendar midnight = Calendar.getInstance();
        midnight.add(5, 1);
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        midnight.set(14, 0);
        long midnightMillisSinceEpoch = midnight.getTimeInMillis();
        long nowMillisSinceEpoch = System.currentTimeMillis();
        long millisToMidnight = midnightMillisSinceEpoch - nowMillisSinceEpoch;
        return millisToMidnight;
    }

    public static String convertISOTimeStamp(String timestamp) {
        Calendar cal = DatatypeConverter.parseDateTime((String)"2010-10-21T00:45:37.000+06:00");
        SimpleDateFormat dateFormat = new SimpleDateFormat(SQL_DATE_FORMAT, Locale.ENGLISH);
        String dateString = dateFormat.format(cal.getTime());
        return dateString;
    }
}

