/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.util;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.proxy.AuthenticationAdminClient;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.clients.AuthenticationAdminClient_2_0_2;
import org.wso2.carbon.bam.core.clients.AuthenticationAdminClient_2_0_3;
import org.wso2.carbon.bam.core.clients.AuthenticationAdminClient_3_1_0;
import org.wso2.carbon.bam.core.clients.AuthenticationAdminClient_3_2_0;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.core.util.SessionCache;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.utils.NetworkUtils;

public class ClientAuthHandler {
    private static Log log = LogFactory.getLog(ClientAuthHandler.class);
    private static SessionCache sessionCache = new SessionCache();
    private static ClientAuthHandler handler = null;

    public static ClientAuthHandler getClientAuthHandler() {
        if (handler == null) {
            handler = new ClientAuthHandler();
        }
        return handler;
    }

    public static SessionCache getSessionCache() {
        return sessionCache;
    }

    public String getSessionString(ServerDO server) throws BAMException {
        if (sessionCache.getSessionString(server.getServerURL()) == null) {
            this.isAuthenticateWithServer(server);
        }
        return sessionCache.getSessionString(server.getServerURL());
    }

    public void authenticateForcefully(ServerDO server) throws BAMException {
        this.isAuthenticateWithServer(server);
    }

    private boolean authenticateWithServer_Carbon_3_0_0(ServerDO server) {
        boolean isLoggedIn = false;
        try {
            AuthenticationAdminClient authenticationAdminClient_3_0_0 = new AuthenticationAdminClient(BAMUtil.getConfigurationContextService().getClientConfigContext(), server.getServerURL() + "/services/", null, null, false);
            isLoggedIn = authenticationAdminClient_3_0_0.login(server.getUserName(), server.getPassword(), NetworkUtils.getLocalHostname());
            if (isLoggedIn) {
                ClientAuthHandler.getSessionCache().addSessionString(server.getServerURL(), authenticationAdminClient_3_0_0.getAdminCookie());
            }
        }
        catch (Throwable ignore) {
            log.debug((Object)("Carbon 300 authentication failed with server: " + server.toString()), ignore);
        }
        return isLoggedIn;
    }

    private boolean authenticateWithServer_Carbon_2_0_3(ServerDO server) {
        boolean isLoggedIn = false;
        try {
            AuthenticationAdminClient_2_0_3 authenticationAdminClient_2_0_3 = new AuthenticationAdminClient_2_0_3(server.getServerURL());
            isLoggedIn = authenticationAdminClient_2_0_3.authenticate(server.getUserName(), server.getPassword());
            if (isLoggedIn) {
                String sessionCookie = authenticationAdminClient_2_0_3.getSessionCookie();
                ClientAuthHandler.getSessionCache().addSessionString(server.getServerURL(), sessionCookie);
            }
        }
        catch (Throwable ignore) {
            log.debug((Object)("Carbon 203 authentication failed with server: " + server.toString()), ignore);
        }
        return isLoggedIn;
    }

    private boolean authenticateWithServer_Carbon_2_0_2(ServerDO server) {
        boolean isLoggedIn = false;
        try {
            AuthenticationAdminClient_2_0_2 authenticationAdminClient_2_0_2 = new AuthenticationAdminClient_2_0_2(server.getServerURL());
            isLoggedIn = authenticationAdminClient_2_0_2.authenticate(server.getUserName(), server.getPassword());
            if (isLoggedIn) {
                String sessionCookie = authenticationAdminClient_2_0_2.getSessionCookie();
                ClientAuthHandler.getSessionCache().addSessionString(server.getServerURL(), sessionCookie);
            }
        }
        catch (Throwable ignore) {
            log.debug((Object)("Carbon 202 authentication failed with server: " + server.toString()), ignore);
        }
        return isLoggedIn;
    }

    private boolean authenticateWithServer_Carbon_3_1_0(ServerDO server) {
        boolean isLoggedIn;
        block3: {
            isLoggedIn = false;
            try {
                AuthenticationAdminClient_3_1_0 authenticationAdminClient_3_1_0 = new AuthenticationAdminClient_3_1_0(server.getServerURL());
                isLoggedIn = authenticationAdminClient_3_1_0.authenticate(server.getUserName(), server.getPassword());
                if (isLoggedIn) {
                    String sessionCookie = authenticationAdminClient_3_1_0.getSessionCookie();
                    ClientAuthHandler.getSessionCache().addSessionString(server.getServerURL(), sessionCookie);
                }
            }
            catch (Throwable ignore) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Authentication failed with server: " + server.toString()), ignore);
            }
        }
        return isLoggedIn;
    }

    private boolean authenticateWithServer_Carbon_CurrentVersion(ServerDO server) {
        boolean isLoggedIn;
        block3: {
            isLoggedIn = false;
            try {
                AuthenticationAdminClient_3_2_0 authenticationAdminClient = new AuthenticationAdminClient_3_2_0(server.getServerURL());
                isLoggedIn = authenticationAdminClient.authenticate(server.getUserName(), server.getPassword());
                if (isLoggedIn) {
                    String sessionCookie = authenticationAdminClient.getSessionCookie();
                    ClientAuthHandler.getSessionCache().addSessionString(server.getServerURL(), sessionCookie);
                }
            }
            catch (Throwable ignore) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Authentication failed with server: " + server.toString()), ignore);
            }
        }
        return isLoggedIn;
    }

    public boolean isAuthenticateWithServer(ServerDO server) throws BAMException {
        boolean logInState = this.authenticateWithServer_Carbon_CurrentVersion(server);
        if (!(logInState || (logInState = this.authenticateWithServer_Carbon_3_1_0(server)) || (logInState = this.authenticateWithServer_Carbon_3_0_0(server)) || (logInState = this.authenticateWithServer_Carbon_2_0_3(server)) || (logInState = this.authenticateWithServer_Carbon_2_0_2(server)))) {
            log.info((Object)("Could not authenticate with server : " + server.getServerURL()));
        }
        return logInState;
    }

    public static boolean checkAuthException(AxisFault axisFault) {
        if (axisFault != null) {
            Throwable cause = axisFault.getCause();
            QName name = axisFault.getFaultCode();
            if (name != null && name.getLocalPart() != null && (name.getLocalPart().equals("50977") || name.getLocalPart().equals("WSO2CarbonAuthorizationFailure"))) {
                return true;
            }
            if (axisFault.getMessage().toLowerCase().indexOf("session timed out") != -1) {
                return true;
            }
            if (cause != null && cause instanceof AxisFault && (name = (axisFault = (AxisFault)cause).getFaultCode()) != null && name.getLocalPart() != null && (name.getLocalPart().equals("50977") || name.getLocalPart().equals("WSO2CarbonAuthorizationFailure"))) {
                return true;
            }
        }
        return false;
    }
}

