/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.util;

import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;

public class BackOffCounter {
    private static int[] backoffSequence = new int[]{0, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
    private static int MAX_RETRY_LEVEL = 8;
    private static ConcurrentHashMap<Integer, Integer> retryCountPerServer = new ConcurrentHashMap();
    private static ConcurrentHashMap<Integer, Integer> callCountPerServer = new ConcurrentHashMap();

    public static BackOffCounter getInstance() {
        return new BackOffCounter();
    }

    private void resetCallCount(ServerDO server) {
        callCountPerServer.put(server.getId(), 0);
    }

    private void incrementCallCount(ServerDO server) {
        int count = 0;
        if (callCountPerServer.containsKey(server.getId())) {
            count = callCountPerServer.get(server.getId());
        }
        if (count < MAX_RETRY_LEVEL) {
            callCountPerServer.put(server.getId(), count + 1);
        }
    }

    public void incrementFailCount(ServerDO server) {
        int count = 0;
        if (retryCountPerServer.containsKey(server.getId())) {
            count = retryCountPerServer.get(server.getId());
        }
        if (count < MAX_RETRY_LEVEL) {
            retryCountPerServer.put(server.getId(), count + 1);
        }
    }

    public void resetFailCount(ServerDO server) {
        this.resetCallCount(server);
        retryCountPerServer.put(server.getId(), 0);
    }

    public boolean shouldBackoff(ServerDO server) {
        int failCount = 0;
        int callCount = 0;
        if (retryCountPerServer.containsKey(server.getId())) {
            failCount = retryCountPerServer.get(server.getId());
        }
        if (callCountPerServer.containsKey(server.getId())) {
            callCount = callCountPerServer.get(server.getId());
        }
        this.incrementCallCount(server);
        if (failCount == 0) {
            return false;
        }
        return callCount % backoffSequence[failCount] != 0;
    }
}

