/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary.generators;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.clients.BAMServiceSummaryDSClient;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.stats.SummaryStatistic;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;

public class ServerSummaryGenerator
extends AbstractSummaryGenerator {
    private static final Log log = LogFactory.getLog(ServerSummaryGenerator.class);
    private ServerDO server;

    public ServerSummaryGenerator(ServerDO server, int timeInterval) {
        super(timeInterval);
        this.server = server;
    }

    @Override
    protected void summarizeHourly(BAMCalendar loHour, BAMCalendar hiHour) {
        block5: {
            try {
                TimeRange retention;
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                HourDimension hd = spm.getHourDimension((Calendar)loHour);
                if (hd == null) {
                    spm.addHourDimension(loHour);
                    hd = spm.getHourDimension((Calendar)loHour);
                }
                if ((stat = spm.getServerStatHourlySummary(this.getServer().getId(), loHour, hiHour)) != null) {
                    stat.setTypeId(this.getServer().getId());
                    stat.setTimeDimensionId(hd.getId());
                    SummaryPersistenceManager.getInstance().addServerStatHourlySummary(stat);
                }
                if ((retention = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).getDataRetentionPeriod()).getValue() != 0) {
                    BAMCalendar delLoHour = BAMCalendar.getInstance((Calendar)loHour);
                    BAMCalendar delHiHour = BAMCalendar.getInstance((Calendar)hiHour);
                    delHiHour.add(retention.getType(), -1 * retention.getValue());
                    delLoHour.add(retention.getType(), -1 * retention.getValue());
                    spm.deleteServerData(this.getServer().getId(), delLoHour, delHiHour);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)("Error while running hourly summary generator for server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeDaily(BAMCalendar loDay, BAMCalendar hiDay) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                DayDimension dd = spm.getDayDimension((Calendar)loDay);
                if (dd == null) {
                    spm.addHourDimension(loDay);
                    dd = spm.getDayDimension((Calendar)loDay);
                }
                if ((stat = spm.getServerStatDailySummary(this.getServer().getId(), loDay, hiDay)) != null) {
                    stat.setTypeId(this.getServer().getId());
                    stat.setTimeDimensionId(dd.getId());
                    SummaryPersistenceManager.getInstance().addServerStatDailySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running daily summary generator for server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeMonthly(BAMCalendar loMonth, BAMCalendar hiMonth) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                MonthDimension md = spm.getMonthDimension((Calendar)loMonth);
                if (md == null) {
                    spm.addMonthDimension(loMonth);
                    md = spm.getMonthDimension((Calendar)loMonth);
                }
                if ((stat = spm.getServerStatMonthlySummary(this.getServer().getId(), loMonth, hiMonth)) != null) {
                    stat.setTypeId(this.getServer().getId());
                    stat.setTimeDimensionId(md.getId());
                    SummaryPersistenceManager.getInstance().addServerStatMonthlySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running monthly summary generator for server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeQuarterly(BAMCalendar loQuarter, BAMCalendar hiQuarter) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                QuarterDimension qd = spm.getQuarterDimension((Calendar)loQuarter);
                if (qd == null) {
                    spm.addQuarterDimension(loQuarter);
                    qd = spm.getQuarterDimension((Calendar)loQuarter);
                }
                if ((stat = spm.getServerStatQuarterlySummary(this.getServer().getId(), loQuarter, hiQuarter)) != null) {
                    stat.setTypeId(this.getServer().getId());
                    stat.setTimeDimensionId(qd.getId());
                    SummaryPersistenceManager.getInstance().addServerStatQuarterlySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running quarterly summary generator for server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeYearly(BAMCalendar loYear, BAMCalendar hiYear) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                YearDimension md = spm.getYearDimension((Calendar)loYear);
                if (md == null) {
                    spm.addYearDimension(loYear);
                    md = spm.getYearDimension((Calendar)loYear);
                }
                if ((stat = spm.getServerStatYearlySummary(this.getServer().getId(), loYear, hiYear)) != null) {
                    stat.setTypeId(this.getServer().getId());
                    stat.setTimeDimensionId(md.getId());
                    SummaryPersistenceManager.getInstance().addServerStatYearlySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running yearly summary generator for server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestServerStatSummaryPeriod(this.getTimeInterval(), this.server.getId());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestServerStatSummaryPeriod(this.getTimeInterval(), this.server.getId());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestServerStatSummaryPeriod(this.getTimeInterval(), this.server.getId());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestDailySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestServerStatSummaryPeriod(this.getTimeInterval(), this.server.getId());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestServerStatSummaryPeriod(this.getTimeInterval(), this.server.getId());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    @Override
    protected String getInstanceInfo() {
        return "Server: " + this.server.getServerURL();
    }

    public ServerDO getServer() {
        return this.server;
    }
}

