/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary.generators;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.summary.generators.SummaryGenerator;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public abstract class AbstractSummaryGenerator
implements SummaryGenerator {
    private static final Log log = LogFactory.getLog(AbstractSummaryGenerator.class);
    private int timeInterval;

    public AbstractSummaryGenerator(int timeInterval) {
        this.timeInterval = timeInterval;
    }

    @Override
    public void generateSummary() throws BAMException {
        Calendar lastTime;
        Calendar nowTime = this.getCalendarWithZeroTimeFields(Calendar.getInstance());
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getClass().getSimpleName() + " | " + this.getTimeString() + "] " + "Time Now:" + BAMCalendar.getInstance((Calendar)nowTime).getBAMTimestamp()));
        }
        if ((lastTime = this.getLatestSummaryTime()) == null) {
            return;
        }
        Calendar zeroLastTime = this.getCalendarWithZeroTimeFields(lastTime);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getClass().getSimpleName() + " | " + this.getTimeString() + "] " + "Query last ran at:" + BAMCalendar.getInstance((Calendar)zeroLastTime).getBAMTimestamp()));
        }
        Calendar itrTime = (Calendar)zeroLastTime.clone();
        this.addTime(itrTime, 1);
        while (itrTime.compareTo(nowTime) < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getClass().getSimpleName() + " | " + this.getTimeString() + "] " + "Generating summary for:" + BAMCalendar.getInstance((Calendar)itrTime).getBAMTimestamp()));
            }
            BAMCalendar loTime = BAMCalendar.getInstance((Calendar)itrTime);
            BAMCalendar hiTime = (BAMCalendar)loTime.clone();
            this.addTime((Calendar)hiTime, 1);
            this.summarize(loTime, hiTime);
            this.addTime(itrTime, 1);
        }
    }

    protected abstract void summarizeHourly(BAMCalendar var1, BAMCalendar var2);

    protected abstract void summarizeDaily(BAMCalendar var1, BAMCalendar var2);

    protected abstract void summarizeMonthly(BAMCalendar var1, BAMCalendar var2);

    protected abstract void summarizeQuarterly(BAMCalendar var1, BAMCalendar var2);

    protected abstract void summarizeYearly(BAMCalendar var1, BAMCalendar var2);

    protected abstract Calendar getLatestYearlySummaryTime() throws BAMException;

    protected abstract Calendar getLatestQuarterlySummaryTime() throws BAMException;

    protected abstract Calendar getLatestMonthlySummaryTime() throws BAMException;

    protected abstract Calendar getLatestDailySummaryTime() throws BAMException;

    protected abstract Calendar getLatestHourlySummaryTime() throws BAMException;

    private void summarize(BAMCalendar loTime, BAMCalendar hiTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getClass().getSimpleName() + " | " + this.getTimeString() + "] Summary time: " + BAMCalendar.getInstance((Calendar)loTime).getBAMTimestamp() + ", " + this.getInstanceInfo()));
        }
        switch (this.getTimeInterval()) {
            case 11: {
                this.summarizeHourly(loTime, hiTime);
                break;
            }
            case 5: {
                this.summarizeDaily(loTime, hiTime);
                break;
            }
            case 2: {
                this.summarizeMonthly(loTime, hiTime);
                break;
            }
            case 50: {
                this.summarizeQuarterly(loTime, hiTime);
                break;
            }
            case 1: {
                this.summarizeYearly(loTime, hiTime);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected timeInterval");
            }
        }
    }

    private Calendar getLatestSummaryTime() throws BAMException {
        Calendar latestSummaryTime;
        switch (this.getTimeInterval()) {
            case 1: {
                latestSummaryTime = this.getLatestYearlySummaryTime();
                break;
            }
            case 50: {
                latestSummaryTime = this.getLatestQuarterlySummaryTime();
                break;
            }
            case 2: {
                latestSummaryTime = this.getLatestMonthlySummaryTime();
                break;
            }
            case 5: {
                latestSummaryTime = this.getLatestDailySummaryTime();
                break;
            }
            case 11: {
                latestSummaryTime = this.getLatestHourlySummaryTime();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected timeInterval");
            }
        }
        return latestSummaryTime;
    }

    protected Calendar getCalendarWithZeroTimeFields(Calendar cal) {
        BAMCalendar zeroCal;
        BAMCalendar tempCal = BAMCalendar.getInstance((Calendar)cal);
        switch (this.getTimeInterval()) {
            case 1: {
                zeroCal = BAMCalendar.getYear((BAMCalendar)tempCal);
                break;
            }
            case 50: {
                zeroCal = BAMCalendar.getQuarter((BAMCalendar)tempCal);
                break;
            }
            case 2: {
                zeroCal = BAMCalendar.getMonth((BAMCalendar)tempCal);
                break;
            }
            case 5: {
                zeroCal = BAMCalendar.getDay((BAMCalendar)tempCal);
                break;
            }
            case 11: {
                zeroCal = BAMCalendar.getHour((BAMCalendar)tempCal);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected timeInterval");
            }
        }
        return zeroCal;
    }

    protected String getTimeString() {
        switch (this.getTimeInterval()) {
            case 1: {
                return "Yearly";
            }
            case 50: {
                return "Quarterly";
            }
            case 2: {
                return "Monthly";
            }
            case 5: {
                return "Daily";
            }
            case 11: {
                return "Hourly";
            }
        }
        throw new IllegalArgumentException("Unexpected timeInterval");
    }

    protected void addTime(Calendar cal, int amount) {
        switch (this.getTimeInterval()) {
            case 50: {
                cal.add(2, amount * 3);
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                cal.add(this.getTimeInterval(), amount);
                break;
            }
            case 5: {
                cal.add(6, amount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected timeInterval");
            }
        }
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    protected abstract String getInstanceInfo();
}

