/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.common.MonitoredServerDTO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.clients.AuthenticationAdminClient_3_2_0;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.core.util.ClientAuthHandler;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.event.client.broker.BrokerClient;

public class BAMConfigAdminService
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(BAMConfigAdminService.class);
    static BAMPersistenceManager persistenceManager;

    public BAMConfigAdminService() {
        persistenceManager = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
    }

    public int addServer(ServerDO monitoredServer) throws BAMException {
        try {
            String urlStr = monitoredServer.getServerURL();
            URL url = new URL(urlStr);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            try {
                boolean authenticated;
                new Socket(url.getHost(), port);
                try {
                    AuthenticationAdminClient_3_2_0 authenticationAdminClient = new AuthenticationAdminClient_3_2_0(monitoredServer.getServerURL());
                    authenticated = authenticationAdminClient.authenticate(monitoredServer.getUserName(), monitoredServer.getPassword());
                }
                catch (Exception e) {
                    if (e.getMessage().indexOf("404") > 0) {
                        return 5;
                    }
                    authenticated = ClientAuthHandler.getClientAuthHandler().isAuthenticateWithServer(monitoredServer);
                }
                if (authenticated) {
                    int stateOfServerAdded = persistenceManager.addMonitoredServer(monitoredServer);
                    return stateOfServerAdded;
                }
                return 3;
            }
            catch (IOException e) {
                return 2;
            }
        }
        catch (MalformedURLException e) {
            return 4;
        }
    }

    public void deactivateServer(int serverID) throws BAMException {
        persistenceManager.deactivateServer(serverID);
    }

    public void activateServer(int serverID, String subscriptionID) throws BAMException {
        persistenceManager.activateServer(serverID, subscriptionID);
    }

    public void removeServer(MonitoredServerDTO dto) throws BAMException {
        persistenceManager.removeMonitoredServer(dto.getServerId());
    }

    public void updateServer(ServerDO server) throws BAMException {
        if (server != null) {
            persistenceManager.updateMonitoredServer(server);
        }
    }

    public ServerDO[] getServerList() throws BAMException {
        int tenantId = BAMUtil.getTenantID(this.getTenantDomain());
        List<ServerDO> serverList = persistenceManager.getMonitoredServers(tenantId);
        if (serverList != null) {
            return serverList.toArray(new ServerDO[serverList.size()]);
        }
        return new ServerDO[0];
    }

    public ServerDO getServerDetails(int serverId) throws BAMException {
        ServerDO server = persistenceManager.getMonitoredServer(serverId);
        return server;
    }

    public String getDataRetentionPeriod() throws BAMException {
        TimeRange timeRange = null;
        try {
            timeRange = persistenceManager.getDataRetentionPeriod();
        }
        catch (BAMException e) {
            throw new BAMException("Error occurred getting DataRetentionPeriod", (Throwable)e);
        }
        return timeRange.toString();
    }

    public void setDataRetentionPeriod(String timeRange) throws BAMException {
        persistenceManager.updateDataRetentionPeriod(TimeRange.parseTimeRange((String)timeRange));
    }

    public String getDataArchivalPeriod() throws BAMException {
        TimeRange timeRange = persistenceManager.getDataArchivalPeriod();
        return timeRange.toString();
    }

    public void setDataArchivalPeriod(String timeRange) throws BAMException {
        persistenceManager.updateDataArchivalPeriod(TimeRange.parseTimeRange((String)timeRange));
    }

    public static String subscribe(String topic, String brokerURL, String subscriberURL, String serverURL, String userName, String password) throws BAMException {
        String subId = null;
        try {
            BrokerClient client = BAMUtil.getBrokerClient(brokerURL, userName, password);
            subId = client.subscribe(topic, subscriberURL);
            log.info((Object)("Subscription to server:" + serverURL + " with subscriber URL: " + subscriberURL + " and topic:" + topic + " is successful.."));
        }
        catch (Exception e) {
            try {
                ServerDO server = new ServerDO();
                server.setServerURL(serverURL);
                server.setUserName(userName);
                server.setPassword(password);
                boolean authenticated = ClientAuthHandler.getClientAuthHandler().isAuthenticateWithServer(server);
                if (authenticated) {
                    String cookie = ClientAuthHandler.getClientAuthHandler().getSessionString(server);
                    String brokerURL_2_0_3 = serverURL + "/services/BAMServiceStatisticsPublisherService";
                    subId = BAMUtil.getBrokerClient(brokerURL_2_0_3, cookie).subscribe(topic, subscriberURL);
                }
            }
            catch (Exception innerException) {
                log.error((Object)("BAM cannot suscribe to " + subscriberURL), (Throwable)innerException);
                throw new BAMException("Failed to subscribe : " + subscriberURL + "to topic : " + topic, (Throwable)innerException);
            }
        }
        return subId;
    }

    public static void unsubscribe(String brokerURL, String identifier, String serverType, String serverURL) throws BAMException {
        ServerDO monitoredServer = null;
        try {
            monitoredServer = persistenceManager.getMonitoredServer(serverURL);
            BrokerClient client = new BrokerClient(BAMUtil.getConfigurationContextService().getServerConfigContext(), brokerURL, monitoredServer.getUserName(), monitoredServer.getPassword());
            client.unsubscribe(identifier);
        }
        catch (Exception e) {
            try {
                ServerDO server = new ServerDO();
                server.setServerURL(serverURL);
                server.setUserName(monitoredServer.getUserName());
                server.setPassword(monitoredServer.getPassword());
                boolean authenticated = ClientAuthHandler.getClientAuthHandler().isAuthenticateWithServer(server);
                if (!authenticated) {
                    throw e;
                }
                String cookie = ClientAuthHandler.getClientAuthHandler().getSessionString(server);
                String brokerURL_2_0_3 = serverURL + "/services/BAMServiceStatisticsPublisherService";
                BAMUtil.getBrokerClient(brokerURL_2_0_3, cookie).unsubscribe(identifier);
            }
            catch (Exception innerException) {
                String msg = "Failed to Un-subscribe - brokerURL: " + brokerURL + " or you are not super admin";
                log.error((Object)msg, (Throwable)innerException);
                throw new BAMException(msg, (Throwable)innerException);
            }
        }
    }
}

