/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.receivers;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.mediation.ServerUserDefinedDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationUserDefinedDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.core.admin.BAMDataServiceAdmin;
import org.wso2.carbon.bam.core.cache.CacheData;
import org.wso2.carbon.bam.core.cache.CacheImpl;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.receivers.AbstractQueue;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMException;

public class ServerUserDefinedDataEventingMessageQueue
extends AbstractQueue {
    private static final Log log = LogFactory.getLog(ServerUserDefinedDataEventingMessageQueue.class);
    public static final String SERVER_USER_DEFINED_DATA_NS_URI = "http://wso2.org/ns/2009/09/bam/server/user-defined/data";
    public static final String OPERATION_USER_DEFINED_DATA_NS_URI = "http://wso2.org/ns/2009/09/bam/operation/user-defined/data";
    public static final String ELEMENT_NAME_EVENT = "Event";
    public static final String ELEMENT_NAME_SERVER_USER_DEFINED_DATA = "ServerUserDefinedData";
    public static final String ELEMENT_NAME_SERVER_NAME = "ServerName";
    public static final String ELEMENT_NAME_TENANT_ID = "TenantID";
    public static final String ELEMENT_NAME_DATA = "Data";
    public static final String ELEMENT_NAME_KEY = "Key";
    public static final String ELEMENT_NAME_VALUE = "Value";
    public static final String ELEMENT_NAME_OPERATION_USER_DEFINED_DATA = "OperationUserDefinedData";
    public static final String ELEMENT_NAME_OPERATION_NAME = "OperationName";
    public static final String ELEMENT_NAME_SERVICE_NAME = "ServiceName";
    public static final String ELEMENT_NAME_TIMESTAMP = "Timestamp";
    private HashMap<String, CacheData> bamCache;
    private CacheImpl cacheImpl;

    public ServerUserDefinedDataEventingMessageQueue(int threadPoolSize) {
        super(threadPoolSize);
    }

    @Override
    protected void processEvents(MessageContext[] messageContexts) {
        BAMDataServiceAdmin dsAdmin = new BAMDataServiceAdmin();
        this.bamCache = BAMUtil.getBAMCache();
        this.cacheImpl = new CacheImpl();
        for (int i = 0; i < messageContexts.length; ++i) {
            try {
                this.handleServerUserDefinedData(messageContexts[i], dsAdmin);
                this.handleOperationUserDefinedData(messageContexts[i], dsAdmin);
                continue;
            }
            catch (BAMException e) {
                log.error((Object)("BAM ServerUserDefined MessageReceiver invokeBusinessLogic " + e.getLocalizedMessage()));
                log.error((Object)("BAM MR invokeBusinessLogic SOAP Envelope causing the problem" + messageContexts[i].getEnvelope().toString()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleServerUserDefinedData(MessageContext mc, BAMDataServiceAdmin dsAdmin) throws BAMException {
        QName eventQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_EVENT);
        OMElement eventElement = mc.getEnvelope().getBody().getFirstChildWithName(eventQname);
        if (eventElement == null) return;
        QName serviceStatisticsDataQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_SERVER_USER_DEFINED_DATA);
        OMElement serverUserDefinedDataElement = eventElement.getFirstChildWithName(serviceStatisticsDataQname);
        if (serverUserDefinedDataElement != null) {
            QName serverQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_SERVER_NAME);
            OMElement serverNameElement = serverUserDefinedDataElement.getFirstChildWithName(serverQname);
            QName tenantQName = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_TENANT_ID);
            OMElement tenantOmElement = serverUserDefinedDataElement.getFirstChildWithName(tenantQName);
            QName timestampQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_TIMESTAMP);
            OMElement timestampElement = serverUserDefinedDataElement.getFirstChildWithName(timestampQname);
            Calendar calendar = Calendar.getInstance();
            if (timestampElement != null) {
                calendar.setTimeInMillis(Timestamp.valueOf(timestampElement.getText()).getTime());
            }
            int tenantId = 0;
            if (tenantOmElement != null) {
                String tenant = tenantOmElement.getText();
                if (tenant == null) {
                    log.error((Object)"tenant not define of event payload");
                    return;
                }
                tenant = tenant.trim();
                tenantId = Integer.parseInt(tenant);
            }
            if (serverNameElement != null) {
                String serverName = serverNameElement.getText().trim();
                ServerDO server = null;
                if (timestampElement != null) {
                    try {
                        server = this.cacheImpl.getServer(dsAdmin, serverName, tenantId, "EventingServer", 4);
                        if (server == null) {
                            if (serverName != null || serverName.length() > 0) {
                                server = new ServerDO();
                                server.setServerURL(serverName);
                                server.setTenantID(tenantId);
                                server.setServerType("EventingServer");
                                server.setCategory(4);
                                BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addMonitoredServer(server);
                            }
                            server = this.cacheImpl.getServer(dsAdmin, serverName, tenantId, "EventingServer", 4);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error persisting information about the new server:  " + serverName + " from eventing message messagereceiver " + e.getLocalizedMessage()), (Throwable)e);
                    }
                } else {
                    try {
                        server = this.cacheImpl.getServer(dsAdmin, serverName, tenantId, "GenericServer", 8);
                        if (server == null) {
                            if (serverName != null || serverName.length() > 0) {
                                server = new ServerDO();
                                server.setServerURL(serverName);
                                server.setTenantID(tenantId);
                                server.setServerType("GenericServer");
                                server.setCategory(8);
                                BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addMonitoredServer(server);
                            }
                            server = this.cacheImpl.getServer(dsAdmin, serverName, tenantId, "GenericServer", 8);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error persisting information about the new server:  " + serverName + " from eventing message messagereceiver " + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
                QName dataQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_DATA);
                Iterator dataElements = serverUserDefinedDataElement.getChildrenWithName(dataQname);
                while (dataElements.hasNext()) {
                    QName keyQname;
                    OMElement dataElement = (OMElement)dataElements.next();
                    OMElement keyElement = dataElement.getFirstChildWithName(keyQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_KEY));
                    if (keyElement == null) {
                        String messageFaultReason = "Key element not found in the message";
                        throw new BAMException(messageFaultReason);
                    }
                    QName valueQname = new QName(SERVER_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_VALUE);
                    OMElement valueElement = dataElement.getFirstChildWithName(valueQname);
                    if (valueElement == null) {
                        String messageFaultReason = "Value element not found in the message";
                        throw new BAMException(messageFaultReason);
                    }
                    ServerUserDefinedDO serverUserDefinedDO = new ServerUserDefinedDO(server.getId(), serverName, calendar, keyElement.getText(), valueElement.getText());
                    try {
                        dsAdmin.addServerUserDefinedData(serverUserDefinedDO);
                    }
                    catch (BAMException e) {
                        log.error((Object)("Error updating user defined data for server " + serverName + " from eventing message messagereceiver " + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
                return;
            }
            String messageFaultReason = "ServerName element not found in the message";
            throw new BAMException(messageFaultReason);
        }
        String messageFaultReason = "ServerUserDefinedData element not found in the message";
        throw new BAMException(messageFaultReason);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleOperationUserDefinedData(MessageContext mc, BAMDataServiceAdmin dsAdmin) throws BAMException {
        QName operationEventQname = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_EVENT);
        OMElement operationEventElement = mc.getEnvelope().getBody().getFirstChildWithName(operationEventQname);
        if (operationEventElement != null) {
            Iterator dataElements;
            Calendar calendar;
            String serviceName;
            String serverName;
            String operationName;
            QName operationStatisticsDataQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_OPERATION_USER_DEFINED_DATA);
            OMElement operationUserDefinedDataElement = operationEventElement.getFirstChildWithName(operationStatisticsDataQName);
            if (operationUserDefinedDataElement == null) {
                String messageFaultReason = "OperationUserDefinedData element not found in the message";
                throw new BAMException(messageFaultReason);
            }
            QName tenantQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_TENANT_ID);
            OMElement tenantOmElement = operationUserDefinedDataElement.getFirstChildWithName(tenantQName);
            if (tenantOmElement == null) {
                log.error((Object)"tenant not define of event payload");
                return;
            }
            String tenant = tenantOmElement.getText().trim();
            int tenantId = Integer.parseInt(tenant);
            QName operationQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_OPERATION_NAME);
            OMElement operationNameElement = operationUserDefinedDataElement.getFirstChildWithName(operationQName);
            QName serviceQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_SERVICE_NAME);
            OMElement serviceNameElement = operationUserDefinedDataElement.getFirstChildWithName(serviceQName);
            QName serverQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_SERVER_NAME);
            OMElement serverNameElement = operationUserDefinedDataElement.getFirstChildWithName(serverQName);
            if (operationNameElement != null && serviceNameElement != null && serverNameElement != null) {
                operationName = operationNameElement.getText().trim();
                serverName = serverNameElement.getText().trim();
                serviceName = serviceNameElement.getText().trim();
                calendar = Calendar.getInstance();
                QName dataQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_DATA);
                dataElements = operationUserDefinedDataElement.getChildrenWithName(dataQName);
            } else {
                String messageFaultReason = "OperationName/ServiceName/WSASServerName element not found in the message";
                throw new BAMException(messageFaultReason);
            }
            while (dataElements.hasNext()) {
                QName keyQName;
                OMElement dataElement = (OMElement)dataElements.next();
                OMElement keyElement = dataElement.getFirstChildWithName(keyQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_KEY));
                if (keyElement == null) {
                    String messageFaultReason = "Key element not found in the message";
                    throw new BAMException(messageFaultReason);
                }
                QName valueQName = new QName(OPERATION_USER_DEFINED_DATA_NS_URI, ELEMENT_NAME_VALUE);
                OMElement valueElement = dataElement.getFirstChildWithName(valueQName);
                if (valueElement == null) {
                    String messageFaultReason = "Value element not found in the message";
                    throw new BAMException(messageFaultReason);
                }
                OperationUserDefinedDO operationUserDefinedDO = new OperationUserDefinedDO(operationName, calendar, keyElement.getText(), valueElement.getText());
                try {
                    OperationDO monitoringOperation;
                    ServiceDO monitoringService;
                    int serverID = 0;
                    int serviceID = 0;
                    ServerDO server = dsAdmin.getServer(serverName, tenantId, "EventingServer", 4);
                    if (server == null) {
                        if (serverName != null && serverName.length() > 0) {
                            server = new ServerDO();
                            server.setServerURL(serverName);
                            server.setTenantID(tenantId);
                            BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).syncServer(server);
                        }
                    } else {
                        serverID = server.getId();
                    }
                    if ((monitoringService = dsAdmin.getService(serverID, serviceName)) == null) {
                        if (serviceName != null && serviceName.length() > 0) {
                            ServiceDO service = new ServiceDO();
                            service.setServerID(serverID);
                            service.setName(serviceName);
                            BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).syncService(service);
                            serviceID = monitoringService.getId();
                        }
                    } else {
                        serviceID = monitoringService.getId();
                    }
                    if ((monitoringOperation = dsAdmin.getOperation(serviceID, operationName)) == null) {
                        OperationDO operation = new OperationDO();
                        operation.setServiceID(serviceID);
                        operation.setName(operationName);
                        BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).syncOperation(operation);
                    }
                    operationUserDefinedDO.setOperationID(monitoringOperation.getOperationID());
                    dsAdmin.addUserDefinedOperationData(operationUserDefinedDO);
                }
                catch (Exception e) {
                    log.error((Object)("Error updating user defined data for operation " + operationName + " from eventing message messagereceiver " + e.getLocalizedMessage()), (Throwable)e);
                }
            }
        }
    }
}

