/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.clients.BAMConfigurationDSClient;
import org.wso2.carbon.bam.common.dataobjects.activity.ActivityDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDO;
import org.wso2.carbon.bam.common.dataobjects.activity.NamespaceDO;
import org.wso2.carbon.bam.common.dataobjects.activity.PropertyFilterDO;
import org.wso2.carbon.bam.common.dataobjects.common.ClientDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.core.admin.BAMGlobalConfigAdmin;
import org.wso2.carbon.bam.core.admin.BAMTenantAdmin;
import org.wso2.carbon.bam.core.cache.CacheData;
import org.wso2.carbon.bam.core.util.BAMConfigurationCache;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.registry.core.Registry;

public class BAMPersistenceManager {
    private static final Log log = LogFactory.getLog(BAMPersistenceManager.class);
    private static Registry registry;
    private static BAMPersistenceManager persistenceManager;
    static final int NO_TENANT_MODE = -1;

    private BAMPersistenceManager(Registry registry) {
        BAMPersistenceManager.registry = registry;
    }

    public static BAMPersistenceManager getInstance() {
        return BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BAMPersistenceManager getPersistenceManager(Registry registry) {
        if (persistenceManager != null) return persistenceManager;
        Class<BAMPersistenceManager> clazz = BAMPersistenceManager.class;
        synchronized (BAMPersistenceManager.class) {
            if (persistenceManager != null) return persistenceManager;
            if (registry == null) {
                registry = BAMUtil.getRegistry();
            }
            persistenceManager = new BAMPersistenceManager(registry);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return persistenceManager;
        }
    }

    public TimeRange getDataRetentionPeriod() throws BAMException {
        TimeRange retention;
        BAMGlobalConfigAdmin configAdmin = new BAMGlobalConfigAdmin(this.getRegistry());
        try {
            retention = configAdmin.getDataRetentionPeriod();
        }
        catch (BAMException e) {
            throw new BAMException("Error occurred getting data retention period", (Throwable)e);
        }
        if (retention == null) {
            retention = new TimeRange(2, 1);
        }
        return retention;
    }

    public TimeRange getDataArchivalPeriod() throws BAMException {
        TimeRange retention;
        BAMGlobalConfigAdmin configAdmin = new BAMGlobalConfigAdmin(this.getRegistry());
        try {
            retention = configAdmin.getDataArchivalPeriod();
        }
        catch (BAMException e) {
            throw new BAMException("Error occurred getting data archive period", (Throwable)e);
        }
        if (retention == null) {
            retention = new TimeRange(2, 1);
        }
        return retention;
    }

    public void updateDataRetentionPeriod(TimeRange tr) throws BAMException {
        BAMGlobalConfigAdmin configAdmin = new BAMGlobalConfigAdmin(this.getRegistry());
        configAdmin.updateDataRetentionPeriod(tr);
    }

    public void updateDataArchivalPeriod(TimeRange tr) throws BAMException {
        BAMGlobalConfigAdmin configAdmin = new BAMGlobalConfigAdmin(this.getRegistry());
        configAdmin.updateDataArchivalPeriod(tr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addMonitoredServer(ServerDO server) throws BAMException {
        int addingServerStatus;
        block14: {
            int tenantId;
            addingServerStatus = -1;
            BAMConfigurationDSClient bamConfigurationDSClient = BAMUtil.getBAMConfigurationDSClient();
            if (server.getTenantID() == -1) {
                BAMTenantAdmin bamTenantAdmin = new BAMTenantAdmin();
                tenantId = bamTenantAdmin.getTenantId();
            } else {
                tenantId = server.getTenantID();
            }
            String serverUrl = server.getServerURL();
            String severType = server.getServerType();
            int category = server.getCategory();
            ServerDO monitoredServerDO = bamConfigurationDSClient.getServer(serverUrl, tenantId, severType, category);
            try {
                if (monitoredServerDO == null) {
                    BAMPersistenceManager bAMPersistenceManager = this;
                    synchronized (bAMPersistenceManager) {
                        if (monitoredServerDO == null) {
                            server.setTenantID(tenantId);
                            server.setPassword(this.encryptPassword(server.getPassword()));
                            int serverID = bamConfigurationDSClient.addServer(server);
                            if (serverID != -1) {
                                addingServerStatus = 0;
                            }
                        }
                        break block14;
                    }
                }
                addingServerStatus = 1;
            }
            catch (CryptoException e) {
                throw new BAMException("Unable to encrypt password of server " + serverUrl, (Throwable)e);
            }
            finally {
                if (bamConfigurationDSClient != null) {
                    bamConfigurationDSClient.cleanup();
                }
            }
        }
        return addingServerStatus;
    }

    private String encryptServerPassword(ServerDO server) throws CryptoException {
        return this.encryptPassword(server.getPassword());
    }

    private String encryptPassword(String plainTextPassword) throws CryptoException {
        if (plainTextPassword != null) {
            return CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(plainTextPassword.getBytes());
        }
        return null;
    }

    private String decryptPassword(String encryptedPassword) throws CryptoException {
        String decryptedPassword = null;
        if (encryptedPassword != null) {
            decryptedPassword = new String(CryptoUtil.getDefaultCryptoUtil().base64DecodeAndDecrypt(encryptedPassword));
        }
        return decryptedPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitoredServer(int serverID) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            try {
                client.removeServer(serverID);
            }
            catch (Exception e) {
                log.error((Object)"Can not delete monitored server entry from DB", (Throwable)e);
            }
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void updateMonitoredServer(ServerDO server) throws BAMException {
        BAMConfigurationDSClient client = null;
        HashMap<String, CacheData> cacheServer = BAMUtil.getBAMCache();
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            server.setPassword(this.encryptPassword(server.getPassword()));
            try {
                String cacheKey = server.getServerURL() + "_" + server.getTenantID() + "_" + server.getServerType() + "_" + server.getCategory();
                client.updateServer(server);
                if (cacheServer.get(cacheKey) != null) {
                    cacheServer.put(cacheKey, null);
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not update the server in DB", (Throwable)e);
            }
        }
        catch (CryptoException e) {
            throw new BAMException("Unable to encrypt password of server " + server.getServerURL(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public List<ServerDO> getMonitoredServers(int tenantID) throws BAMException {
        BAMConfigurationDSClient client = BAMUtil.getBAMConfigurationDSClient();
        try {
            ServerDO[] servers = tenantID == -1 ? client.getAllServers() : client.getServersForTenant(tenantID);
            if (servers != null) {
                for (ServerDO server : servers) {
                    if (server.getPassword() == null) continue;
                    server.setPassword(this.decryptPassword(server.getPassword()));
                }
                List<ServerDO> list = Arrays.asList(servers);
                return list;
            }
        }
        catch (CryptoException cryptoException) {
            throw new BAMException("Cannot decrypt password for server ", (Throwable)cryptoException);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
        return new ArrayList<ServerDO>();
    }

    public List<ServerDO> getMonitoredServerListWithCategoryName(int tenantID) throws BAMException {
        BAMConfigurationDSClient client = BAMUtil.getBAMConfigurationDSClient();
        try {
            ServerDO[] servers = tenantID == -1 ? client.getAllServersWithCategoryName() : client.getServersWithCategoryNameForTenant(tenantID);
            if (servers != null) {
                for (ServerDO server : servers) {
                    server.setPassword(this.decryptPassword(server.getPassword()));
                }
                List<ServerDO> list = Arrays.asList(servers);
                return list;
            }
        }
        catch (CryptoException cryptoException) {
            throw new BAMException("Cannot decrypt password for server ", (Throwable)cryptoException);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
        return new ArrayList<ServerDO>();
    }

    public ServerDO getMonitoredServer(int serverID) throws BAMException {
        BAMConfigurationDSClient client = null;
        ServerDO server = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            server = client.getServer(serverID);
            if (server != null && server.getPassword() != null) {
                server.setPassword(this.decryptPassword(server.getPassword()));
            }
        }
        catch (CryptoException e) {
            throw new BAMException("Cannot decrypt password for server " + server.getServerURL(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
        return server;
    }

    public ServerDO getMonitoredServer(String serverURL) throws BAMException {
        BAMConfigurationDSClient client = null;
        ServerDO server = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            server = client.getServer(serverURL);
            if (server != null && server.getPassword() != null) {
                server.setPassword(this.decryptPassword(server.getPassword()));
            }
        }
        catch (CryptoException e) {
            throw new BAMException("Cannot decrypt password for server " + server.getServerURL(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
        return server;
    }

    public Registry getRegistry() {
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateServer(int serverID) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            client.deactivateServer(serverID);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void activateServer(int serverID, String subscriptionID) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            client.activateServer(serverID, subscriptionID);
        }
        catch (BAMException e) {
            throw e;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(ServiceDO service) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            client.addService(service);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDO getService(int serviceID) throws BAMException {
        ServiceDO service = BAMConfigurationCache.getService(serviceID);
        BAMConfigurationDSClient client = null;
        try {
            if (service == null) {
                client = BAMUtil.getBAMConfigurationDSClient();
                ServiceDO serviceDO = client.getService(serviceID);
                return serviceDO;
            }
            if (service != null) {
                BAMConfigurationCache.addService(service);
            }
            ServiceDO serviceDO = service;
            return serviceDO;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDO getService(int serverID, String serviceName) throws BAMException {
        ServiceDO cashService = BAMConfigurationCache.getService(serverID, serviceName);
        BAMPersistenceManager service = null;
        BAMConfigurationDSClient configurationDSClient = null;
        boolean raceCondition = false;
        try {
            BAMPersistenceManager bAMPersistenceManager;
            if (cashService == null) {
                configurationDSClient = BAMUtil.getBAMConfigurationDSClient();
                if (service == null) {
                    bAMPersistenceManager = this;
                    synchronized (bAMPersistenceManager) {
                        if (service == null) {
                            service = new ServiceDO();
                            service.setName(serviceName);
                            service.setServerID(serverID);
                            raceCondition = false;
                            try {
                                configurationDSClient.addService((ServiceDO)service);
                            }
                            catch (Exception ignore) {
                                raceCondition = true;
                            }
                        }
                    }
                    service = configurationDSClient.getService(serverID, serviceName);
                    if (raceCondition && service != null) {
                        log.info((Object)("Recovered from race condition. " + serviceName + " successfully added!"));
                    } else if (raceCondition && service == null) {
                        log.error((Object)("Failed to recover from race condition, in adding service " + serviceName));
                    }
                }
            }
            bAMPersistenceManager = service;
            return bAMPersistenceManager;
        }
        catch (BAMException e) {
            throw e;
        }
        finally {
            if (configurationDSClient != null) {
                configurationDSClient.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceDO> getAllServices(int serverID) throws BAMException {
        List<ServiceDO> services = BAMConfigurationCache.getAllServices(serverID);
        BAMConfigurationDSClient client = null;
        try {
            if (services == null || services.size() <= 0) {
                client = BAMUtil.getBAMConfigurationDSClient();
                ServiceDO[] servicesArray = client.getAllServices(serverID);
                services = new ArrayList<ServiceDO>(servicesArray.length);
                services.addAll(Arrays.asList(servicesArray));
            }
            for (ServiceDO svc : services) {
                BAMConfigurationCache.addService(svc);
            }
            List<ServiceDO> list = services;
            return list;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperationDO> getAllOperations(int serviceID) throws BAMException {
        List<OperationDO> operations = BAMConfigurationCache.getAllOperations(serviceID);
        BAMConfigurationDSClient client = null;
        try {
            if (operations == null || operations.size() <= 0) {
                client = BAMUtil.getBAMConfigurationDSClient();
                OperationDO[] operationsArray = client.getAllOperations(serviceID);
                operations = new ArrayList<OperationDO>();
                operations.addAll(Arrays.asList(operationsArray));
            }
            List<OperationDO> list = operations;
            return list;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void syncServer(ServerDO server) throws BAMException {
        if (this.getMonitoredServer(server.getId()) == null) {
            this.addMonitoredServer(server);
        }
    }

    public void syncOperation(OperationDO operation) throws BAMException {
        if (this.getOperation(operation.getOperationID()) == null) {
            this.addOperation(operation);
        }
    }

    public void syncService(ServiceDO service) throws BAMException {
        if (this.getService(service.getId()) == null) {
            this.addService(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(OperationDO operation) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            client.addOperation(operation);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationDO getOperation(int serviceID, String operationName) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            BAMPersistenceManager bAMPersistenceManager;
            client = BAMUtil.getBAMConfigurationDSClient();
            OperationDO operation = client.getOperation(serviceID, operationName);
            if (operation == null) {
                bAMPersistenceManager = this;
                synchronized (bAMPersistenceManager) {
                    if (operation == null) {
                        operation = new OperationDO();
                        operation.setName(operationName);
                        operation.setServiceID(serviceID);
                        try {
                            client.addOperation(operation);
                        }
                        catch (BAMException bamException) {
                            log.info((Object)"Unable to add operation, because operation is already in DB");
                        }
                    }
                }
                operation = client.getOperation(serviceID, operationName);
            }
            if (operation != null) {
                BAMConfigurationCache.addOperation(operation);
            }
            bAMPersistenceManager = operation;
            return bAMPersistenceManager;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationDO getOperation(int operationID) throws BAMException {
        OperationDO operation = BAMConfigurationCache.getOperation(operationID);
        BAMConfigurationDSClient client = null;
        try {
            if (operation == null) {
                client = BAMUtil.getBAMConfigurationDSClient();
                operation = client.getOperation(operationID);
            }
            BAMConfigurationCache.addOperation(operation);
            OperationDO operationDO = operation;
            return operationDO;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediationDataDO> getEndpoints(int serverId) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            MediationDataDO[] endpoints = client.getEndpoints(serverId);
            ArrayList<MediationDataDO> endpointList = new ArrayList<MediationDataDO>(endpoints.length);
            endpointList.addAll(Arrays.asList(endpoints));
            ArrayList<MediationDataDO> arrayList = endpointList;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediationDataDO> getSequences(int serverId) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            MediationDataDO[] sequences = client.getSequences(serverId);
            ArrayList<MediationDataDO> sequenceList = new ArrayList<MediationDataDO>(sequences.length);
            sequenceList.addAll(Arrays.asList(sequences));
            ArrayList<MediationDataDO> arrayList = sequenceList;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediationDataDO> getProxyServices(int serverId) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            MediationDataDO[] proxySvcs = client.getProxyServices(serverId);
            ArrayList<MediationDataDO> proxyList = new ArrayList<MediationDataDO>(proxySvcs.length);
            proxyList.addAll(Arrays.asList(proxySvcs));
            ArrayList<MediationDataDO> arrayList = proxyList;
            return arrayList;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivity(ActivityDO activity) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            client.addActivity(activity);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityDO getActivity(int activityKeyId) throws BAMException {
        ActivityDO activity = BAMConfigurationCache.getActivity(activityKeyId);
        BAMConfigurationDSClient client = null;
        try {
            if (activity == null) {
                client = BAMUtil.getBAMConfigurationDSClient();
                activity = client.getActivity(activityKeyId);
            }
            BAMConfigurationCache.addActivity(activityKeyId, activity);
            ActivityDO activityDO = activity;
            return activityDO;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityDO> getAllActivities() throws BAMException {
        List<ActivityDO> activities = BAMConfigurationCache.getAllActivities();
        BAMConfigurationDSClient client = null;
        try {
            ActivityDO[] activitiesArray;
            if ((activities == null || activities.size() <= 0) && (activitiesArray = (client = BAMUtil.getBAMConfigurationDSClient()).getAllActivities()) != null) {
                activities = new ArrayList<ActivityDO>(activitiesArray.length);
                activities.addAll(Arrays.asList(activitiesArray));
            }
            for (ActivityDO activity : activities) {
                BAMConfigurationCache.addActivity(activity.getActivityKeyId(), activity);
            }
            List<ActivityDO> list = activities;
            return list;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyFilterDO> getAllXPathConfigurations(int serverID) throws BAMException {
        List<PropertyFilterDO> xpathConfigs = BAMConfigurationCache.getAllXPathConfigurations(serverID);
        BAMConfigurationDSClient client = null;
        try {
            PropertyFilterDO[] xpathConfigsArray;
            if ((xpathConfigs == null || xpathConfigs.size() <= 0) && (xpathConfigsArray = (client = BAMUtil.getBAMConfigurationDSClient()).getAllXpathData(serverID)) != null) {
                xpathConfigs = new ArrayList<PropertyFilterDO>(xpathConfigsArray.length);
                xpathConfigs.addAll(Arrays.asList(xpathConfigsArray));
            }
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
        return xpathConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NamespaceDO> getAllNamespaces(int xpathId) throws BAMException {
        List<NamespaceDO> nsList = BAMConfigurationCache.getAllNamespaces(xpathId);
        BAMConfigurationDSClient client = null;
        try {
            NamespaceDO[] nsArray;
            if ((nsList == null || nsList.size() <= 0) && (nsArray = (client = BAMUtil.getBAMConfigurationDSClient()).getAllNamespaceData(xpathId)) != null) {
                nsList = new ArrayList<NamespaceDO>(nsArray.length);
                nsList.addAll(Arrays.asList(nsArray));
            }
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
        return nsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(MessageDO message) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            client.addMessage(message);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageDO getMessage(int messageKeyId) throws BAMException {
        MessageDO message = BAMConfigurationCache.getMessage(messageKeyId);
        BAMConfigurationDSClient client = null;
        try {
            if (message == null) {
                client = BAMUtil.getBAMConfigurationDSClient();
                message = client.getMessage(messageKeyId);
            }
            BAMConfigurationCache.addMessage(message);
            MessageDO messageDO = message;
            return messageDO;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageDO> getAllMessagesForOperationID(int operationID) throws BAMException {
        List<MessageDO> messages = BAMConfigurationCache.getAllMessagesForOperationID(operationID);
        BAMConfigurationDSClient client = null;
        try {
            if (messages == null || messages.size() <= 0) {
                client = BAMUtil.getBAMConfigurationDSClient();
                MessageDO[] messagesArray = client.getAllMessagesForOperationID(operationID);
                messages = new ArrayList<MessageDO>(messagesArray.length);
                messages.addAll(Arrays.asList(messagesArray));
            }
            for (MessageDO message : messages) {
                BAMConfigurationCache.addMessage(message);
            }
            List<MessageDO> list = messages;
            return list;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageDO> getAllMessages() throws BAMException {
        List<MessageDO> messages = BAMConfigurationCache.getAllMessages();
        BAMConfigurationDSClient client = null;
        try {
            if (messages == null || messages.size() <= 0) {
                client = BAMUtil.getBAMConfigurationDSClient();
                MessageDO[] messagesArray = client.getAllMessages();
                messages = new ArrayList<MessageDO>(messagesArray.length);
                messages.addAll(Arrays.asList(messagesArray));
            }
            for (MessageDO message : messages) {
                BAMConfigurationCache.addMessage(message);
            }
            List<MessageDO> list = messages;
            return list;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientDO> getAllClients(int serverID) throws BAMException {
        List<ClientDO> clients = BAMConfigurationCache.getAllClients(serverID);
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            if (clients == null || clients.size() <= 0) {
                client = BAMUtil.getBAMConfigurationDSClient();
                ClientDO[] clientsArray = client.getAllClients(serverID);
                clients = new ArrayList<ClientDO>(clientsArray.length);
                clients.addAll(Arrays.asList(clientsArray));
            }
            for (ClientDO svcclient : clients) {
                BAMConfigurationCache.addClient(svcclient);
            }
            List<ClientDO> list = clients;
            return list;
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public ServerDO[] getMonitoredServersByType(String serverType) throws BAMException {
        BAMConfigurationDSClient client = null;
        try {
            client = BAMUtil.getBAMConfigurationDSClient();
            ServerDO[] servers = client.getServersforServerType(serverType);
            if (servers != null) {
                for (ServerDO server : servers) {
                    if (server.getPassword() == null) continue;
                    server.setPassword(this.decryptPassword(server.getPassword()));
                }
            }
            ServerDO[] serverDOArray = servers;
            return serverDOArray;
        }
        catch (CryptoException e) {
            throw new BAMException("Cannot decrypt password for server ", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }
}

