/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.core.archive.ArchiverTask;
import org.wso2.carbon.bam.core.cache.CacheTask;
import org.wso2.carbon.bam.core.collector.DataCollector;
import org.wso2.carbon.bam.core.persistence.BAMDatabaseCreator;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.persistence.DatabaseConfiguration;
import org.wso2.carbon.bam.core.receivers.ActivityEventQueue;
import org.wso2.carbon.bam.core.receivers.ServerEventQueue;
import org.wso2.carbon.bam.core.receivers.ServerUserDefinedDataEventingMessageQueue;
import org.wso2.carbon.bam.core.summary.SummaryGenerationTask;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class BAMServiceComponent {
    private static Log log = LogFactory.getLog(BAMServiceComponent.class);
    private Timer collectionTimer;
    private Timer summaryTimer;
    private Timer cacheTimer;
    private DataCollector collector;
    private SummaryGenerationTask generator;
    private CacheTask cacheTask;
    private BundleContext bundleContext;
    private long summaryGenDelay;
    private long summaryGenInterval;
    private long dataCollectionDelay;
    private long dataCollectionInterval;
    private long taskBreakDownLength;
    private long sleepTimeBetweenTasks;
    private static int activityThreadPoolSize;
    private static int mediationThreadPoolSize;
    private static int serviceThreadPoolSize;
    private static ServerEventQueue serverEventQueue;
    private static ActivityEventQueue activityEventQueue;
    private static ServerUserDefinedDataEventingMessageQueue serverUserDefinedDataMessageQueue;
    private static DataSource dataSource;

    protected void activate(ComponentContext ctx) {
        try {
            this.bundleContext = ctx.getBundleContext();
            BAMPersistenceManager persistenceManager = BAMPersistenceManager.getPersistenceManager(null);
            this.bundleContext.registerService(BAMPersistenceManager.class.getName(), (Object)persistenceManager, null);
            this.setup();
            try {
                this.processConfigurations();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processDefaults();
            serverEventQueue = new ServerEventQueue(serviceThreadPoolSize);
            activityEventQueue = new ActivityEventQueue(activityThreadPoolSize);
            serverUserDefinedDataMessageQueue = new ServerUserDefinedDataEventingMessageQueue(serviceThreadPoolSize);
            this.startTasks();
        }
        catch (Throwable e) {
            log.error((Object)"Error during BAMServiceComponent activation. Ignoring..", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM Core bundle is activated");
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM Core bundle is deactivated");
        }
        this.collectionTimer.cancel();
        this.summaryTimer.cancel();
        serverEventQueue.cleanup();
    }

    public static ServerEventQueue getServerEventQueue() {
        return serverEventQueue;
    }

    public static ActivityEventQueue getActivityEventQueue() {
        return activityEventQueue;
    }

    public static ServerUserDefinedDataEventingMessageQueue getServerUserDefinedDataMessageQueue() {
        return serverUserDefinedDataMessageQueue;
    }

    public static int getActivityThreadPoolSize() {
        return activityThreadPoolSize;
    }

    public static int getServiceThreadPoolSize() {
        return serviceThreadPoolSize;
    }

    public static int getMediationThreadPoolSize() {
        return mediationThreadPoolSize;
    }

    protected void setRegistryService(RegistryService registryService) throws RegistryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in BAM bundle");
        }
        BAMUtil.setRegistry((Registry)registryService.getConfigSystemRegistry());
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setup() {
        String dataSourcesFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "datasources.properties";
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(dataSourcesFile);
            properties.load(in);
        }
        catch (IOException e) {
            log.error((Object)"Unable to load DataSource property file. Database tables will not be created..", (Throwable)e);
            return;
        }
        finally {
            block19: {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (!log.isTraceEnabled()) break block19;
                        log.trace((Object)"Error while closing DataSource property file stream..", (Throwable)e);
                    }
                }
            }
        }
        BAMUtil.initBAMCache();
        DatabaseConfiguration dbConfig = this.getDatabaseConfiguration(properties);
        if (dbConfig == null) {
            log.error((Object)"Required properties not defined in DataSource property file. Database tables will not be created..");
            return;
        }
        dataSource = this.buildDataSource(dbConfig);
        if (System.getProperty("setup") != null) {
            BAMDatabaseCreator dbCreator = new BAMDatabaseCreator(dataSource);
            try {
                String validationQuery = dbConfig.getValidationQuery();
                if (validationQuery == null) {
                    validationQuery = "SELECT * from BAM_SERVER";
                }
                if (!dbCreator.isDatabaseStructureCreated(validationQuery)) {
                    CarbonUtils.checkSecurity();
                    dbCreator.createBAMDatabase();
                }
            }
            catch (Exception e) {
                String msg = "Error in creating database tables..";
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private DatabaseConfiguration getDatabaseConfiguration(Properties properties) {
        String dataSourceName = properties.getProperty("synapse.datasources");
        if (dataSourceName != null) {
            String dbUrl = properties.getProperty("synapse.datasources." + dataSourceName + "." + "url");
            if (dbUrl == null) {
                return null;
            }
            String driverName = properties.getProperty("synapse.datasources." + dataSourceName + "." + "driverClassName");
            if (driverName == null) {
                return null;
            }
            String userName = properties.getProperty("synapse.datasources." + dataSourceName + "." + "username");
            if (userName == null) {
                return null;
            }
            String password = properties.getProperty("synapse.datasources." + dataSourceName + "." + "password");
            if (password == null) {
                return null;
            }
            String configName = properties.getProperty("synapse.datasources." + dataSourceName + "." + "dsName");
            if (configName == null) {
                return null;
            }
            DatabaseConfiguration dbConfig = new DatabaseConfiguration();
            dbConfig.setDataSourceName(dataSourceName);
            dbConfig.setDbUrl(dbUrl);
            dbConfig.setDriverName(driverName);
            dbConfig.setUserName(userName);
            dbConfig.setPassword(password);
            dbConfig.setConfigName(configName);
            String maxActive = properties.getProperty("synapse.datasources." + dataSourceName + "." + "maxActive");
            if (maxActive != null) {
                dbConfig.setMaxActive(Integer.parseInt(maxActive));
            } else {
                dbConfig.setMaxActive(40);
            }
            String maxWait = properties.getProperty("synapse.datasources." + dataSourceName + "." + "maxWait");
            if (maxWait != null) {
                dbConfig.setMaxWait(Integer.parseInt(maxWait));
            } else {
                dbConfig.setMaxWait(60000);
            }
            String maxIdle = properties.getProperty("synapse.datasources." + dataSourceName + "." + "maxIdle");
            if (maxIdle != null) {
                dbConfig.setMaxIdle(Integer.parseInt(maxIdle));
            } else {
                dbConfig.setMaxIdle(20);
            }
            String minIdle = properties.getProperty("synapse.datasources." + dataSourceName + "." + "minIdle");
            if (minIdle != null) {
                dbConfig.setMinIdle(Integer.parseInt(minIdle));
            } else {
                dbConfig.setMinIdle(5);
            }
            String validationQuery = properties.getProperty("synapse.datasources." + dataSourceName + "." + "validationQuery");
            dbConfig.setValidationQuery(validationQuery);
            return dbConfig;
        }
        return null;
    }

    private DataSource buildDataSource(DatabaseConfiguration config) {
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setUrl(config.getDbUrl().trim());
        basicDataSource.setDriverClassName(config.getDriverName().trim());
        basicDataSource.setUsername(config.getUserName().trim());
        basicDataSource.setPassword(config.getPassword().trim());
        basicDataSource.setMaxActive(config.getMaxActive());
        basicDataSource.setMaxIdle(config.getMaxIdle());
        basicDataSource.setMaxWait((long)config.getMaxWait());
        basicDataSource.setMinIdle(config.getMinIdle());
        basicDataSource.setValidationQuery(config.getValidationQuery());
        return basicDataSource;
    }

    private void startTasks() {
        this.collectionTimer = new Timer(true);
        this.summaryTimer = new Timer(true);
        this.cacheTimer = new Timer(true);
        Timer archiveTimer = new Timer(true);
        this.collector = new DataCollector();
        this.collectionTimer.schedule((TimerTask)this.collector, this.dataCollectionDelay, this.dataCollectionInterval);
        log.info((Object)"BAM Data Collector started...");
        this.generator = new SummaryGenerationTask(this.bundleContext, this.taskBreakDownLength, this.sleepTimeBetweenTasks);
        BAMPersistenceManager persistenceManager = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
        if (persistenceManager != null) {
            if (this.summaryGenDelay < 0L || this.summaryGenInterval < 0L) {
                log.warn((Object)"Negative value detected for summary generation delay or summary generation interval. Disabling Summary Generation ...");
            } else {
                this.summaryTimer.schedule((TimerTask)this.generator, this.summaryGenDelay, this.summaryGenInterval);
                log.info((Object)"BAM Summary Generator started...");
            }
        }
        ArchiverTask archiver = new ArchiverTask();
        long timeTillMidNight = BAMCalendar.timeTillMidNight();
        archiveTimer.schedule((TimerTask)archiver, timeTillMidNight, 86400000L);
        log.info((Object)"BAM Message Archiving started...");
        this.cacheTask = new CacheTask();
        this.cacheTimer.schedule((TimerTask)this.cacheTask, 1500000L, 1200000L);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in BAM bundle");
        }
        BAMUtil.setRegistry(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService ccService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService set in BAM bundle");
        }
        BAMUtil.setConfigurationContextService(ccService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService ccService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unset in BAM bundle");
        }
        BAMUtil.setConfigurationContextService(null);
    }

    public RealmService getRealmService() {
        return BAMUtil.getRealmService();
    }

    protected void setRealmService(RealmService realmService) {
        BAMUtil.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        BAMUtil.setRealmService(null);
    }

    private void waitForCompletion() {
        this.generator.setSignalledState(true);
        this.collector.setSignalledState(true);
        while (this.generator.getRunningState() || this.collector.getRunningState()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigurations() throws BAMException {
        FileReader reader = null;
        XMLStreamReader parse = null;
        try {
            String configFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "bam.xml";
            try {
                reader = new FileReader(configFile);
                parse = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                StAXOMBuilder builder = new StAXOMBuilder(parse);
                OMElement bamElement = builder.getDocumentElement();
                this.processSumamryElement(bamElement);
                this.processDataCollectionElement(bamElement);
                this.processThreadPoolsElement(bamElement);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (parse != null) {
                    parse.close();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new BAMException("error occurred creating stream for bam.xml", (Throwable)e);
        }
        catch (IOException e) {
            throw new BAMException("error occurred getting bam.xml ", (Throwable)e);
        }
    }

    private void processSumamryElement(OMElement bamElement) {
        OMElement summaryElement = bamElement.getFirstChildWithName(new QName("summaryGeneration"));
        if (summaryElement != null) {
            OMElement sleepBetweenTimeTasksEl;
            OMElement delay = summaryElement.getFirstChildWithName(new QName("initial-delay"));
            if (delay != null) {
                this.summaryGenDelay = Long.parseLong(delay.getText()) * 1000L;
            } else {
                log.debug((Object)"No summaryGeneration initial-delay found in bam.xml. Using default value : 600s");
            }
            OMElement interval = summaryElement.getFirstChildWithName(new QName("interval"));
            if (interval != null) {
                this.summaryGenInterval = Long.parseLong(interval.getText()) * 1000L;
            } else {
                log.debug((Object)"No summaryGeneration interval found in bam.xml. Using default value : 3600s");
            }
            OMElement taskBreakDownLengthEl = summaryElement.getFirstChildWithName(new QName("taskBreakDownLength"));
            if (taskBreakDownLengthEl != null) {
                this.taskBreakDownLength = Long.parseLong(taskBreakDownLengthEl.getText());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task break down length is set to : " + this.taskBreakDownLength));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No task break length found in bam.xml. Using default value : 100");
            }
            if ((sleepBetweenTimeTasksEl = summaryElement.getFirstChildWithName(new QName("sleepTimeBetweenTasks"))) != null) {
                this.sleepTimeBetweenTasks = Long.parseLong(sleepBetweenTimeTasksEl.getText());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sleep time between tasks is set to : " + this.sleepTimeBetweenTasks));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"No sleep time between tasks found in bam.xml. Using default value : 3600000");
            }
        } else {
            log.debug((Object)"No summaryGeneration element found in bam.xml. Using default values : initial-delay = 600s interval = 3600s");
        }
    }

    private void processDataCollectionElement(OMElement bamElement) {
        OMElement dataCollectionElement = bamElement.getFirstChildWithName(new QName("dataCollection"));
        if (dataCollectionElement != null) {
            OMElement delay = dataCollectionElement.getFirstChildWithName(new QName("initial-delay"));
            if (delay != null) {
                this.dataCollectionDelay = Long.parseLong(delay.getText()) * 1000L;
            } else {
                log.debug((Object)"No dataCollection initial-delay found in bam.xml. Using default value : 60s");
            }
            OMElement interval = dataCollectionElement.getFirstChildWithName(new QName("interval"));
            if (interval != null) {
                this.dataCollectionInterval = Long.parseLong(interval.getText()) * 1000L;
            } else {
                log.debug((Object)"No dataCollection interval found in bam.xml. Using default value : 60s");
            }
        } else {
            log.debug((Object)"No dataCollection element found in bam.xml. Using default values : initial-delay = 60s interval = 60s");
        }
    }

    private void processThreadPoolsElement(OMElement bamElement) {
        OMElement threadPoolsElement = bamElement.getFirstChildWithName(new QName("threadPoolSizes"));
        if (threadPoolsElement != null) {
            OMElement activity = threadPoolsElement.getFirstChildWithName(new QName("activity"));
            if (activity != null) {
                activityThreadPoolSize = Integer.parseInt(activity.getText());
            } else {
                log.debug((Object)"No size for activity thread pool found in bam.xml. Using default value : 50");
            }
            OMElement mediation = threadPoolsElement.getFirstChildWithName(new QName("mediation"));
            if (mediation != null) {
                mediationThreadPoolSize = Integer.parseInt(mediation.getText());
            } else {
                log.debug((Object)"No size for mediation thread pool found in bam.xml. Using default value : 50");
            }
            OMElement service = threadPoolsElement.getFirstChildWithName(new QName("service"));
            if (service != null) {
                serviceThreadPoolSize = Integer.parseInt(service.getText());
            } else {
                log.debug((Object)"No size for service thread pool found in bam.xml. Using default value : 200");
            }
        } else {
            log.debug((Object)"No threadPoolSizes element found in bam.xml. Using default values : activity =50\n mediation = 50\n service = 200");
        }
    }

    private void processDefaults() {
        if (this.dataCollectionDelay <= 0L) {
            this.dataCollectionDelay = 60000L;
            log.warn((Object)"Using default value for data collection initial-delay : 60s");
        }
        if (this.dataCollectionInterval <= 0L) {
            this.dataCollectionInterval = 60000L;
            log.warn((Object)"Using default value for data collection interval : 60s");
        }
        if (activityThreadPoolSize <= 0) {
            activityThreadPoolSize = 50;
            log.warn((Object)"Using default value for activity thread pool size :50");
        }
        if (serviceThreadPoolSize <= 0) {
            serviceThreadPoolSize = 200;
            log.warn((Object)"Using default value for service thread pool size :200");
        }
        if (mediationThreadPoolSize <= 0) {
            mediationThreadPoolSize = 50;
            log.warn((Object)"Using default value for mediation thread pool size :50");
        }
    }
}

