/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.collector;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.common.dataobjects.stats.StatisticsDO;
import org.wso2.carbon.bam.core.clients.StatisticsAdminClient;
import org.wso2.carbon.bam.core.collector.AbstractDataPuller;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.core.util.ClientAuthHandler;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.statistics.stub.types.carbon.OperationStatistics;

public class OperationStatisticsDataPuller
extends AbstractDataPuller {
    public OperationStatisticsDataPuller(ServerDO server) {
        this.setServer(server);
    }

    @Override
    public StatisticsDO pullData(Object ctx) throws BAMException, RemoteException {
        BAMPersistenceManager persistenceManager = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
        OperationDO tmpOp = (OperationDO)ctx;
        String sessionCookie = ClientAuthHandler.getClientAuthHandler().getSessionString(this.getServer());
        StatisticsAdminClient client = new StatisticsAdminClient(this.getServer().getServerURL(), sessionCookie);
        ServiceDO svc = persistenceManager.getService(tmpOp.getServiceID());
        OperationStatistics opStatistics = client.getOperationStatistics(svc.getName(), tmpOp.getName());
        OperationStatisticsDO statisticsDO = new OperationStatisticsDO();
        statisticsDO.setServiceID(tmpOp.getServiceID());
        statisticsDO.setOperationName(tmpOp.getName());
        OperationDO op = null;
        int operationId = statisticsDO.getOperationID();
        op = operationId > 0 ? persistenceManager.getOperation(operationId) : persistenceManager.getOperation(statisticsDO.getServiceID(), statisticsDO.getOperationName());
        if (op == null) {
            BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addOperation(tmpOp);
        }
        if (op != null) {
            statisticsDO.setOperationID(op.getOperationID());
        }
        statisticsDO.setTimestamp(Calendar.getInstance());
        OperationStatisticsDataPuller.populateOperationStatisticsDO(statisticsDO, opStatistics);
        return statisticsDO;
    }

    private static void populateOperationStatisticsDO(OperationStatisticsDO statisticsDO, OperationStatistics statistics) {
        statisticsDO.setAvgResTime(statistics.getAvgResponseTime());
        statisticsDO.setMaxResTime((double)statistics.getMaxResponseTime());
        statisticsDO.setMinResTime((double)statistics.getMinResponseTime());
        statisticsDO.setReqCount(statistics.getTotalRequestCount());
        statisticsDO.setResCount(statistics.getTotalResponseCount());
        statisticsDO.setFaultCount(statistics.getTotalFaultCount());
    }
}

