/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.clients;

import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.ClientUtil;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDataDO;
import org.wso2.carbon.bam.services.stub.bamarchiverds.BAMArchiverDSStub;
import org.wso2.carbon.bam.services.stub.bamarchiverds.types.ArchiveData;
import org.wso2.carbon.bam.services.stub.bamarchiverds.types.ArchiveTime;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public class BAMArchiverDSClient {
    private static final Log log = LogFactory.getLog(BAMArchiverDSClient.class);
    private static final String BAM_ARCHIVER_DS = "BAMArchiverDS";
    private BAMArchiverDSStub stub;

    public BAMArchiverDSClient(String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR((String)backendServerURL, (String)BAM_ARCHIVER_DS);
            this.stub = new BAMArchiverDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
    }

    public BAMArchiverDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR((String)backendServerURL, (String)BAM_ARCHIVER_DS);
            this.stub = new BAMArchiverDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void cleanup() {
        block2: {
            try {
                this.stub._getServiceClient().cleanupTransport();
                this.stub._getServiceClient().cleanup();
                this.stub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    public Calendar getLatestArchiveTimeStamp() throws BAMException {
        Calendar timeStampCal = null;
        try {
            ArchiveTime timeStamp = this.stub.getLatestArchiveTimeStamp()[0];
            timeStampCal = timeStamp.getArchiveTime();
        }
        catch (Exception e) {
            throw new BAMException("Latest archive time stamp fetching failed", (Throwable)e);
        }
        return timeStampCal;
    }

    public MessageDataDO[] getMessageArchiveData(Calendar startTime, Calendar endTime) throws BAMException {
        MessageDataDO[] messages = null;
        try {
            ArchiveData[] datas = this.stub.getMessageArchiveData(startTime, endTime);
            if (datas == null) {
                return new MessageDataDO[0];
            }
            messages = new MessageDataDO[datas.length];
            for (int counter = 0; counter < datas.length; ++counter) {
                MessageDataDO message = new MessageDataDO();
                ArchiveData data = datas[counter];
                message.setActivityKeyId(Integer.parseInt(data.getActivityId()));
                message.setIpAddress(data.getIpAddress());
                message.setMessageBody(data.getMessage());
                message.setMessageDataKeyId(Integer.parseInt(data.getMessageId()));
                message.setMessageKeyId(Integer.parseInt(data.getMessageId()));
                message.setMessageDirection(data.getDirection());
                message.setTimestamp(data.getTimestamp());
                if (data.getDirection().equals("Request")) {
                    message.setRequestMessageStatus(data.getStatus());
                } else {
                    message.setResponseMessageStatus(data.getStatus());
                }
                messages[counter] = message;
            }
        }
        catch (Exception e) {
            throw new BAMException("Achievable message data fetching failed..", (Throwable)e);
        }
        return messages;
    }

    public void removePrimaryMessageData(Calendar startTime, Calendar endTime) throws BAMException {
        try {
            this.stub.removePrimaryMessageData(startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Removing primary message data failed..", (Throwable)e);
        }
    }

    public void archiveMessageData(MessageDataDO data) throws BAMException {
        try {
            String status = "";
            status = data.getMessageDirection().equals("Request") ? data.getRequestMessageStatus() : data.getResponseMessageStatus();
            this.stub.archiveMessageData(data.getMessageKeyId(), data.getActivityKeyId(), BAMCalendar.parseTimestamp((String)data.getTimestamp()), data.getMessageDirection(), data.getMessageBody(), data.getIpAddress(), status);
        }
        catch (Exception e) {
            throw new BAMException("Archiving message data failed..", (Throwable)e);
        }
    }
}

