/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.archive;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDataDO;
import org.wso2.carbon.bam.core.clients.BAMArchiverDSClient;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;

public class Archiver {
    private static final Log log = LogFactory.getLog(Archiver.class);
    private int timeInterval;

    public Archiver(int timeInterval) {
        this.timeInterval = timeInterval;
    }

    public void archive() throws BAMException {
        TimeRange archival;
        BAMArchiverDSClient client;
        Calendar lastTime;
        BAMCalendar nowTime = BAMCalendar.getInstance((Calendar)Calendar.getInstance());
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getClass().getSimpleName() + " | " + this.getTimeString() + "] " + "Time Now:" + BAMCalendar.getInstance((Calendar)nowTime).getBAMTimestamp()));
        }
        if ((lastTime = (client = BAMUtil.getArchiverDSClient()).getLatestArchiveTimeStamp()) == null) {
            lastTime = this.createEpochCalendar();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getClass().getSimpleName() + " | " + this.getTimeString() + "] " + "Archive last ran at:" + BAMCalendar.getInstance((Calendar)lastTime).getBAMTimestamp()));
        }
        if ((archival = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).getDataArchivalPeriod()).getValue() != 0) {
            MessageDataDO[] datas;
            nowTime.add(archival.getType(), -1 * archival.getValue());
            lastTime.add(archival.getType(), -1 * archival.getValue());
            for (MessageDataDO data : datas = client.getMessageArchiveData(lastTime, (Calendar)nowTime)) {
            }
            client.removePrimaryMessageData(lastTime, (Calendar)nowTime);
        }
    }

    private String getTimeString() {
        switch (this.getTimeInterval()) {
            case 1: {
                return "Yearly";
            }
            case 50: {
                return "Quarterly";
            }
            case 2: {
                return "Monthly";
            }
            case 5: {
                return "Daily";
            }
            case 11: {
                return "Hourly";
            }
        }
        throw new IllegalArgumentException("Unexpected timeInterval");
    }

    private int getTimeInterval() {
        return this.timeInterval;
    }

    private Calendar createEpochCalendar() {
        BAMCalendar calendar = BAMCalendar.getInstance();
        calendar.setTimeInMillis(0L);
        calendar.add(1, 1);
        return calendar;
    }
}

