/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.cep;

import java.io.FileReader;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.cep.BAMCepConstants;
import org.wso2.carbon.bam.util.BAMException;

public class BAMCepUtils {
    Log log = LogFactory.getLog(BAMCepUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void invokeSoapClient(OMElement payLoad, EndpointReference reference) {
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)httpConnectionManager);
        ServiceClient serviceClient = null;
        try {
            serviceClient = new ServiceClient();
            Options options = new Options();
            options.setAction("http://ws.apache.org/ws/2007/05/eventing-extended/Publish");
            options.setTo(reference);
            serviceClient.setOptions(options);
            serviceClient.getOptions().setProperty("REUSE_HTTP_CLIENT", (Object)"true");
            serviceClient.getOptions().setProperty("CACHED_HTTP_CLIENT", (Object)httpClient);
            serviceClient.fireAndForget(payLoad);
        }
        catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        }
        finally {
            if (serviceClient != null) {
                try {
                    serviceClient.cleanupTransport();
                }
                catch (Exception e) {
                    this.log.error((Object)"Could not clean the transport", (Throwable)e);
                }
                try {
                    serviceClient.cleanup();
                }
                catch (Exception e) {
                    this.log.error((Object)"Could not clean service client", (Throwable)e);
                }
            }
        }
        httpConnectionManager.closeIdleConnections(0L);
        httpConnectionManager.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OMElement getBAMConfigFile() throws BAMException {
        OMElement bamDocumentElement;
        FileReader reader = null;
        XMLStreamReader parse = null;
        try {
            try {
                reader = new FileReader(BAMCepConstants.BAM_CONF_FILE);
                parse = XMLInputFactory.newInstance().createXMLStreamReader(reader);
                StAXOMBuilder builder = new StAXOMBuilder(parse);
                bamDocumentElement = builder.getDocumentElement();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (parse != null) {
                    parse.close();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new BAMException("error occurred creating stream for bam.xml", (Throwable)e);
        }
        catch (IOException e) {
            throw new BAMException("error occurred getting bam.xml ", (Throwable)e);
        }
        return bamDocumentElement;
    }
}

