/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.cep;

import java.net.SocketException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.bam.cep.BAMCepUtils;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMException;

class BAMCepConfigure {
    protected static String bamConfigurationType;
    protected static String serverDataEpr;
    protected static String mediationDataEpr;

    BAMCepConfigure() {
    }

    protected String getBAMConfigType() throws BAMException {
        OMElement bamConfFileOMElement = new BAMCepUtils().getBAMConfigFile();
        OMElement configType = null;
        if (bamConfFileOMElement != null) {
            configType = bamConfFileOMElement.getFirstElement();
        }
        if (configType == null) {
            throw new BAMException("configType  does not exist in bam.xml file");
        }
        return configType.getAttributeValue(new QName("type"));
    }

    protected String getBAMConfigType(OMElement bamConfig, String elementName) throws BAMException {
        OMElement configType = bamConfig.getFirstElement();
        if (configType == null) {
            throw new BAMException(elementName + "  does not exist in bam.xml file");
        }
        return configType.getAttributeValue(new QName("type"));
    }

    protected String getPublisherEPR(OMElement bamConfig, String eprName) throws BAMException {
        OMElement bamMsgProcessor = bamConfig.getFirstChildWithName(new QName("bamMessageProcessor"));
        if (bamMsgProcessor == null) {
            throw new BAMException("bamMessageProcessor did not mention in bam.xml");
        }
        OMElement serverDataEpr = bamMsgProcessor.getFirstChildWithName(new QName(eprName));
        if (serverDataEpr == null) {
            throw new BAMException(eprName + " did not mention in bam.xml");
        }
        return serverDataEpr.getText();
    }

    protected String getReceiverURL(String service) throws SocketException, BAMException {
        return BAMUtil.getBackendServerURLHTTPS() + "services/" + service;
    }

    protected static String getBAMConfigValue() throws BAMException {
        if (bamConfigurationType == null) {
            BAMCepConfigure bamCepConfigure = new BAMCepConfigure();
            bamConfigurationType = bamCepConfigure.getBAMConfigType();
        }
        return bamConfigurationType;
    }

    protected static String getServerEprValue() throws BAMException {
        if (serverDataEpr == null) {
            BAMCepConfigure bamCepConfigure = new BAMCepConfigure();
            serverDataEpr = bamCepConfigure.getPublisherEPR(new BAMCepUtils().getBAMConfigFile(), "serverDataEPR");
        }
        return serverDataEpr;
    }

    protected static String getMediationEprValue() throws BAMException {
        if (mediationDataEpr == null) {
            BAMCepConfigure bamCepConfigure = new BAMCepConfigure();
            mediationDataEpr = bamCepConfigure.getPublisherEPR(new BAMCepUtils().getBAMConfigFile(), "mediationDataEPR");
        }
        return mediationDataEpr;
    }
}

