/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.util;

import java.net.SocketException;
import java.util.HashMap;
import org.wso2.carbon.bam.common.clients.BAMConfigurationDSClient;
import org.wso2.carbon.bam.common.clients.BAMDataCollectionDSClient;
import org.wso2.carbon.bam.common.clients.BAMServiceSummaryDSClient;
import org.wso2.carbon.bam.common.clients.BAMSummaryGenerationDSClient;
import org.wso2.carbon.bam.common.clients.SummaryDimensionDSClient;
import org.wso2.carbon.bam.core.cache.CacheData;
import org.wso2.carbon.bam.core.clients.BAMArchiverDSClient;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.event.client.broker.BrokerClient;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

public class BAMUtil {
    private static Registry registry;
    private static ConfigurationContextService configurationContextService;
    private static RealmService realmService;
    private static HashMap<String, CacheData> bamCache;
    private static BAMSummaryGenerationDSClient summaryGenerationDSClient;
    private static SummaryDimensionDSClient summaryDimensionDSClient;
    private static BAMServiceSummaryDSClient serviceSummaryDSClient;

    public static Registry getRegistry() {
        return registry;
    }

    public static void setRegistry(Registry registry) {
        BAMUtil.registry = registry;
    }

    public static String getBackendServerURLHTTPS() throws BAMException {
        try {
            return "https://" + NetworkUtils.getLocalHostname() + ":" + CarbonUtils.getTransportPort((ConfigurationContextService)BAMUtil.getConfigurationContextService(), (String)"https") + configurationContextService.getServerConfigContext().getContextRoot();
        }
        catch (SocketException e) {
            throw new BAMException("Cannot get back end https url", (Throwable)e);
        }
    }

    public static String getBackendServerURLHTTP() throws SocketException {
        return "http://" + NetworkUtils.getLocalHostname() + ":" + CarbonUtils.getTransportPort((ConfigurationContextService)BAMUtil.getConfigurationContextService(), (String)"http") + configurationContextService.getServerConfigContext().getContextRoot();
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        BAMUtil.configurationContextService = configurationContextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initBAMCache() {
        if (bamCache != null) return;
        Class<BAMUtil> clazz = BAMUtil.class;
        synchronized (BAMUtil.class) {
            bamCache = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static HashMap<String, CacheData> getBAMCache() {
        return bamCache;
    }

    public static BrokerClient getBrokerClient(String brokerURL, String userName, String password) throws Exception {
        return new BrokerClient(BAMUtil.getConfigurationContextService().getServerConfigContext(), brokerURL, userName, password);
    }

    public static BrokerClient getBrokerClient(String brokerURL, String cookie) throws Exception {
        return new BrokerClient(BAMUtil.getConfigurationContextService().getServerConfigContext(), brokerURL, cookie);
    }

    public static String generateURL(String[] components) {
        StringBuilder builder = new StringBuilder();
        if (components.length > 0) {
            builder.append(components[0]);
        }
        for (int i = 1; i < components.length; ++i) {
            builder.append("/");
            builder.append(components[i]);
        }
        return builder.toString();
    }

    public static synchronized BAMSummaryGenerationDSClient getBAMSummaryGenerationDSClient() throws BAMException {
        if (summaryGenerationDSClient == null) {
            summaryGenerationDSClient = new BAMSummaryGenerationDSClient("local:/", BAMUtil.getConfigurationContextService().getServerConfigContext());
        }
        return summaryGenerationDSClient;
    }

    public static synchronized SummaryDimensionDSClient getSummaryDimensionDSClient() throws BAMException {
        if (summaryDimensionDSClient == null) {
            summaryDimensionDSClient = new SummaryDimensionDSClient("local:/", BAMUtil.getConfigurationContextService().getServerConfigContext());
        }
        return summaryDimensionDSClient;
    }

    public static synchronized BAMServiceSummaryDSClient getBAMServiceSummaryDSClient() throws BAMException {
        if (serviceSummaryDSClient == null) {
            serviceSummaryDSClient = new BAMServiceSummaryDSClient("local:/", BAMUtil.getConfigurationContextService().getServerConfigContext());
        }
        return serviceSummaryDSClient;
    }

    public static BAMConfigurationDSClient getBAMConfigurationDSClient() throws BAMException {
        return new BAMConfigurationDSClient("local:/", BAMUtil.getConfigurationContextService().getServerConfigContext());
    }

    public static BAMDataCollectionDSClient getBAMDataCollectionDSClient() throws BAMException {
        return new BAMDataCollectionDSClient("local:/", BAMUtil.getConfigurationContextService().getServerConfigContext());
    }

    public static BAMArchiverDSClient getArchiverDSClient() throws BAMException {
        return new BAMArchiverDSClient("local:/", BAMUtil.getConfigurationContextService().getServerConfigContext());
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static void setRealmService(RealmService realmService) {
        BAMUtil.realmService = realmService;
    }

    public static int getTenantID(String tenantDomain) throws BAMException {
        int tenantID = -1234;
        if (tenantDomain != null) {
            RealmService realmService = BAMUtil.getRealmService();
            try {
                tenantID = realmService.getTenantManager().getTenantId(tenantDomain);
            }
            catch (UserStoreException e) {
                throw new BAMException("Can not tenant manager");
            }
        }
        return tenantID;
    }

    static {
        summaryGenerationDSClient = null;
        summaryDimensionDSClient = null;
        serviceSummaryDSClient = null;
    }
}

