/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary.generators;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.clients.BAMSummaryGenerationDSClient;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationSummaryStatistic;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;

public class EndpointSummaryGenerator
extends AbstractSummaryGenerator {
    private static Log log = LogFactory.getLog(EndpointSummaryGenerator.class);
    private MediationDataDO endpoint;
    private ServerDO server;

    public EndpointSummaryGenerator(ServerDO server, MediationDataDO endpoint, int timeInterval) {
        super(timeInterval);
        this.setEndpoint(endpoint);
        this.setServer(server);
    }

    @Override
    protected void summarizeHourly(BAMCalendar loHour, BAMCalendar hiHour) {
        block4: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                HourDimension hd = spm.getHourDimension((Calendar)loHour);
                if (hd == null) {
                    spm.addHourDimension(loHour);
                    hd = spm.getHourDimension((Calendar)loHour);
                }
                MediationSummaryStatistic stat = spm.getEndpointStatHourlySummary(this.getServer().getId(), this.getEndpoint().getName(), this.getEndpoint().getDirection(), loHour, hiHour);
                stat.setName(this.getEndpoint().getName());
                stat.setTimeDimensionId(hd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getEndpoint().getDirection());
                SummaryPersistenceManager.getInstance().addEndpointStatHourlySummary(stat);
                TimeRange retention = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).getDataRetentionPeriod();
                if (retention.getValue() != 0) {
                    BAMCalendar delLoHour = BAMCalendar.getInstance((Calendar)loHour);
                    BAMCalendar delHiHour = BAMCalendar.getInstance((Calendar)hiHour);
                    delHiHour.add(retention.getType(), -1 * retention.getValue());
                    delLoHour.add(retention.getType(), -1 * retention.getValue());
                    spm.deleteServerEndpointUserData(this.getServer().getId(), this.getEndpoint().getName(), this.getEndpoint().getDirection(), delLoHour, delHiHour);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running hourly summary generator for endpoint: " + this.getEndpoint() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeDaily(BAMCalendar loDay, BAMCalendar hiDay) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                DayDimension dd = spm.getDayDimension((Calendar)loDay);
                if (dd == null) {
                    spm.addDayDimension(loDay);
                    dd = spm.getDayDimension((Calendar)loDay);
                }
                MediationSummaryStatistic stat = spm.getEndpointStatDailySummary(this.getServer().getId(), this.getEndpoint().getName(), this.getEndpoint().getDirection(), loDay, hiDay);
                stat.setName(this.getEndpoint().getName());
                stat.setTimeDimensionId(dd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getEndpoint().getDirection());
                SummaryPersistenceManager.getInstance().addEndpointStatDailySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running daily summary generator for endpoint: " + this.getEndpoint() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeMonthly(BAMCalendar loMonth, BAMCalendar hiMonth) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                MonthDimension md = spm.getMonthDimension((Calendar)loMonth);
                if (md == null) {
                    spm.addMonthDimension(loMonth);
                    md = spm.getMonthDimension((Calendar)loMonth);
                }
                MediationSummaryStatistic stat = spm.getEndpointStatMonthlySummary(this.getServer().getId(), this.getEndpoint().getName(), this.getEndpoint().getDirection(), loMonth, hiMonth);
                stat.setName(this.getEndpoint().getName());
                stat.setTimeDimensionId(md.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getEndpoint().getDirection());
                SummaryPersistenceManager.getInstance().addEndpointStatMonthlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running monthly summary generator for endpoint: " + this.getEndpoint() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeQuarterly(BAMCalendar loQuarter, BAMCalendar hiQuarter) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                QuarterDimension qd = spm.getQuarterDimension((Calendar)loQuarter);
                if (qd == null) {
                    spm.addQuarterDimension(loQuarter);
                    qd = spm.getQuarterDimension((Calendar)loQuarter);
                }
                MediationSummaryStatistic stat = spm.getEndpointStatQuarterlySummary(this.getServer().getId(), this.getEndpoint().getName(), this.getEndpoint().getDirection(), loQuarter, hiQuarter);
                stat.setName(this.getEndpoint().getName());
                stat.setTimeDimensionId(qd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getEndpoint().getDirection());
                SummaryPersistenceManager.getInstance().addEndpointStatQuarterlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running quarterly summary generator for endpoint: " + this.getEndpoint() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeYearly(BAMCalendar loYear, BAMCalendar hiYear) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                YearDimension qd = spm.getYearDimension((Calendar)loYear);
                if (qd == null) {
                    spm.addYearDimension(loYear);
                    qd = spm.getYearDimension((Calendar)loYear);
                }
                MediationSummaryStatistic stat = spm.getEndpointStatYearlySummary(this.getServer().getId(), this.getEndpoint().getName(), this.getEndpoint().getDirection(), loYear, hiYear);
                stat.setName(this.getEndpoint().getName());
                stat.setTimeDimensionId(qd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getEndpoint().getDirection());
                SummaryPersistenceManager.getInstance().addEndpointStatYearlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running yearly summary generator for endpoint: " + this.getEndpoint() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestEndpointStatSummaryPeriod(this.getTimeInterval(), this.endpoint);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestEndpointStatSummaryPeriod(this.getTimeInterval(), this.endpoint);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestEndpointStatSummaryPeriod(this.getTimeInterval(), this.endpoint);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestDailySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestEndpointStatSummaryPeriod(this.getTimeInterval(), this.endpoint);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestEndpointStatSummaryPeriod(this.getTimeInterval(), this.endpoint);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    @Override
    protected String getInstanceInfo() {
        return "Server: " + this.server.getServerURL() + ", Endpoint: " + this.endpoint.getName();
    }

    public MediationDataDO getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(MediationDataDO endpoint) {
        this.endpoint = endpoint;
    }

    public ServerDO getServer() {
        return this.server;
    }

    public void setServer(ServerDO server) {
        this.server = server;
    }
}

