/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary;

import java.util.Calendar;
import org.wso2.carbon.bam.common.clients.BAMServiceSummaryDSClient;
import org.wso2.carbon.bam.common.clients.BAMSummaryGenerationDSClient;
import org.wso2.carbon.bam.common.clients.SummaryDimensionDSClient;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationSummaryStatistic;
import org.wso2.carbon.bam.common.dataobjects.stats.SummaryStatistic;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.BAMMath;

public class SummaryPersistenceManager {
    private static SummaryPersistenceManager spm;

    public static SummaryPersistenceManager getInstance() {
        if (spm == null) {
            spm = new SummaryPersistenceManager();
        }
        return spm;
    }

    public SummaryStatistic getServiceStatHourlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic stat = serviceSummaryDSClient.getServiceStatHourlySummary(serviceId, startTime, endTime);
            BAMCalendar prevHourStartTime = BAMCalendar.getInstance((Calendar)startTime);
            prevHourStartTime.add(11, -24);
            BAMCalendar prevHourEndTime = BAMCalendar.getInstance((Calendar)endTime);
            prevHourEndTime.add(11, -1);
            SummaryStatistic maxStatThisHour = serviceSummaryDSClient.getServiceMaxCounts(serviceId, startTime, endTime);
            SummaryStatistic maxStatPrevHour = serviceSummaryDSClient.getServiceMaxCounts(serviceId, prevHourStartTime, prevHourEndTime);
            int val = maxStatThisHour.getReqCount() - maxStatPrevHour.getReqCount();
            stat.setReqCount(val >= 0 ? val : maxStatThisHour.getReqCount());
            if (maxStatThisHour.getReqCount() <= 0) {
                stat.setAllZeros();
            } else {
                val = maxStatThisHour.getResCount() - maxStatPrevHour.getResCount();
                stat.setResCount(val >= 0 ? val : maxStatThisHour.getResCount());
                val = maxStatThisHour.getFaultCount() - maxStatPrevHour.getFaultCount();
                stat.setFaultCount(val >= 0 ? val : maxStatThisHour.getFaultCount());
            }
            SummaryStatistic summaryStatistic = stat;
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve hourly summary for service: " + serviceId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServiceStatDailySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServiceStatDailySummary(serviceId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve daily summary for service: " + serviceId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServiceStatMonthlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServiceStatMonthlySummary(serviceId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve monthly summary for service: " + serviceId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServiceStatQuarterlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServiceStatQuarterlySummary(serviceId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve quarterly summary for service: " + serviceId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServiceStatYearlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServiceStatYearlySummary(serviceId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve yearly summary for service: " + serviceId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServiceStatHourlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServiceStatHourlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly service summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServiceStatDailySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServiceStatDailySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly service summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServiceStatMonthlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServiceStatMonthlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding monthly service summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServiceStatQuarterlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServiceStatQuarterlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding quarterly service summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServiceStatYearlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServiceStatYearlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding yearly service summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServerStatHourlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic stat = serviceSummaryDSClient.getServerStatHourlySummary(serverId, startTime, endTime);
            BAMCalendar prevHourStartTime = BAMCalendar.getInstance((Calendar)startTime);
            prevHourStartTime.add(11, -24);
            BAMCalendar prevHourEndTime = BAMCalendar.getInstance((Calendar)endTime);
            prevHourEndTime.add(11, -1);
            SummaryStatistic maxStatThisHour = serviceSummaryDSClient.getServerMaxCounts(serverId, startTime, endTime);
            SummaryStatistic maxStatPrevHour = serviceSummaryDSClient.getServerMaxCounts(serverId, prevHourStartTime, prevHourEndTime);
            int val = maxStatThisHour.getReqCount() - maxStatPrevHour.getReqCount();
            stat.setReqCount(val >= 0 ? val : maxStatThisHour.getReqCount());
            if (maxStatThisHour.getReqCount() <= 0) {
                stat.setAllZeros();
            } else {
                val = maxStatThisHour.getResCount() - maxStatPrevHour.getResCount();
                stat.setResCount(val >= 0 ? val : maxStatThisHour.getResCount());
                val = maxStatThisHour.getFaultCount() - maxStatPrevHour.getFaultCount();
                stat.setFaultCount(val >= 0 ? val : maxStatThisHour.getFaultCount());
            }
            SummaryStatistic summaryStatistic = stat;
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve hourly summary for server: " + serverId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServerStatDailySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServerStatDailySummary(serverId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve daily summary for server: " + serverId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServerStatMonthlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServerStatMonthlySummary(serverId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve monthly summary for server: " + serverId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServerStatQuarterlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServerStatQuarterlySummary(serverId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve quarterly summary for server: " + serverId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getServerStatYearlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getServerStatYearlySummary(serverId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve yearly summary for server: " + serverId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServerStatHourlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServerStatHourlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly server summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServerStatDailySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServerStatDailySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding daily server summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServerStatMonthlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServerStatMonthlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding monthly server summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServerStatQuarterlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServerStatQuarterlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding quarterly server summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addServerStatYearlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addServerStatYearlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding yearly server summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public YearDimension getYearDimension(Calendar year) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            YearDimension yearDimension = summaryDimension.getYearDimension(year.get(1));
            return yearDimension;
        }
        catch (Exception e) {
            throw new BAMException("Retrieving year dimension failed for timestamp " + BAMCalendar.getInstance((Calendar)year).getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public QuarterDimension getQuarterDimension(Calendar quater) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            BAMCalendar bamQuater = BAMCalendar.getInstance((Calendar)quater);
            YearDimension yd = this.getYearDimension(quater);
            if (yd == null) {
                QuarterDimension quarterDimension = null;
                return quarterDimension;
            }
            QuarterDimension quarterDimension = summaryDimension.getQuarterDimension(bamQuater.get(50), yd.getId());
            return quarterDimension;
        }
        catch (Exception e) {
            throw new BAMException("Retrieving quarter dimension failed for timestamp " + BAMCalendar.getInstance((Calendar)quater).getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public MonthDimension getMonthDimension(Calendar month) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            QuarterDimension qd = this.getQuarterDimension(month);
            if (qd == null) {
                MonthDimension monthDimension = null;
                return monthDimension;
            }
            MonthDimension monthDimension = summaryDimension.getMonthDimension(month.get(2), qd.getId());
            return monthDimension;
        }
        catch (Exception e) {
            throw new BAMException("Retrieving month dimension failed for timestamp " + BAMCalendar.getInstance((Calendar)month).getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public DayDimension getDayDimension(Calendar day) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            MonthDimension md = this.getMonthDimension(day);
            if (md == null) {
                DayDimension dayDimension = null;
                return dayDimension;
            }
            DayDimension dayDimension = summaryDimension.getDayDimension(day.get(5), md.getId());
            return dayDimension;
        }
        catch (Exception e) {
            throw new BAMException("Retrieving day dimension failed for timestamp " + BAMCalendar.getInstance((Calendar)day).getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public HourDimension getHourDimension(Calendar hour) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            DayDimension dd = this.getDayDimension(hour);
            if (dd == null) {
                HourDimension hourDimension = null;
                return hourDimension;
            }
            HourDimension hourDimension = summaryDimension.getHourDimension(hour.get(11), dd.getId());
            return hourDimension;
        }
        catch (Exception e) {
            throw new BAMException("Retrieving hour dimension failed for timestamp " + BAMCalendar.getInstance((Calendar)hour).getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public void addYearDimension(BAMCalendar startTime) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            BAMCalendar yearStartTime = BAMCalendar.getYear((BAMCalendar)startTime);
            summaryDimension.addYearDimension(yearStartTime);
        }
        catch (Exception e) {
            throw new BAMException("Adding year dimension failed: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public void addQuarterDimension(BAMCalendar startTime) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            YearDimension yd = this.getYearDimension((Calendar)startTime);
            if (yd == null) {
                this.addYearDimension(startTime);
                yd = this.getYearDimension((Calendar)startTime);
            }
            if (yd == null) {
                throw new BAMException("Adding year dimension failed: " + startTime.getBAMTimestamp());
            }
            summaryDimension.addQuarterDimension(BAMCalendar.getQuarter((BAMCalendar)startTime), null, yd.getId());
        }
        catch (Exception e) {
            throw new BAMException("Adding quarter dimension failed: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public void addMonthDimension(BAMCalendar startTime) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            QuarterDimension qd = this.getQuarterDimension((Calendar)startTime);
            if (qd == null) {
                this.addQuarterDimension(startTime);
                qd = this.getQuarterDimension((Calendar)startTime);
            }
            if (qd == null) {
                throw new BAMException("Adding quarter dimension failed: " + startTime.getBAMTimestamp());
            }
            summaryDimension.addMonthDimension(BAMCalendar.getMonth((BAMCalendar)startTime), null, qd.getId());
        }
        catch (Exception e) {
            throw new BAMException("Adding month dimension failed: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public void addDayDimension(BAMCalendar startTime) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            MonthDimension md = this.getMonthDimension((Calendar)startTime);
            if (md == null) {
                this.addMonthDimension(startTime);
                md = this.getMonthDimension((Calendar)startTime);
            }
            if (md == null) {
                throw new BAMException("Adding month dimension failed: " + startTime.getBAMTimestamp());
            }
            summaryDimension.addDayDimension(BAMCalendar.getDay((BAMCalendar)startTime), null, md.getId());
        }
        catch (Exception e) {
            throw new BAMException("Adding day dimension failed: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public void addHourDimension(BAMCalendar startTime) throws BAMException {
        SummaryDimensionDSClient summaryDimension = null;
        try {
            summaryDimension = BAMUtil.getSummaryDimensionDSClient();
            DayDimension dd = this.getDayDimension((Calendar)startTime);
            if (dd == null) {
                this.addDayDimension(startTime);
                dd = this.getDayDimension((Calendar)startTime);
            }
            if (dd == null) {
                throw new BAMException("Adding hour dimension failed: " + startTime.getBAMTimestamp());
            }
            summaryDimension.addHourDimension(BAMCalendar.getHour((BAMCalendar)startTime), dd.getId());
        }
        catch (Exception e) {
            throw new BAMException("Adding hour dimension failed: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (summaryDimension != null) {
                summaryDimension.cleanup();
            }
        }
    }

    public SummaryStatistic getOperationStatHourlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic stat = serviceSummaryDSClient.getOperationStatHourlySummary(opId, startTime, endTime);
            BAMCalendar prevHourStartTime = BAMCalendar.getInstance((Calendar)startTime);
            prevHourStartTime.add(11, -24);
            BAMCalendar prevHourEndTime = BAMCalendar.getInstance((Calendar)endTime);
            prevHourEndTime.add(11, -1);
            SummaryStatistic maxStatThisHour = serviceSummaryDSClient.getOperationMaxCounts(opId, startTime, endTime);
            SummaryStatistic maxStatPrevHour = serviceSummaryDSClient.getOperationMaxCounts(opId, prevHourStartTime, prevHourEndTime);
            int val = maxStatThisHour.getReqCount() - maxStatPrevHour.getReqCount();
            stat.setReqCount(val >= 0 ? val : maxStatThisHour.getReqCount());
            if (maxStatThisHour.getReqCount() <= 0) {
                stat.setAllZeros();
            } else {
                val = maxStatThisHour.getResCount() - maxStatPrevHour.getResCount();
                stat.setResCount(val >= 0 ? val : maxStatThisHour.getResCount());
                val = maxStatThisHour.getFaultCount() - maxStatPrevHour.getFaultCount();
                stat.setFaultCount(val >= 0 ? val : maxStatThisHour.getFaultCount());
            }
            SummaryStatistic summaryStatistic = stat;
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve hourly summary for operation: " + opId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getOperationStatDailySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getOperationStatDailySummary(opId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve daily summary for operation: " + opId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getOperationStatMonthlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getOperationStatMonthlySummary(opId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve monthly summary for operation: " + opId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getOperationStatQuarterlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getOperationStatQuarterlySummary(opId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve quarterly summary for operation: " + opId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public SummaryStatistic getOperationStatYearlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            SummaryStatistic summaryStatistic = serviceSummaryDSClient.getOperationStatYearlySummary(opId, startTime, endTime);
            return summaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve yearly summary for operation: " + opId + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addOperationStatHourlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addOperationStatHourlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly operation summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addOperationStatDailySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addOperationStatDailySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly operation summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addOperationStatMonthlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addOperationStatMonthlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding monthly operation summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addOperationStatQuarterlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addOperationStatQuarterlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding quarterly operation summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    public void addOperationStatYearlySummary(SummaryStatistic stat) throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = null;
        try {
            serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
            serviceSummaryDSClient.addOperationStatYearlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding yearly operation summary stat failed", (Throwable)e);
        }
        finally {
            if (serviceSummaryDSClient != null) {
                serviceSummaryDSClient.cleanup();
            }
        }
    }

    private String createMediationKeyString(String mediationType, String direction, String dataType, String name) {
        return mediationType + direction + dataType + "-" + name;
    }

    public MediationSummaryStatistic getEndpointStatHourlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic statistic = new MediationSummaryStatistic();
            String endpointString = this.createMediationKeyString("Endpoint", direction, "MaxProcessingTime", endpoint);
            double[] doubles = client.getMediationStatHourlySummaryDouble(serverId, endpointString, startTime, endTime);
            double doubleVal = BAMMath.max((double[])doubles);
            statistic.setMaxProcessingTime(doubleVal);
            endpointString = this.createMediationKeyString("Endpoint", direction, "MinProcessingTime", endpoint);
            doubles = client.getMediationStatHourlySummaryDouble(serverId, endpointString, startTime, endTime);
            doubleVal = BAMMath.min((double[])doubles);
            statistic.setMinProcessingTime(doubleVal);
            endpointString = this.createMediationKeyString("Endpoint", direction, "AvgProcessingTime", endpoint);
            doubles = client.getMediationStatHourlySummaryDouble(serverId, endpointString, startTime, endTime);
            doubleVal = BAMMath.avg((double[])doubles);
            statistic.setAvgProcessingTime(doubleVal);
            BAMCalendar prevStartTime = BAMCalendar.getInstance((Calendar)startTime);
            prevStartTime.add(10, -24);
            BAMCalendar prevEndTime = BAMCalendar.getInstance((Calendar)endTime);
            prevEndTime.add(10, -1);
            endpointString = this.createMediationKeyString("Endpoint", direction, "CumulativeCount", endpoint);
            int[] intsThisHour = client.getDataForMediationMaxCount(serverId, endpointString, startTime, endTime);
            int[] intsPrevHour = client.getDataForMediationMaxCount(serverId, endpointString, prevStartTime, prevEndTime);
            int intVal = BAMMath.max((int[])intsThisHour) - BAMMath.max((int[])intsPrevHour);
            statistic.setCount(intVal >= 0 ? intVal : BAMMath.max((int[])intsThisHour));
            if (BAMMath.max((int[])intsThisHour) <= 0) {
                statistic.setAllZeros();
            } else {
                endpointString = this.createMediationKeyString("Endpoint", direction, "FaultCount", endpoint);
                intsThisHour = client.getDataForMediationMaxCount(serverId, endpointString, startTime, endTime);
                intsPrevHour = client.getDataForMediationMaxCount(serverId, endpointString, prevStartTime, prevEndTime);
                intVal = BAMMath.max((int[])intsThisHour) - BAMMath.max((int[])intsPrevHour);
                statistic.setFaultCount(intVal >= 0 ? intVal : BAMMath.max((int[])intsThisHour));
            }
            MediationSummaryStatistic mediationSummaryStatistic = statistic;
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve hourly summary for serverId: " + serverId + "endpoint: " + endpoint + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void deleteServerEndpointUserData(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            String endpointString = this.createMediationKeyString("Endpoint", direction, "MaxProcessingTime", endpoint);
            client.deleteServerUserData(serverId, endpointString, startTime, endTime);
            endpointString = this.createMediationKeyString("Endpoint", direction, "MinProcessingTime", endpoint);
            client.deleteServerUserData(serverId, endpointString, startTime, endTime);
            endpointString = this.createMediationKeyString("Endpoint", direction, "AvgProcessingTime", endpoint);
            client.deleteServerUserData(serverId, endpointString, startTime, endTime);
            endpointString = this.createMediationKeyString("Endpoint", direction, "CumulativeCount", endpoint);
            client.deleteServerUserData(serverId, endpointString, startTime, endTime);
            endpointString = this.createMediationKeyString("Endpoint", direction, "FaultCount", endpoint);
            client.deleteServerUserData(serverId, endpointString, startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Could not delete hourly summary for serverId: " + serverId + "endpoint: " + endpoint + direction + " end time: " + endTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getEndpointStatDailySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getEndpointStatDailySummary(serverId, endpoint, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve daily summary for serverId: " + serverId + "endpoint: " + endpoint + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getEndpointStatMonthlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getEndpointStatMonthlySummary(serverId, endpoint, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve monthly summary for serverId: " + serverId + "endpoint: " + endpoint + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getEndpointStatQuarterlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getEndpointStatQuarterlySummary(serverId, endpoint, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve quarterly summary for serverId: " + serverId + "endpoint: " + endpoint + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getEndpointStatYearlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getEndpointStatYearlySummary(serverId, endpoint, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve yearly summary for serverId: " + serverId + "endpoint: " + endpoint + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addEndpointStatHourlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addEndpointStatHourlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addEndpointStatDailySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addEndpointStatDailySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addEndpointStatMonthlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addEndpointStatMonthlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding monthly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addEndpointStatQuarterlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addEndpointStatQuarterlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding quarterly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addEndpointStatYearlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addEndpointStatYearlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding yearly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getProxyServiceStatHourlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic statistic = new MediationSummaryStatistic();
            String proxyServiceString = "Proxy" + direction + "MaxProcessingTime" + "-" + proxyService;
            double[] doubles = client.getMediationStatHourlySummaryDouble(serverId, proxyServiceString, startTime, endTime);
            double doubleVal = BAMMath.max((double[])doubles);
            statistic.setMaxProcessingTime(doubleVal);
            proxyServiceString = "Proxy" + direction + "MinProcessingTime" + "-" + proxyService;
            doubles = client.getMediationStatHourlySummaryDouble(serverId, proxyServiceString, startTime, endTime);
            doubleVal = BAMMath.min((double[])doubles);
            statistic.setMinProcessingTime(doubleVal);
            proxyServiceString = "Proxy" + direction + "AvgProcessingTime" + "-" + proxyService;
            doubles = client.getMediationStatHourlySummaryDouble(serverId, proxyServiceString, startTime, endTime);
            doubleVal = BAMMath.avg((double[])doubles);
            statistic.setAvgProcessingTime(doubleVal);
            BAMCalendar prevStartTime = BAMCalendar.getInstance((Calendar)startTime);
            prevStartTime.add(10, -24);
            BAMCalendar prevEndTime = BAMCalendar.getInstance((Calendar)endTime);
            prevEndTime.add(10, -1);
            proxyServiceString = this.createMediationKeyString("Proxy", direction, "CumulativeCount", proxyService);
            int[] intsThisHour = client.getDataForMediationMaxCount(serverId, proxyServiceString, startTime, endTime);
            int[] intsPrevHour = client.getDataForMediationMaxCount(serverId, proxyServiceString, prevStartTime, prevEndTime);
            int intVal = BAMMath.max((int[])intsThisHour) - BAMMath.max((int[])intsPrevHour);
            statistic.setCount(intVal >= 0 ? intVal : BAMMath.max((int[])intsThisHour));
            if (BAMMath.max((int[])intsThisHour) <= 0) {
                statistic.setAllZeros();
            } else {
                proxyServiceString = this.createMediationKeyString("Proxy", direction, "FaultCount", proxyService);
                intsThisHour = client.getDataForMediationMaxCount(serverId, proxyServiceString, startTime, endTime);
                intsPrevHour = client.getDataForMediationMaxCount(serverId, proxyServiceString, prevStartTime, prevEndTime);
                intVal = BAMMath.max((int[])intsThisHour) - BAMMath.max((int[])intsPrevHour);
                statistic.setFaultCount(intVal >= 0 ? intVal : BAMMath.max((int[])intsThisHour));
            }
            MediationSummaryStatistic mediationSummaryStatistic = statistic;
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve hourly summary for serverId: " + serverId + "proxyService: " + proxyService + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void deleteServerProxyServiceUserData(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            String proxyServiceString = this.createMediationKeyString("Proxy", direction, "MaxProcessingTime", proxyService);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Proxy", direction, "MinProcessingTime", proxyService);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Proxy", direction, "AvgProcessingTime", proxyService);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Proxy", direction, "CumulativeCount", proxyService);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Proxy", direction, "FaultCount", proxyService);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Could not delete hourly summary for serverId: " + serverId + "proxyService: " + proxyService + direction + " end time: " + endTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getProxyServiceStatDailySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getProxyServiceStatDailySummary(serverId, proxyService, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve daily summary for serverId: " + serverId + "proxyService: " + proxyService + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getProxyServiceStatMonthlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getProxyServiceStatMonthlySummary(serverId, proxyService, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve monthly summary for serverId: " + serverId + "proxyService: " + proxyService + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getProxyServiceStatQuarterlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getProxyServiceStatQuarterlySummary(serverId, proxyService, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve quarterly summary for serverId: " + serverId + "proxyService: " + proxyService + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getProxyServiceStatYearlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getProxyServiceStatYearlySummary(serverId, proxyService, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve yearly summary for serverId: " + serverId + "proxyService: " + proxyService + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addProxyServiceStatHourlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addProxyServiceStatHourlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addProxyServiceStatDailySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addProxyServiceStatDailySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addProxyServiceStatMonthlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addProxyServiceStatMonthlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding monthly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addProxyServiceStatQuarterlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addProxyServiceStatQuarterlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding quarterly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addProxyServiceStatYearlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addProxyServiceStatYearlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding yearly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getSequenceStatHourlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic statistic = new MediationSummaryStatistic();
            String sequenceString = "Sequence" + direction + "MaxProcessingTime" + "-" + sequence;
            double[] doubles = client.getMediationStatHourlySummaryDouble(serverId, sequenceString, startTime, endTime);
            double doubleVal = BAMMath.max((double[])doubles);
            statistic.setMaxProcessingTime(doubleVal);
            sequenceString = "Sequence" + direction + "MinProcessingTime" + "-" + sequence;
            doubles = client.getMediationStatHourlySummaryDouble(serverId, sequenceString, startTime, endTime);
            doubleVal = BAMMath.min((double[])doubles);
            statistic.setMinProcessingTime(doubleVal);
            sequenceString = "Sequence" + direction + "AvgProcessingTime" + "-" + sequence;
            doubles = client.getMediationStatHourlySummaryDouble(serverId, sequenceString, startTime, endTime);
            doubleVal = BAMMath.avg((double[])doubles);
            statistic.setAvgProcessingTime(doubleVal);
            BAMCalendar prevStartTime = BAMCalendar.getInstance((Calendar)startTime);
            prevStartTime.add(10, -24);
            BAMCalendar prevEndTime = BAMCalendar.getInstance((Calendar)endTime);
            prevEndTime.add(10, -1);
            sequenceString = this.createMediationKeyString("Sequence", direction, "CumulativeCount", sequence);
            int[] intsThisHour = client.getDataForMediationMaxCount(serverId, sequenceString, startTime, endTime);
            int[] intsPrevHour = client.getDataForMediationMaxCount(serverId, sequenceString, prevStartTime, prevEndTime);
            int intVal = BAMMath.max((int[])intsThisHour) - BAMMath.max((int[])intsPrevHour);
            statistic.setCount(intVal >= 0 ? intVal : BAMMath.max((int[])intsThisHour));
            if (BAMMath.max((int[])intsThisHour) <= 0) {
                statistic.setAllZeros();
            } else {
                sequenceString = this.createMediationKeyString("Sequence", direction, "FaultCount", sequence);
                intsThisHour = client.getDataForMediationMaxCount(serverId, sequenceString, startTime, endTime);
                intsPrevHour = client.getDataForMediationMaxCount(serverId, sequenceString, prevStartTime, prevEndTime);
                intVal = BAMMath.max((int[])intsThisHour) - BAMMath.max((int[])intsPrevHour);
                statistic.setFaultCount(intVal >= 0 ? intVal : BAMMath.max((int[])intsThisHour));
            }
            MediationSummaryStatistic mediationSummaryStatistic = statistic;
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve hourly summary for serverId: " + serverId + "sequence: " + sequence + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void deleteServerSequenceUserData(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            String proxyServiceString = this.createMediationKeyString("Sequence", direction, "MaxProcessingTime", sequence);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Sequence", direction, "MinProcessingTime", sequence);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Sequence", direction, "AvgProcessingTime", sequence);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Sequence", direction, "CumulativeCount", sequence);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
            proxyServiceString = this.createMediationKeyString("Sequence", direction, "FaultCount", sequence);
            client.deleteServerUserData(serverId, proxyServiceString, startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Could not delete hourly summary for serverId: " + serverId + "sequence: " + sequence + direction + " end time: " + endTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getSequenceStatDailySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getSequenceStatDailySummary(serverId, sequence, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve daily summary for serverId: " + serverId + "sequence: " + sequence + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getSequenceStatMonthlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getSequenceStatMonthlySummary(serverId, sequence, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve monthly summary for serverId: " + serverId + "sequence: " + sequence + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getSequenceStatQuarterlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getSequenceStatQuarterlySummary(serverId, sequence, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve quarterly summary for serverId: " + serverId + "sequence: " + sequence + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public MediationSummaryStatistic getSequenceStatYearlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            MediationSummaryStatistic mediationSummaryStatistic = client.getSequenceStatYearlySummary(serverId, sequence, direction, startTime, endTime);
            return mediationSummaryStatistic;
        }
        catch (Exception e) {
            throw new BAMException("Could not retrieve yearly summary for serverId: " + serverId + "sequence: " + sequence + direction + " start time: " + startTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addSequenceStatHourlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addSequenceStatHourlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addSequenceStatDailySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addSequenceStatDailySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding hourly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addSequenceStatMonthlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addSequenceStatMonthlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding monthly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addSequenceStatQuarterlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addSequenceStatQuarterlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding quarterly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void addSequenceStatYearlySummary(MediationSummaryStatistic stat) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.addSequenceStatYearlySummary(stat);
        }
        catch (Exception e) {
            throw new BAMException("Adding yearly mediation summary stat failed", (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void deleteServerData(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.deleteServerData(serverId, startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Could not delete hourly summary for serverId: " + serverId + " end time: " + endTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void deleteServiceData(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.deleteServiceData(serviceId, startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Could not delete hourly summary for serviceId: " + serviceId + " end time: " + endTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }

    public void deleteOperationData(int operationId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        BAMSummaryGenerationDSClient client = null;
        try {
            client = BAMUtil.getBAMSummaryGenerationDSClient();
            client.deleteOperationData(operationId, startTime, endTime);
        }
        catch (Exception e) {
            throw new BAMException("Could not delete hourly summary for operationId: " + operationId + " end time: " + endTime.getBAMTimestamp(), (Throwable)e);
        }
        finally {
            if (client != null) {
                client.cleanup();
            }
        }
    }
}

