/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class BAMDatabaseCreator
extends DatabaseCreator {
    private static Log log = LogFactory.getLog(BAMDatabaseCreator.class);
    private DataSource datasource;
    private Connection conn;
    private Statement statement;
    private String delimiter = ";";

    public BAMDatabaseCreator(DataSource dataSource) {
        super(dataSource);
        this.datasource = dataSource;
    }

    public void createBAMDatabase() throws Exception {
        try {
            this.conn = this.datasource.getConnection();
            this.conn.setAutoCommit(false);
            this.statement = this.conn.createStatement();
            this.executeSQLScript();
            this.conn.commit();
            if (log.isTraceEnabled()) {
                log.trace((Object)"BAM tables are created successfully..");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to create database tables for BAM.. " + e.getMessage();
            log.fatal((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to close database connection.", (Throwable)e);
            }
        }
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = "bam_schema_" + databaseType + ".sql";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading database script from :" + scriptName));
        }
        String carbonHome = System.getProperty("carbon.home");
        return carbonHome + "/dbscripts/bam" + File.separator + scriptName;
    }

    private void executeSQLScript() throws Exception {
        String databaseType = DatabaseCreator.getDatabaseType((Connection)this.conn);
        boolean keepFormat = false;
        if ("oracle".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("db2".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("openedge".equals(databaseType)) {
            this.delimiter = "/";
            keepFormat = true;
        }
        String dbscriptName = this.getDbScriptLocation(databaseType);
        StringBuffer sql = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(dbscriptName);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String token;
                StringTokenizer st;
                line = line.trim();
                if (!keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
                sql.append(keepFormat ? "\n" : " ").append(line);
                if (!keepFormat && line.indexOf("--") >= 0) {
                    sql.append("\n");
                }
                if (!BAMDatabaseCreator.checkStringBufferEndsWith((StringBuffer)sql, (String)this.delimiter)) continue;
                this.executeSQL(sql.substring(0, sql.length() - this.delimiter.length()));
                sql.replace(0, sql.length(), "");
            }
            if (sql.length() > 0) {
                this.executeSQL(sql.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while executing SQL script for creating registry database", (Throwable)e);
            throw new Exception("Error occurred while executing SQL script for creating registry database", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(String sql) throws Exception {
        block19: {
            if ("".equals(sql.trim())) {
                return;
            }
            ResultSet resultSet = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SQL : " + sql));
                }
                int updateCount = 0;
                int updateCountTotal = 0;
                boolean ret = this.statement.execute(sql);
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
                do {
                    if (!ret && updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                    if (!(ret = this.statement.getMoreResults())) continue;
                    updateCount = this.statement.getUpdateCount();
                    resultSet = this.statement.getResultSet();
                } while (ret);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sql + " : " + updateCountTotal + " rows affected"));
                }
                for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.info((Object)(warning + " sql warning"));
                }
                this.conn.clearWarnings();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0Y32")) {
                    log.info((Object)"Table Already Exists", (Throwable)e);
                    break block19;
                }
                throw new Exception("Error occurred while executing : " + sql, e);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing result set.", (Throwable)e);
                    }
                }
            }
        }
    }
}

