/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.clients;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.clients.AbstractAdminClient;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.statistics.stub.StatisticsAdminStub;
import org.wso2.carbon.statistics.stub.types.carbon.OperationStatistics;
import org.wso2.carbon.statistics.stub.types.carbon.ServiceStatistics;
import org.wso2.carbon.statistics.stub.types.carbon.SystemStatistics;

public class StatisticsAdminClient
extends AbstractAdminClient<StatisticsAdminStub> {
    private static Log log = LogFactory.getLog(StatisticsAdminClient.class);

    public StatisticsAdminClient(String serverURL) throws AxisFault {
        String serviceURL = StatisticsAdminClient.generateURL(new String[]{serverURL, "services", "StatisticsAdmin"});
        this.stub = new StatisticsAdminStub(BAMUtil.getConfigurationContextService().getClientConfigContext(), serviceURL);
        ((StatisticsAdminStub)this.stub)._getServiceClient().getOptions().setManageSession(true);
    }

    public StatisticsAdminClient(String serverURL, String sessionCookie) throws AxisFault {
        this(serverURL);
        this.setSessionCookie(sessionCookie);
    }

    public ServiceStatistics getServiceStatistics(String serviceName) throws RemoteException {
        return ((StatisticsAdminStub)this.stub).getServiceStatistics(serviceName);
    }

    public SystemStatistics getSystemStatistics() throws RemoteException {
        return ((StatisticsAdminStub)this.stub).getSystemStatistics();
    }

    public OperationStatistics getOperationStatistics(String serviceName, String operationName) throws RemoteException {
        return ((StatisticsAdminStub)this.stub).getOperationStatistics(serviceName, operationName);
    }

    public int getServiceRequestCount(String serviceName) throws RemoteException {
        return ((StatisticsAdminStub)this.stub).getServiceRequestCount(serviceName);
    }

    public int getServiceFaultCount(String serviceName) throws RemoteException {
        return ((StatisticsAdminStub)this.stub).getServiceFaultCount(serviceName);
    }

    public int getServiceResponseCount(String serviceName) throws RemoteException {
        return ((StatisticsAdminStub)this.stub).getServiceResponseCount(serviceName);
    }

    @Override
    public void cleanup() {
        block2: {
            try {
                ((StatisticsAdminStub)this.stub)._getServiceClient().cleanupTransport();
                ((StatisticsAdminStub)this.stub)._getServiceClient().cleanup();
                ((StatisticsAdminStub)this.stub).cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }
}

