/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.admin;

import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.clients.OperationAdminClient;
import org.wso2.carbon.bam.core.clients.ServiceGroupAdminClient;
import org.wso2.carbon.bam.core.util.ClientAuthHandler;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.operation.mgt.stub.types.OperationMetaData;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceGroupMetaData;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceMetaData;

public class MonitoredServerServiceInfoAdmin {
    private static Log log = LogFactory.getLog(MonitoredServerServiceInfoAdmin.class);

    public String[] getServiceNames(ServerDO server) throws BAMException {
        String[] services;
        try {
            services = this.getServiceNamesInternal(server);
        }
        catch (AxisFault axisFault) {
            if (ClientAuthHandler.checkAuthException(axisFault)) {
                ClientAuthHandler.getClientAuthHandler().authenticateForcefully(server);
                try {
                    services = this.getServiceNamesInternal(server);
                }
                catch (RemoteException e) {
                    throw new BAMException("Invalid credentials provided for " + server.getServerURL());
                }
            }
            throw new BAMException("Unable to retrieve services list from server [" + server.getServerURL() + "]", (Throwable)axisFault);
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve services list from server [" + server.getServerURL() + "]", (Throwable)e);
        }
        return services;
    }

    public String[] getOperationNames(ServerDO server, String serviceName) throws BAMException {
        String[] operations;
        try {
            operations = this.getOperationNamesInternal(server, serviceName);
        }
        catch (AxisFault axisFault) {
            if (ClientAuthHandler.checkAuthException(axisFault)) {
                ClientAuthHandler.getClientAuthHandler().authenticateForcefully(server);
                try {
                    operations = this.getServiceNamesInternal(server);
                }
                catch (RemoteException e) {
                    log.error((Object)("Invalid credential for server " + server.getServerURL()));
                    throw new BAMException("Invalid credentials provided!");
                }
            }
            throw new BAMException("Unable to retrieve services list from server [" + server.getServerURL() + "]", (Throwable)axisFault);
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve services list from server [" + server.getServerURL() + "]", (Throwable)e);
        }
        return operations;
    }

    private String[] getOperationNamesInternal(ServerDO server, String serviceName) throws RemoteException, BAMException {
        String sessionCookie = ClientAuthHandler.getClientAuthHandler().getSessionString(server);
        OperationAdminClient client = new OperationAdminClient(server.getServerURL(), sessionCookie);
        OperationMetaData[] mData = client.getAllOperations(serviceName);
        ArrayList<String> ops = new ArrayList<String>();
        for (OperationMetaData opData : mData) {
            ops.add(opData.getName());
        }
        return ops.toArray(new String[ops.size()]);
    }

    private String[] getServiceNamesInternal(ServerDO server) throws BAMException, RemoteException {
        String sessionCookie = ClientAuthHandler.getClientAuthHandler().getSessionString(server);
        ServiceGroupAdminClient client = new ServiceGroupAdminClient(server.getServerURL(), sessionCookie);
        ServiceGroupMetaData[] mData = client.getAllServiceGroups();
        ArrayList<String> services = new ArrayList<String>();
        for (ServiceGroupMetaData sgData : mData) {
            for (ServiceMetaData sData : sgData.getServices()) {
                services.add(sData.getName());
            }
        }
        return services.toArray(new String[services.size()]);
    }
}

