/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.common.clients;

import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.ClientUtil;
import org.wso2.carbon.bam.common.dataobjects.activity.ActivityDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDataDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessagePropertyDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.ServerUserDefinedDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationUserDefinedDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceStatisticsDO;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.BAMDataCollectionDSStub;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddActivityData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddActivityData_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddMessageData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddMessageDataDump;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddMessageDataDump_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddMessageData_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddMessageProperty_batch_req;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddMessageProperty_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddOperationData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddOperationData_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddOperationUserData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddOperationUserData_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddServerData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddServerData_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddServerUserData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddServerUserData_type0;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddServiceData;
import org.wso2.carbon.bam.services.stub.bamdatacollectionds.types.AddServiceData_type0;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public class BAMDataCollectionDSClient {
    private static final String BAM_DATA_COLLECTION_DS = "BAMDataCollectionDS";
    private BAMDataCollectionDSStub bamDataCollectionDSStub;
    private static final Log log = LogFactory.getLog(BAMDataCollectionDSClient.class);

    public BAMDataCollectionDSClient(String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_DATA_COLLECTION_DS);
            this.bamDataCollectionDSStub = new BAMDataCollectionDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup() {
        block2: {
            try {
                this.bamDataCollectionDSStub._getServiceClient().cleanupTransport();
                this.bamDataCollectionDSStub._getServiceClient().cleanup();
                this.bamDataCollectionDSStub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    public void addServerData(ServerStatisticsDO statisticsDO) throws BAMException {
        try {
            AddServerData adddata = new AddServerData();
            AddServerData_type0 type = new AddServerData_type0();
            type.setServerID(statisticsDO.getServerID());
            type.setTimestamp(BAMCalendar.getInstance((Calendar)statisticsDO.getTimestamp()).getBAMTimestamp());
            type.setAvgResTime(statisticsDO.getAvgResTime());
            type.setCumFaultCount(statisticsDO.getFaultCount());
            type.setCumReqCount(statisticsDO.getReqCount());
            type.setCumResCount(statisticsDO.getResCount());
            type.setMaxResTime(statisticsDO.getMaxResTime());
            type.setMinResTime(statisticsDO.getMinResTime());
            adddata.setAddServerData(type);
            this.bamDataCollectionDSStub.addServerData(adddata);
        }
        catch (Exception e) {
            throw new BAMException("addServerData failed", (Throwable)e);
        }
    }

    public void addServiceData(ServiceStatisticsDO statisticsDO) throws BAMException {
        try {
            AddServiceData adddata = new AddServiceData();
            AddServiceData_type0 type = new AddServiceData_type0();
            type.setServiceID(statisticsDO.getServiceID());
            type.setAvgResTime(statisticsDO.getAvgResTime());
            type.setCumFaultCount(statisticsDO.getFaultCount());
            type.setCumReqCount(statisticsDO.getReqCount());
            type.setCumResCount(statisticsDO.getResCount());
            type.setMaxResTime(statisticsDO.getMaxResTime());
            type.setMinResTime(statisticsDO.getMinResTime());
            type.setTimestamp(BAMCalendar.getInstance((Calendar)statisticsDO.getTimestamp()).getBAMTimestamp());
            adddata.setAddServiceData(type);
            this.bamDataCollectionDSStub.addServiceData(adddata);
        }
        catch (Exception e) {
            throw new BAMException("addServiceData failed", (Throwable)e);
        }
    }

    public void addOperationData(OperationStatisticsDO statisticsDO) throws BAMException {
        try {
            AddOperationData adddata = new AddOperationData();
            AddOperationData_type0 type = new AddOperationData_type0();
            type.setOperationID(statisticsDO.getOperationID());
            type.setAvgResTime(statisticsDO.getAvgResTime());
            type.setCumFaultCount(statisticsDO.getFaultCount());
            type.setCumReqCount(statisticsDO.getReqCount());
            type.setCumResCount(statisticsDO.getResCount());
            type.setMaxResTime(statisticsDO.getMaxResTime());
            type.setMinResTime(statisticsDO.getMinResTime());
            type.setTimestamp(BAMCalendar.getInstance((Calendar)statisticsDO.getTimestamp()).getBAMTimestamp());
            adddata.setAddOperationData(type);
            this.bamDataCollectionDSStub.addOperationData(adddata);
        }
        catch (Exception e) {
            throw new BAMException("addOperationData failed", (Throwable)e);
        }
    }

    public void addServerUserDefinedData(ServerUserDefinedDO serverUserDefinedDO) throws BAMException {
        try {
            AddServerUserData adddata = new AddServerUserData();
            AddServerUserData_type0 type = new AddServerUserData_type0();
            type.setServerID(serverUserDefinedDO.getServerID());
            type.setTimestamp(BAMCalendar.getInstance((Calendar)serverUserDefinedDO.getTimestamp()).getBAMTimestamp());
            type.setKey(serverUserDefinedDO.getKey());
            type.setValue(serverUserDefinedDO.getValue());
            adddata.setAddServerUserData(type);
            this.bamDataCollectionDSStub.addServerUserData(adddata);
        }
        catch (Exception e) {
            throw new BAMException("addServerUserDefinedData failed", (Throwable)e);
        }
    }

    public synchronized void addActivityData(ActivityDO activityDO) throws BAMException {
        try {
            AddActivityData data = new AddActivityData();
            AddActivityData_type0 type = new AddActivityData_type0();
            type.setName(activityDO.getName());
            type.setDescription(activityDO.getDescription());
            type.setUserDefinedID(activityDO.getActivityId());
            data.setAddActivityData(type);
            this.bamDataCollectionDSStub.addActivityData(data);
        }
        catch (Exception e) {
            throw new BAMException("addActivityData failed", (Throwable)e);
        }
    }

    public synchronized void addMessageData(MessageDO messageDO) throws BAMException {
        try {
            AddMessageData data = new AddMessageData();
            AddMessageData_type0 type = new AddMessageData_type0();
            type.setOperationID(messageDO.getOperationId());
            type.setMsgID(messageDO.getMessageId());
            type.setActivityID(messageDO.getActivityKeyId());
            type.setIpAddress(messageDO.getIPAddress());
            type.setTimestamp(messageDO.getTimestamp());
            type.setUserAgent(messageDO.getUserAgent());
            data.setAddMessageData(type);
            this.bamDataCollectionDSStub.addMessageData(data);
        }
        catch (Exception e) {
            throw new BAMException("addMessageData failed", (Throwable)e);
        }
    }

    public void addMessageDataDump(MessageDataDO messageDataDO, String direction) throws BAMException {
        try {
            AddMessageDataDump data = new AddMessageDataDump();
            AddMessageDataDump_type0 type = new AddMessageDataDump_type0();
            if ("Request".equals(direction)) {
                String status = messageDataDO.getRequestMessageStatus();
                if (status == null) {
                    status = "";
                }
                type.setActivityKeyID(messageDataDO.getActivityKeyId());
                type.setMessageKeyID(messageDataDO.getMessageKeyId());
                type.setIpAddress(messageDataDO.getIpAddress());
                type.setMessageBody(messageDataDO.getMessageBody());
                type.setMessageDirection("Request");
                type.setStatus(status);
                type.setTimeStamp(messageDataDO.getTimestamp());
                data.setAddMessageDataDump(type);
                this.bamDataCollectionDSStub.addMessageDataDump(data);
            } else if ("Response".equals(direction)) {
                String status = messageDataDO.getResponseMessageStatus();
                if (status == null) {
                    status = "";
                }
                type.setActivityKeyID(messageDataDO.getActivityKeyId());
                type.setMessageKeyID(messageDataDO.getMessageKeyId());
                type.setIpAddress(messageDataDO.getIpAddress());
                type.setMessageBody(messageDataDO.getMessageBody());
                type.setMessageDirection("Response");
                type.setStatus(status);
                type.setTimeStamp(messageDataDO.getTimestamp());
                data.setAddMessageDataDump(type);
                this.bamDataCollectionDSStub.addMessageDataDump(data);
            }
        }
        catch (Exception e) {
            throw new BAMException("addMessageData failed", (Throwable)e);
        }
    }

    public synchronized void addMessageProperty(MessagePropertyDO messagePropertyDO) throws BAMException {
        try {
            String[] keyArray = messagePropertyDO.getKeyArray();
            String[] valueArray = messagePropertyDO.getValueArray();
            AddMessageProperty_batch_req batch_req = new AddMessageProperty_batch_req();
            AddMessageProperty_type0[] properties = new AddMessageProperty_type0[keyArray.length];
            for (int i = 0; i < properties.length; ++i) {
                properties[i] = new AddMessageProperty_type0();
                properties[i].setActiivtyID(messagePropertyDO.getActivityKeyId());
                properties[i].setMessageID(messagePropertyDO.getMessageKeyId());
                properties[i].setKey(keyArray[i]);
                properties[i].setValue(valueArray[i]);
            }
            batch_req.setAddMessageProperty(properties);
            this.bamDataCollectionDSStub.addMessageProperty_batch_req(batch_req);
        }
        catch (Exception e) {
            throw new BAMException("addMessageProperty failed", (Throwable)e);
        }
    }

    public void addUserDefinedOperationData(OperationUserDefinedDO operationUserDefinedDO) throws BAMException {
        try {
            AddOperationUserData data = new AddOperationUserData();
            AddOperationUserData_type0 type = new AddOperationUserData_type0();
            type.setOperationID(operationUserDefinedDO.getOperationID());
            type.setKey(operationUserDefinedDO.getKey());
            type.setValue(operationUserDefinedDO.getValue());
            type.setTimestamp(BAMCalendar.getInstance((Calendar)operationUserDefinedDO.getTimestamp()).getBAMTimestamp());
            data.setAddOperationUserData(type);
            this.bamDataCollectionDSStub.addOperationUserData(data);
        }
        catch (Exception e) {
            throw new BAMException("addServerUserDefinedData failed", (Throwable)e);
        }
    }
}

