/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.util;

import java.util.regex.Pattern;

public class TimeRange {
    private int type = 10;
    private int value = 0;

    public TimeRange(int type, int value) {
        this.type = type;
        this.value = value;
    }

    public int getRangeInHours() {
        int ret = this.value;
        switch (this.type) {
            case 2: {
                ret *= 30;
                break;
            }
            case 6: {
                ret *= 24;
            }
        }
        return ret;
    }

    public int getRangeInSeconds() {
        return this.getRangeInHours() * 60 * 60;
    }

    public static TimeRange parseTimeRange(String timeRange) {
        String regexp = "[0-9]+[hdm]";
        if (Pattern.compile(regexp).matcher(timeRange).matches()) {
            int rangeValue = Integer.parseInt(timeRange.substring(0, timeRange.length() - 1));
            int rangeType = 10;
            switch (timeRange.charAt(timeRange.length() - 1)) {
                case 'h': {
                    rangeType = 10;
                    break;
                }
                case 'd': {
                    rangeType = 6;
                    break;
                }
                case 'm': {
                    rangeType = 2;
                }
            }
            return new TimeRange(rangeType, rangeValue);
        }
        throw new IllegalArgumentException("Invalid time Range provided");
    }

    public String toString() {
        String typeString = "INVALID";
        switch (this.type) {
            case 10: {
                typeString = "h";
                break;
            }
            case 6: {
                typeString = "d";
                break;
            }
            case 2: {
                typeString = "m";
            }
        }
        return this.value + typeString;
    }

    public long getRangeInMilli() {
        return this.getRangeInSeconds() * 1000;
    }

    public int getType() {
        return this.type;
    }

    public int getValue() {
        return this.value;
    }
}

