-- WSO2 BAM DATABASE SQL FOR MySQL

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

SET AUTOCOMMIT=0;
START TRANSACTION;

--
-- TABLES
--

CREATE TABLE IF NOT EXISTS BAM_ACTIVITY (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_NAME VARCHAR(255),
  BAM_DESCRIPTION VARCHAR(1024),
  BAM_USER_DEFINED_ID VARCHAR(255) NOT NULL,
  PRIMARY KEY (BAM_ID),
  UNIQUE KEY INDEX_4 (BAM_USER_DEFINED_ID),
  KEY INDEX_2 (BAM_NAME),
  KEY INDEX_3 (BAM_USER_DEFINED_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS BAM_DAY_DIM (
  BAM_ID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  BAM_NAME VARCHAR(24),
  BAM_DAY_OF_WEEK INT(11) NOT NULL,
  BAM_DAY_OF_MONTH INT(11) NOT NULL,
  BAM_DAY_OF_YEAR INT(11) NOT NULL,
  BAM_MONTH INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_MONTH (BAM_MONTH)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_ENDPOINT_STAT_DAY_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_DAY_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_DAY_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_ENDPOINT_STAT_HOUR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_HOUR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_HOUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_ENDPOINT_STAT_MONTH_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_MONTH_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_ENDPOINT_STAT_QTR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_QTR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_ENDPOINT_STAT_YEAR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_YEAR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_YEAR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_HOUR_DIM (
  BAM_ID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  BAM_HOUR_NO INT(11) NOT NULL,
  BAM_DAY INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_DAY (BAM_DAY)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_MESSAGE (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OP_ID INT(10) UNSIGNED NOT NULL,
  BAM_MSG_ID VARCHAR(255) NOT NULL COMMENT 'WS-ADDRESSING MESSAGE ID',
  BAM_ACTIVITY_ID INT(10) UNSIGNED DEFAULT NULL,
  BAM_TIMESTAMP DATETIME,
  BAM_IP_ADDRESS VARCHAR(45),
  BAM_USER_AGENT VARCHAR(45),
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_MESSAGE_1 (BAM_OP_ID),
  KEY FK_BAM_MESSAGE_2 (BAM_ACTIVITY_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_MESSAGE_USER_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_MESSAGE_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_MESSAGE_USER_DATA_1 (BAM_MESSAGE_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_MESSAGE_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_MESSAGE_ID INT(10) UNSIGNED NOT NULL,
  BAM_ACTIVITY_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME,
  BAM_DIRECTION VARCHAR(10),
  BAM_MESSAGE MEDIUMTEXT,
  BAM_IP_ADDRESS VARCHAR(45),
  BAM_STATUS VARCHAR(45),
  PRIMARY KEY (BAM_ID)
)ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_MESSAGE_DATA_ARCHIVE (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_MESSAGE_ID INT(10) UNSIGNED NOT NULL,
  BAM_ACTIVITY_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME,
  BAM_DIRECTION VARCHAR(10),
  BAM_MESSAGE TEXT(1024000),
  BAM_IP_ADDRESS VARCHAR(45),
  BAM_STATUS VARCHAR(45),
  PRIMARY KEY (BAM_ID)
)ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_MESSAGE_PROPERTIES (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_MESSAGE_ID INT(10) UNSIGNED NOT NULL,
  BAM_ACTIVITY_ID INT(10) UNSIGNED NOT NULL,
  BAM_KEY VARCHAR(700),
  BAM_VALUE TEXT(1024000),
  PRIMARY KEY (BAM_ID),
  UNIQUE MSG_PROP_UNIQUE_KEY (BAM_MESSAGE_ID,BAM_ACTIVITY_ID,BAM_KEY)
)ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_XPATH (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_ALIAS VARCHAR(1024),
  BAM_NAME VARCHAR(1024),
  BAM_XPATH VARCHAR(1024000),
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID)
)ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_NAMESPACE (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_XPATH_ID INT(10) UNSIGNED NOT NULL,
  BAM_PREFIX VARCHAR(1024),
  BAM_URI VARCHAR(1024000),
  PRIMARY KEY (BAM_ID)
)ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_MONTH_DIM (
  BAM_ID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  BAM_NAME VARCHAR(24),
  BAM_NO INT(11) NOT NULL,
  BAM_QTR INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_QTR (BAM_QTR)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_OP_NAME VARCHAR(255) NOT NULL,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_OPERATION_1 (BAM_SERVICE_ID),
  KEY INDEX_3 (BAM_OP_NAME)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=9 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_CUM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_CUM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_OPERATION_DATA_1 (BAM_OPERATION_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_STAT_DAY_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_DAY_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_OPERATION_ID (BAM_OPERATION_ID,BAM_DAY_ID),
  KEY BAM_DAY_ID (BAM_DAY_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_STAT_HOUR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_HOUR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_OPERATION_ID (BAM_OPERATION_ID,BAM_HOUR_ID),
  KEY BAM_HOUR_ID (BAM_HOUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_STAT_MONTH_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_MONTH_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_OPERATION_ID (BAM_OPERATION_ID),
  KEY BAM_MONTH_ID (BAM_MONTH_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_STAT_QTR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_QTR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_OPERATION_ID (BAM_OPERATION_ID),
  KEY BAM_QTR_ID (BAM_QTR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_STAT_YEAR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_YEAR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_OPERATION_ID (BAM_OPERATION_ID),
  KEY BAM_YEAR_ID (BAM_YEAR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_OPERATION_USER_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_OPERATION_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_OPERATION_USER_DATA_1 (BAM_OPERATION_ID),
  KEY INDEX_3 (BAM_KEY)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_PROXY_STAT_DAY_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_DAY_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_DAY_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_PROXY_STAT_HOUR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_HOUR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_HOUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_PROXY_STAT_MONTH_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_MONTH_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_PROXY_STAT_QTR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_QTR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_PROXY_STAT_YEAR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_YEAR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_YEAR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_QTR_DIM (
  BAM_ID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  BAM_NAME VARCHAR(24),
  BAM_NO INT(11) NOT NULL,
  BAM_YEAR INT(11) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_YEAR (BAM_YEAR),
  KEY BAM_YEAR_2 (BAM_YEAR)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SEQUENCE_STAT_DAY_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_DAY_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_DAY_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SEQUENCE_STAT_HOUR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_HOUR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_HOUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SEQUENCE_STAT_MONTH_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_MONTH_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SEQUENCE_STAT_QTR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_QTR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SEQUENCE_STAT_YEAR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_YEAR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_YEAR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER (
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_TENENT_ID INT(10) UNSIGNED DEFAULT NULL,
  BAM_TYPE VARCHAR(128) NOT NULL,
  BAM_CATEGORY INT(4) UNSIGNED DEFAULT NULL,
  BAM_URL VARCHAR(255) NOT NULL,
  BAM_ACTIVE BOOLEAN NOT NULL DEFAULT TRUE,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  BAM_EPR VARCHAR(255) DEFAULT NULL,
  BAM_SUBSCRIPTION_ID VARCHAR(255) DEFAULT NULL,
  USERNAME VARCHAR(255) DEFAULT NULL,
  PASSWORD VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (BAM_SERVER_ID),
  KEY INDEX_3 (BAM_URL),
  KEY INDEX_4 (BAM_CATEGORY)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=21 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_CATEGORY (
  BAM_CATEGORY INT(4) UNSIGNED NOT NULL ,
  BAM_CATEGORY_NAME VARCHAR(45) NOT NULL ,
  PRIMARY KEY (BAM_CATEGORY)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_CUM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_CUM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY INDEX_2 (BAM_TIMESTAMP),
  KEY FK_BAM_SERVER_DATA_1 (BAM_SERVER_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=3 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_LOGIN_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_CUM_LOGIN_ATTEMPTS INT(10) UNSIGNED NOT NULL,
  BAM_CUM_FAILED_LOGIN_ATTEMPTS INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_SERVER1 (BAM_SERVER_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=4 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_STAT_DAY_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_DAY_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_DAY_ID (BAM_DAY_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_STAT_HOUR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_HOUR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_HOUR_ID (BAM_HOUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_STAT_MONTH_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_MONTH_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_MONTH_ID (BAM_MONTH_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_STAT_QTR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_QTR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_QTR_ID (BAM_QTR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_STAT_YEAR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_YEAR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVER_ID (BAM_SERVER_ID),
  KEY BAM_YEAR_ID (BAM_YEAR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_USER_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY INDEX_2 (BAM_KEY),
  KEY FK_BAM_SERVER_USER_DATA_1 (BAM_SERVER_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=4 ;

CREATE TABLE IF NOT EXISTS BAM_SERVER_USER_LOGIN_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_USER_NAME VARCHAR(45) NOT NULL,
  BAM_CUM_LOGIN_ATTEMPTS INT(10) UNSIGNED NOT NULL,
  BAM_CUM_FAILED_LOGIN_ATTEMPTS INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_SERVER_USER_LOGIN_DATA_1 (BAM_SERVER_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=3 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVER_ID INT(10) UNSIGNED NOT NULL,
  BAM_SERVICE_NAME VARCHAR(255) NOT NULL,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_SERVICE_1 (BAM_SERVER_ID),
  KEY INDEX_3 (BAM_SERVICE_NAME)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=13 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_CUM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_CUM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_SERVICE_DATA_1 (BAM_SERVICE_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=3 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_STAT_DAY_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_DAY_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVICE_ID (BAM_SERVICE_ID),
  KEY BAM_DAY_ID (BAM_DAY_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_STAT_HOUR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_HOUR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVICE_ID (BAM_SERVICE_ID),
  KEY BAM_HOUR_ID (BAM_HOUR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_STAT_MONTH_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_MONTH_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVICE_ID (BAM_SERVICE_ID),
  KEY BAM_MONTH_ID (BAM_MONTH_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_STAT_QTR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_QTR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVICE_ID (BAM_SERVICE_ID),
  KEY BAM_QTR_ID (BAM_QTR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_STAT_YEAR_FACT (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_YEAR_ID INT(10) UNSIGNED NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_RES_COUNT INT(10) UNSIGNED NOT NULL,
  BAM_FAULT_COUNT INT(10) UNSIGNED NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY BAM_SERVICE_ID (BAM_SERVICE_ID),
  KEY BAM_YEAR_ID (BAM_YEAR_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_SERVICE_USER_DATA (
  BAM_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_SERVICE_ID INT(10) UNSIGNED NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  KEY FK_BAM_SERVICE_USER_DATA_1 (BAM_SERVICE_ID),
  KEY INDEX_3 (BAM_KEY)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS BAM_TENENT (
  BAM_TENENT_ID INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_TENENT_ID)
) ENGINE=INNODB  DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=7 ;

CREATE TABLE IF NOT EXISTS BAM_YEAR_DIM (
  BAM_ID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  BAM_START_TIMESTAMP TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  BAM_NO INT(11) NOT NULL,
  PRIMARY KEY (BAM_ID)
) ENGINE=INNODB DEFAULT CHARSET=LATIN1 AUTO_INCREMENT=1 ;

--
-- CONSTRAINTS
--

ALTER TABLE BAM_DAY_DIM
  ADD CONSTRAINT BAM_DAY_DIM_IBFK_1 FOREIGN KEY (BAM_MONTH) REFERENCES BAM_MONTH_DIM (BAM_ID);

ALTER TABLE BAM_ENDPOINT_STAT_DAY_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID),
  ADD CONSTRAINT BAM_ENDPOINT_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_ENDPOINT_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_ENDPOINT_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_ENDPOINT_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID),
  ADD CONSTRAINT BAM_ENDPOINT_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_ENDPOINT_STAT_QTR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_ENDPOINT_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_ENDPOINT_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_ENDPOINT_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_HOUR_DIM
  ADD CONSTRAINT BAM_HOUR_DIM_IBFK_1 FOREIGN KEY (BAM_DAY) REFERENCES BAM_DAY_DIM (BAM_ID);

ALTER TABLE BAM_MESSAGE
  ADD CONSTRAINT FK_BAM_MESSAGE_1 FOREIGN KEY (BAM_OP_ID) REFERENCES BAM_OPERATION (BAM_ID),
  ADD CONSTRAINT FK_BAM_MESSAGE_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);

ALTER TABLE BAM_MESSAGE_USER_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_USER_DATA_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID);

ALTER TABLE BAM_MONTH_DIM
  ADD CONSTRAINT BAM_MONTH_DIM_IBFK_1 FOREIGN KEY (BAM_QTR) REFERENCES BAM_QTR_DIM (BAM_ID);

ALTER TABLE BAM_OPERATION
  ADD CONSTRAINT FK_BAM_OPERATION_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_OPERATION_DATA
  ADD CONSTRAINT FK_BAM_OPERATION_DATA_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_OPERATION_STAT_DAY_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID),
  ADD CONSTRAINT BAM_OPERATION_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_OPERATION_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_OPERATION_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_OPERATION_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID),
  ADD CONSTRAINT BAM_OPERATION_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_OPERATION_STAT_QTR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_OPERATION_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_OPERATION_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_OPERATION_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_OPERATION_USER_DATA
  ADD CONSTRAINT FK_BAM_OPERATION_USER_DATA_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);

ALTER TABLE BAM_PROXY_STAT_DAY_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID),
  ADD CONSTRAINT BAM_PROXY_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_PROXY_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_PROXY_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_PROXY_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID),
  ADD CONSTRAINT BAM_PROXY_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_PROXY_STAT_QTR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_PROXY_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_PROXY_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_PROXY_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_QTR_DIM
  ADD CONSTRAINT BAM_QTR_DIM_IBFK_1 FOREIGN KEY (BAM_YEAR) REFERENCES BAM_YEAR_DIM (BAM_ID);

ALTER TABLE BAM_SEQUENCE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SEQUENCE_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SEQUENCE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SEQUENCE_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SEQUENCE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SEQUENCE_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SEQUENCE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SEQUENCE_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SEQUENCE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SEQUENCE_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_DATA
  ADD CONSTRAINT FK_BAM_SERVER_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_LOGIN_DATA
  ADD CONSTRAINT FK_BAM_SERVER1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID) ON DELETE NO ACTION ON UPDATE NO ACTION;

ALTER TABLE BAM_SERVER_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVER_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVER_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVER_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVER_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVER_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_USER_DATA
  ADD CONSTRAINT FK_BAM_SERVER_USER_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER_USER_LOGIN_DATA
  ADD CONSTRAINT FK_BAM_SERVER_USER_LOGIN_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVER 
  ADD CONSTRAINT FK_BAM_SERVER_1 FOREIGN KEY (BAM_CATEGORY) REFERENCES BAM_SERVER_CATEGORY (BAM_CATEGORY);

ALTER TABLE BAM_SERVICE
  ADD CONSTRAINT FK_BAM_SERVICE_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

ALTER TABLE BAM_SERVICE_DATA
  ADD CONSTRAINT FK_BAM_SERVICE_DATA_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_SERVICE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVICE_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_SERVICE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVICE_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_SERVICE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVICE_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_SERVICE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVICE_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_SERVICE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID),
  ADD CONSTRAINT BAM_SERVICE_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_SERVICE_USER_DATA
  ADD CONSTRAINT FK_BAM_SERVICE_USER_DATA_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

ALTER TABLE BAM_MESSAGE_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID),
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);

ALTER TABLE BAM_MESSAGE_DATA_ARCHIVE
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_ARCHIVE_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID),
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_ARCHIVE_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);

ALTER TABLE BAM_MESSAGE_PROPERTIES
  ADD CONSTRAINT FK_BAM_MESSAGE_PROP_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID),
  ADD CONSTRAINT FK_BAM_MESSAGE_PROP_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);

--
-- VALUES
--

INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (1, 'service');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (2, 'message');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (4, 'mediation');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (8, 'generic');

COMMIT;


