-- WSO2 BAM DATABASE SQL FOR MSSQL
--
-- TABLES
--
IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ACTIVITY]') AND TYPE IN (N'U'))
CREATE TABLE BAM_ACTIVITY (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_NAME VARCHAR(255),
  BAM_DESCRIPTION VARCHAR(1024),
  BAM_USER_DEFINED_ID VARCHAR(255) NOT NULL,
  PRIMARY KEY (BAM_ID),
)

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_DAY_DIM]') AND TYPE IN (N'U'))
CREATE TABLE BAM_DAY_DIM (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_START_TIMESTAMP DATETIME NOT NULL,
  BAM_NAME VARCHAR(24),
  BAM_DAY_OF_WEEK INT NOT NULL,
  BAM_DAY_OF_MONTH INT NOT NULL,
  BAM_DAY_OF_YEAR INT NOT NULL,
  BAM_MONTH INT NOT NULL,
  PRIMARY KEY (BAM_ID),
)

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_DAY_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_ENDPOINT_STAT_DAY_FACT (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_HOUR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_ENDPOINT_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )
IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_MONTH_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_ENDPOINT_STAT_MONTH_FACT (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_QTR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_ENDPOINT_STAT_QTR_FACT (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_YEAR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_ENDPOINT_STAT_YEAR_FACT (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_ENDPOINT_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_HOUR_DIM]') AND TYPE IN (N'U'))
CREATE TABLE BAM_HOUR_DIM (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_START_TIMESTAMP DATETIME NOT NULL,
  BAM_HOUR_NO INT NOT NULL,
  BAM_DAY INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE]') AND TYPE IN (N'U'))
CREATE TABLE BAM_MESSAGE (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_OP_ID INT NOT NULL,
  BAM_MSG_ID VARCHAR(255) NOT NULL, -- 'WS-ADDRESSING MESSAGE ID'
  BAM_ACTIVITY_ID INT DEFAULT NULL,
  BAM_TIMESTAMP DATETIME,
  BAM_IP_ADDRESS VARCHAR(45),
  BAM_USER_AGENT VARCHAR(45),
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_USER_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_MESSAGE_USER_DATA (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_MESSAGE_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_MESSAGE_DATA (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_MESSAGE_ID INT  NOT NULL,
  BAM_ACTIVITY_ID INT  NOT NULL,
  BAM_TIMESTAMP DATETIME,
  BAM_DIRECTION VARCHAR(10),
  BAM_MESSAGE VARCHAR(MAX),
  BAM_IP_ADDRESS VARCHAR(45),
  BAM_STATUS VARCHAR(45),
  PRIMARY KEY (BAM_ID),
);

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_DATA_ARCHIVE]') AND TYPE IN (N'U'))
CREATE TABLE BAM_MESSAGE_DATA_ARCHIVE (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_MESSAGE_ID INT  NOT NULL,
  BAM_ACTIVITY_ID INT  NOT NULL,
  BAM_TIMESTAMP DATETIME,
  BAM_DIRECTION VARCHAR(10),
  BAM_MESSAGE VARCHAR(MAX),
  BAM_IP_ADDRESS VARCHAR(45),
  BAM_STATUS VARCHAR(45),
  PRIMARY KEY (BAM_ID),
);

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_PROPERTIES]') AND TYPE IN (N'U'))
CREATE TABLE  BAM_MESSAGE_PROPERTIES (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_MESSAGE_ID INT NOT NULL,
  BAM_ACTIVITY_ID INT NOT NULL,
  BAM_KEY VARCHAR(700),
  BAM_VALUE VARCHAR(MAX),
  PRIMARY KEY (BAM_ID),
  UNIQUE (BAM_MESSAGE_ID,BAM_ACTIVITY_ID,BAM_KEY),
);

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_XPATH]') AND TYPE IN (N'U'))

CREATE TABLE  BAM_XPATH (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_ALIAS VARCHAR(1024),
  BAM_NAME VARCHAR(1024),
  BAM_XPATH VARCHAR(MAX),
  BAM_SERVER_ID INT NOT NULL,
  PRIMARY KEY (BAM_ID)
);

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_NAMESPACE]') AND TYPE IN (N'U'))
CREATE TABLE  BAM_NAMESPACE (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_XPATH_ID INT NOT NULL,
  BAM_PREFIX VARCHAR(1024),
  BAM_URI VARCHAR(MAX),
  PRIMARY KEY (BAM_ID)
);

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MONTH_DIM]') AND TYPE IN (N'U'))
CREATE TABLE BAM_MONTH_DIM (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_START_TIMESTAMP DATETIME NOT NULL,
  BAM_NAME VARCHAR(24),
  BAM_NO INT NOT NULL,
  BAM_QTR INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_OP_NAME VARCHAR(255)NOT NULL,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_ID),
 ) 

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_DATA (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_REQ_COUNT INT NOT NULL,
  BAM_CUM_RES_COUNT INT NOT NULL,
  BAM_CUM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_DAY_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_STAT_DAY_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_HOUR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_STAT_HOUR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_MONTH_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_STAT_MONTH_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_QTR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_STAT_QTR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_YEAR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_STAT_YEAR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_USER_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_OPERATION_USER_DATA (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_OPERATION_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_DAY_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_PROXY_STAT_DAY_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_DAY_ID INT  NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_HOUR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_PROXY_STAT_HOUR_FACT (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_MONTH_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_PROXY_STAT_MONTH_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_QTR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_PROXY_STAT_QTR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_YEAR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_PROXY_STAT_YEAR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_PROXY_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
)

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_QTR_DIM]') AND TYPE IN (N'U'))
CREATE TABLE BAM_QTR_DIM (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_START_TIMESTAMP DATETIME NOT NULL,
  BAM_NAME VARCHAR(24),
  BAM_NO INT NOT NULL,
  BAM_YEAR INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_DAY_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SEQUENCE_STAT_DAY_FACT (
 BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_HOUR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SEQUENCE_STAT_HOUR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT  NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_MONTH_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SEQUENCE_STAT_MONTH_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_MONTH_ID INT  NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT  NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_QTR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SEQUENCE_STAT_QTR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT  NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_YEAR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SEQUENCE_STAT_YEAR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SEQUENCE_NAME VARCHAR(512) NOT NULL,
  BAM_DIRECTION VARCHAR(10) NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER (
  BAM_SERVER_ID INT NOT NULL IDENTITY,
  BAM_TENENT_ID INT DEFAULT NULL,
  BAM_TYPE VARCHAR(128) NOT NULL,
  BAM_CATEGORY INT DEFAULT NULL,
  BAM_URL VARCHAR(255)NOT NULL,
  BAM_ACTIVE BIT NOT NULL DEFAULT 1,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  BAM_EPR VARCHAR(255) DEFAULT NULL,
  BAM_SUBSCRIPTION_ID VARCHAR(255) DEFAULT NULL,
  USERNAME VARCHAR(255) DEFAULT NULL,
  PASSWORD VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (BAM_SERVER_ID),
)

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_CATEGORY]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_CATEGORY (
  BAM_CATEGORY INT NOT NULL ,
  BAM_CATEGORY_NAME VARCHAR(45) NOT NULL ,
  PRIMARY KEY (BAM_CATEGORY),
)

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_DATA (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_FAULT_COUNT INT NOT NULL,
  BAM_CUM_REQ_COUNT INT NOT NULL,
  BAM_CUM_RES_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_LOGIN_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_LOGIN_DATA (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_CUM_LOGIN_ATTEMPTS INT NOT NULL,
  BAM_CUM_FAILED_LOGIN_ATTEMPTS INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_DAY_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_STAT_DAY_FACT (
 BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_HOUR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_STAT_HOUR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_MONTH_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_STAT_MONTH_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_MONTH_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_QTR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE  BAM_SERVER_STAT_QTR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_YEAR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_STAT_YEAR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_USER_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_USER_DATA (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_USER_LOGIN_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVER_USER_LOGIN_DATA (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_USER_NAME VARCHAR(45) NOT NULL,
  BAM_CUM_LOGIN_ATTEMPTS INT NOT NULL,
  BAM_CUM_FAILED_LOGIN_ATTEMPTS INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVER_ID INT NOT NULL,
  BAM_SERVICE_NAME VARCHAR(255) NOT NULL,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_DATA (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_CUM_REQ_COUNT INT NOT NULL,
  BAM_CUM_RES_COUNT INT NOT NULL,
  BAM_CUM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_DAY_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_STAT_DAY_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_DAY_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_HOUR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_STAT_HOUR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_HOUR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_MONTH_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_STAT_MONTH_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_MONTH_ID INT  NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_QTR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_STAT_QTR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_QTR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_YEAR_FACT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_STAT_YEAR_FACT (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_YEAR_ID INT NOT NULL,
  BAM_AVG_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MAX_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_MIN_RES_TIME DECIMAL(10,0) NOT NULL,
  BAM_REQ_COUNT INT NOT NULL,
  BAM_RES_COUNT INT  NOT NULL,
  BAM_FAULT_COUNT INT NOT NULL,
  PRIMARY KEY (BAM_ID),
  )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_USER_DATA]') AND TYPE IN (N'U'))
CREATE TABLE BAM_SERVICE_USER_DATA (
   BAM_ID INT NOT NULL IDENTITY,
  BAM_SERVICE_ID INT NOT NULL,
  BAM_TIMESTAMP DATETIME NOT NULL,
  BAM_KEY VARCHAR(255) NOT NULL,
  BAM_VALUE VARCHAR(1024) NOT NULL,
  PRIMARY KEY (BAM_ID),
 )

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_TENENT]') AND TYPE IN (N'U'))
CREATE TABLE BAM_TENENT (
   BAM_TENENT_ID INT NOT NULL IDENTITY,
  BAM_DESCRIPTION VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (BAM_TENENT_ID),
)

IF NOT EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_YEAR_DIM]') AND TYPE IN (N'U'))
CREATE TABLE BAM_YEAR_DIM (
  BAM_ID INT NOT NULL IDENTITY,
  BAM_START_TIMESTAMP DATETIME NOT NULL,
  BAM_NO INT NOT NULL,
  PRIMARY KEY (BAM_ID),
)

--
-- CONSTRAINTS
--
IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_DAY_DIM_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_DAY_DIM]'))
ALTER TABLE BAM_DAY_DIM
  ADD CONSTRAINT BAM_DAY_DIM_IBFK_1 FOREIGN KEY (BAM_MONTH) REFERENCES BAM_MONTH_DIM (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_DAY_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_DAY_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_DAY_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_DAY_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_DAY_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_DAY_FACT
   ADD CONSTRAINT BAM_ENDPOINT_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_HOUR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_HOUR_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_HOUR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_HOUR_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_HOUR_FACT
   ADD CONSTRAINT BAM_ENDPOINT_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_MONTH_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_MONTH_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_MONTH_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_MONTH_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_MONTH_FACT
   ADD CONSTRAINT BAM_ENDPOINT_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_QTR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_QTR_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_QTR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_QTR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_QTR_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_QTR_FACT
 ADD CONSTRAINT BAM_ENDPOINT_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_YEAR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_YEAR_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_YEAR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_ENDPOINT_STAT_YEAR_FACT]'))
ALTER TABLE BAM_ENDPOINT_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_ENDPOINT_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_HOUR_DIM_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_HOUR_DIM]'))
ALTER TABLE BAM_HOUR_DIM
  ADD CONSTRAINT BAM_HOUR_DIM_IBFK_1 FOREIGN KEY (BAM_DAY) REFERENCES BAM_DAY_DIM (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE]'))
ALTER TABLE BAM_MESSAGE
  ADD CONSTRAINT FK_BAM_MESSAGE_1 FOREIGN KEY (BAM_OP_ID) REFERENCES BAM_OPERATION (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE]'))
ALTER TABLE BAM_MESSAGE
  ADD CONSTRAINT FK_BAM_MESSAGE_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_USER_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_USER_DATA]'))
ALTER TABLE BAM_MESSAGE_USER_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_USER_DATA_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MONTH_DIM_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MONTH_DIM]'))
ALTER TABLE BAM_MONTH_DIM
  ADD CONSTRAINT BAM_MONTH_DIM_IBFK_1 FOREIGN KEY (BAM_QTR) REFERENCES BAM_QTR_DIM (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_OPERATION_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION]'))
ALTER TABLE BAM_OPERATION
  ADD CONSTRAINT FK_BAM_OPERATION_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_OPERATION_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_DATA]'))
ALTER TABLE BAM_OPERATION_DATA
  ADD CONSTRAINT FK_BAM_OPERATION_DATA_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_DAY_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_DAY_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_DAY_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_DAY_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_DAY_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_DAY_FACT

  ADD CONSTRAINT BAM_OPERATION_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_HOUR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_HOUR_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_HOUR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_HOUR_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_MONTH_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_MONTH_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_MONTH_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_MONTH_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_QTR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_QTR_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_QTR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_QTR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_QTR_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_QTR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_YEAR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_YEAR_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_YEAR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_STAT_YEAR_FACT]'))
ALTER TABLE BAM_OPERATION_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_OPERATION_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_OPERATION_USER_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_OPERATION_USER_DATA]'))
ALTER TABLE BAM_OPERATION_USER_DATA
  ADD CONSTRAINT FK_BAM_OPERATION_USER_DATA_1 FOREIGN KEY (BAM_OPERATION_ID) REFERENCES BAM_OPERATION (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_DAY_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_DAY_FACT]'))
ALTER TABLE BAM_PROXY_STAT_DAY_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_DAY_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_DAY_FACT]'))
ALTER TABLE BAM_PROXY_STAT_DAY_FACT
 ADD CONSTRAINT BAM_PROXY_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_HOUR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_HOUR_FACT]'))
ALTER TABLE BAM_PROXY_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_HOUR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_HOUR_FACT]'))
ALTER TABLE BAM_PROXY_STAT_HOUR_FACT
 ADD CONSTRAINT BAM_PROXY_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_MONTH_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_MONTH_FACT]'))
ALTER TABLE BAM_PROXY_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_MONTH_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_MONTH_FACT]'))
ALTER TABLE BAM_PROXY_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_QTR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_QTR_FACT]'))
ALTER TABLE BAM_PROXY_STAT_QTR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_QTR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_QTR_FACT]'))
ALTER TABLE BAM_PROXY_STAT_QTR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_YEAR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_YEAR_FACT]'))
ALTER TABLE BAM_PROXY_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_YEAR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_PROXY_STAT_YEAR_FACT]'))
ALTER TABLE BAM_PROXY_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_PROXY_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_QTR_DIM_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_QTR_DIM]'))
ALTER TABLE BAM_QTR_DIM
  ADD CONSTRAINT BAM_QTR_DIM_IBFK_1 FOREIGN KEY (BAM_YEAR) REFERENCES BAM_YEAR_DIM (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_DAY_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_DAY_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_DAY_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_DAY_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_HOUR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_HOUR_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_HOUR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_HOUR_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_MONTH_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_MONTH_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_MONTH_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_MONTH_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_QTR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_QTR_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_QTR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_QTR_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_YEAR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_YEAR_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_YEAR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SEQUENCE_STAT_YEAR_FACT]'))
ALTER TABLE BAM_SEQUENCE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SEQUENCE_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVER_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_DATA]'))
ALTER TABLE BAM_SERVER_DATA
  ADD CONSTRAINT FK_BAM_SERVER_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVER1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_LOGIN_DATA]'))
ALTER TABLE BAM_SERVER_LOGIN_DATA
  ADD CONSTRAINT FK_BAM_SERVER1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID) ON DELETE NO ACTION ON UPDATE NO ACTION;


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_DAY_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_DAY_FACT]'))
ALTER TABLE BAM_SERVER_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_DAY_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_DAY_FACT]'))
ALTER TABLE BAM_SERVER_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_HOUR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_HOUR_FACT]'))
ALTER TABLE BAM_SERVER_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_HOUR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_HOUR_FACT]'))
ALTER TABLE BAM_SERVER_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_MONTH_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_MONTH_FACT]'))
ALTER TABLE BAM_SERVER_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_MONTH_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_MONTH_FACT]'))
ALTER TABLE BAM_SERVER_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_QTR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_QTR_FACT]'))
ALTER TABLE BAM_SERVER_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_QTR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_QTR_FACT]'))
ALTER TABLE BAM_SERVER_STAT_QTR_FACT
   ADD CONSTRAINT BAM_SERVER_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_YEAR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_YEAR_FACT]'))
ALTER TABLE BAM_SERVER_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_YEAR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_STAT_YEAR_FACT]'))
ALTER TABLE BAM_SERVER_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVER_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVER_USER_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_USER_DATA]'))
ALTER TABLE BAM_SERVER_USER_DATA
  ADD CONSTRAINT FK_BAM_SERVER_USER_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVER_USER_LOGIN_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER_USER_LOGIN_DATA]'))
ALTER TABLE BAM_SERVER_USER_LOGIN_DATA
  ADD CONSTRAINT FK_BAM_SERVER_USER_LOGIN_DATA_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVER_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVER]'))
ALTER TABLE BAM_SERVER 
  ADD CONSTRAINT FK_BAM_SERVER_1 FOREIGN KEY (BAM_CATEGORY) REFERENCES BAM_SERVER_CATEGORY (BAM_CATEGORY);

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVICE_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE]'))
ALTER TABLE BAM_SERVICE
  ADD CONSTRAINT FK_BAM_SERVICE_1 FOREIGN KEY (BAM_SERVER_ID) REFERENCES BAM_SERVER (BAM_SERVER_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVICE_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_DATA]'))
ALTER TABLE BAM_SERVICE_DATA
  ADD CONSTRAINT FK_BAM_SERVICE_DATA_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_DAY_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_DAY_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_DAY_FACT_IBFK_2 FOREIGN KEY (BAM_DAY_ID) REFERENCES BAM_DAY_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_DAY_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_DAY_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_DAY_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_DAY_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_HOUR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_HOUR_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_HOUR_FACT_IBFK_2 FOREIGN KEY (BAM_HOUR_ID) REFERENCES BAM_HOUR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_HOUR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_HOUR_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_HOUR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_HOUR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_MONTH_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_MONTH_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_MONTH_FACT_IBFK_2 FOREIGN KEY (BAM_MONTH_ID) REFERENCES BAM_MONTH_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_MONTH_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_MONTH_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_MONTH_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_MONTH_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_QTR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_QTR_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_QTR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_QTR_FACT_IBFK_2 FOREIGN KEY (BAM_QTR_ID) REFERENCES BAM_QTR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_QTR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_QTR_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_QTR_FACT
   ADD CONSTRAINT BAM_SERVICE_STAT_QTR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_YEAR_FACT_IBFK_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_YEAR_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_YEAR_FACT_IBFK_2 FOREIGN KEY (BAM_YEAR_ID) REFERENCES BAM_YEAR_DIM (BAM_ID)

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_YEAR_FACT_IBFK_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_STAT_YEAR_FACT]'))
ALTER TABLE BAM_SERVICE_STAT_YEAR_FACT
  ADD CONSTRAINT BAM_SERVICE_STAT_YEAR_FACT_IBFK_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_SERVICE_USER_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_SERVICE_USER_DATA]'))
ALTER TABLE BAM_SERVICE_USER_DATA
  ADD CONSTRAINT FK_BAM_SERVICE_USER_DATA_1 FOREIGN KEY (BAM_SERVICE_ID) REFERENCES BAM_SERVICE (BAM_ID);

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_DATA_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_DATA]'))
ALTER TABLE BAM_MESSAGE_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID);

IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_DATA_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_DATA]'))
ALTER TABLE BAM_MESSAGE_DATA
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_DATA_ARCHIVE_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_DATA_ARCHIVE]'))
ALTER TABLE BAM_MESSAGE_DATA_ARCHIVE
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_ARCHIVE_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_DATA_ARCHIVE_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_DATA_ARCHIVE]'))
ALTER TABLE BAM_MESSAGE_DATA_ARCHIVE
  ADD CONSTRAINT FK_BAM_MESSAGE_DATA_ARCHIVE_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_PROP_1]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_PROPERTIES]'))
ALTER TABLE BAM_MESSAGE_PROPERTIES
  ADD CONSTRAINT FK_BAM_MESSAGE_PROP_1 FOREIGN KEY (BAM_MESSAGE_ID) REFERENCES BAM_MESSAGE (BAM_ID);


IF NOT EXISTS (SELECT * FROM SYS.FOREIGN_KEYS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[FK_BAM_MESSAGE_PROP_2]') AND PARENT_OBJECT_ID = OBJECT_ID(N'[DBO].[BAM_MESSAGE_PROPERTIES]'))
ALTER TABLE BAM_MESSAGE_PROPERTIES
  ADD CONSTRAINT FK_BAM_MESSAGE_PROP_2 FOREIGN KEY (BAM_ACTIVITY_ID) REFERENCES BAM_ACTIVITY (BAM_ID);


--
-- VALUES
--

INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (1, 'service');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (2, 'message');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (4, 'mediation');
INSERT INTO BAM_SERVER_CATEGORY (BAM_CATEGORY, BAM_CATEGORY_NAME) VALUES (8, 'generic');


