/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary.generators;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.clients.BAMSummaryGenerationDSClient;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationSummaryStatistic;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;

public class SequenceSummaryGenerator
extends AbstractSummaryGenerator {
    private static Log log = LogFactory.getLog(SequenceSummaryGenerator.class);
    private MediationDataDO sequence;
    private ServerDO server;

    public SequenceSummaryGenerator(ServerDO server, MediationDataDO sequence, int timeInterval) {
        super(timeInterval);
        this.setSequence(sequence);
        this.setServer(server);
    }

    @Override
    protected void summarizeHourly(BAMCalendar loHour, BAMCalendar hiHour) {
        block4: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                HourDimension hd = spm.getHourDimension((Calendar)loHour);
                if (hd == null) {
                    spm.addHourDimension(loHour);
                    hd = spm.getHourDimension((Calendar)loHour);
                }
                MediationSummaryStatistic stat = spm.getSequenceStatHourlySummary(this.getServer().getId(), this.getSequence().getName(), this.getSequence().getDirection(), loHour, hiHour);
                stat.setName(this.getSequence().getName());
                stat.setTimeDimensionId(hd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getSequence().getDirection());
                SummaryPersistenceManager.getInstance().addSequenceStatHourlySummary(stat);
                TimeRange retention = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).getDataRetentionPeriod();
                if (retention.getValue() != 0) {
                    BAMCalendar delLoHour = BAMCalendar.getInstance((Calendar)loHour);
                    BAMCalendar delHiHour = BAMCalendar.getInstance((Calendar)hiHour);
                    delHiHour.add(retention.getType(), -1 * retention.getValue());
                    delLoHour.add(retention.getType(), -1 * retention.getValue());
                    spm.deleteServerSequenceUserData(this.getServer().getId(), this.getSequence().getName(), this.getSequence().getDirection(), delLoHour, delHiHour);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running hourly summary generator for sequence: " + this.getSequence() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeDaily(BAMCalendar loDay, BAMCalendar hiDay) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                DayDimension dd = spm.getDayDimension((Calendar)loDay);
                if (dd == null) {
                    spm.addDayDimension(loDay);
                    dd = spm.getDayDimension((Calendar)loDay);
                }
                MediationSummaryStatistic stat = spm.getSequenceStatDailySummary(this.getServer().getId(), this.getSequence().getName(), this.getSequence().getDirection(), loDay, hiDay);
                stat.setName(this.getSequence().getName());
                stat.setTimeDimensionId(dd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getSequence().getDirection());
                SummaryPersistenceManager.getInstance().addSequenceStatDailySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running daily summary generator for sequence: " + this.getSequence() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeMonthly(BAMCalendar loMonth, BAMCalendar hiMonth) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                MonthDimension md = spm.getMonthDimension((Calendar)loMonth);
                if (md == null) {
                    spm.addMonthDimension(loMonth);
                    md = spm.getMonthDimension((Calendar)loMonth);
                }
                MediationSummaryStatistic stat = spm.getSequenceStatMonthlySummary(this.getServer().getId(), this.getSequence().getName(), this.getSequence().getDirection(), loMonth, hiMonth);
                stat.setName(this.getSequence().getName());
                stat.setTimeDimensionId(md.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getSequence().getDirection());
                SummaryPersistenceManager.getInstance().addSequenceStatMonthlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running monthly summary generator for sequence: " + this.getSequence() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeQuarterly(BAMCalendar loQuarter, BAMCalendar hiQuarter) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                QuarterDimension qd = spm.getQuarterDimension((Calendar)loQuarter);
                if (qd == null) {
                    spm.addQuarterDimension(loQuarter);
                    qd = spm.getQuarterDimension((Calendar)loQuarter);
                }
                MediationSummaryStatistic stat = spm.getSequenceStatQuarterlySummary(this.getServer().getId(), this.getSequence().getName(), this.getSequence().getDirection(), loQuarter, hiQuarter);
                stat.setName(this.getSequence().getName());
                stat.setTimeDimensionId(qd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getSequence().getDirection());
                SummaryPersistenceManager.getInstance().addSequenceStatQuarterlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running quarterly summary generator for operaion: " + this.getSequence() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeYearly(BAMCalendar loYear, BAMCalendar hiYear) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                YearDimension qd = spm.getYearDimension((Calendar)loYear);
                if (qd == null) {
                    spm.addYearDimension(loYear);
                    qd = spm.getYearDimension((Calendar)loYear);
                }
                MediationSummaryStatistic stat = spm.getSequenceStatYearlySummary(this.getServer().getId(), this.getSequence().getName(), this.getSequence().getDirection(), loYear, hiYear);
                stat.setName(this.getSequence().getName());
                stat.setTimeDimensionId(qd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getSequence().getDirection());
                SummaryPersistenceManager.getInstance().addSequenceStatYearlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running yearly summary generator for operaion: " + this.getSequence() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestSequenceStatSummaryPeriod(this.getTimeInterval(), this.sequence);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestSequenceStatSummaryPeriod(this.getTimeInterval(), this.sequence);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestSequenceStatSummaryPeriod(this.getTimeInterval(), this.sequence);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestDailySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestSequenceStatSummaryPeriod(this.getTimeInterval(), this.sequence);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestSequenceStatSummaryPeriod(this.getTimeInterval(), this.sequence);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    @Override
    protected String getInstanceInfo() {
        return "Server: " + this.server.getServerURL() + ", Sequence: " + this.sequence.getName();
    }

    public MediationDataDO getSequence() {
        return this.sequence;
    }

    public void setSequence(MediationDataDO sequence) {
        this.sequence = sequence;
    }

    public ServerDO getServer() {
        return this.server;
    }

    public void setServer(ServerDO server) {
        this.server = server;
    }
}

