/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary.generators;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.clients.BAMSummaryGenerationDSClient;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationSummaryStatistic;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;

public class ProxyServiceSummaryGenerator
extends AbstractSummaryGenerator {
    private static Log log = LogFactory.getLog(ProxyServiceSummaryGenerator.class);
    private MediationDataDO proxyService;
    private ServerDO server;

    public ProxyServiceSummaryGenerator(ServerDO server, MediationDataDO proxyService, int timeInterval) {
        super(timeInterval);
        this.setProxyService(proxyService);
        this.setServer(server);
    }

    @Override
    protected void summarizeHourly(BAMCalendar loHour, BAMCalendar hiHour) {
        block4: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                HourDimension hd = spm.getHourDimension((Calendar)loHour);
                if (hd == null) {
                    spm.addHourDimension(loHour);
                    hd = spm.getHourDimension((Calendar)loHour);
                }
                MediationSummaryStatistic stat = spm.getProxyServiceStatHourlySummary(this.getServer().getId(), this.getProxyService().getName(), this.getProxyService().getDirection(), loHour, hiHour);
                stat.setName(this.getProxyService().getName());
                stat.setTimeDimensionId(hd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getProxyService().getDirection());
                SummaryPersistenceManager.getInstance().addProxyServiceStatHourlySummary(stat);
                TimeRange retention = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).getDataRetentionPeriod();
                if (retention.getValue() != 0) {
                    BAMCalendar delLoHour = BAMCalendar.getInstance((Calendar)loHour);
                    BAMCalendar delHiHour = BAMCalendar.getInstance((Calendar)hiHour);
                    delHiHour.add(retention.getType(), -1 * retention.getValue());
                    delLoHour.add(retention.getType(), -1 * retention.getValue());
                    spm.deleteServerProxyServiceUserData(this.getServer().getId(), this.getProxyService().getName(), this.getProxyService().getDirection(), delLoHour, delHiHour);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running hourly summary generator for proxyService: " + this.getProxyService() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeDaily(BAMCalendar loDay, BAMCalendar hiDay) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                DayDimension dd = spm.getDayDimension((Calendar)loDay);
                if (dd == null) {
                    spm.addDayDimension(loDay);
                    dd = spm.getDayDimension((Calendar)loDay);
                }
                MediationSummaryStatistic stat = spm.getProxyServiceStatDailySummary(this.getServer().getId(), this.getProxyService().getName(), this.getProxyService().getDirection(), loDay, hiDay);
                stat.setName(this.getProxyService().getName());
                stat.setTimeDimensionId(dd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getProxyService().getDirection());
                SummaryPersistenceManager.getInstance().addProxyServiceStatDailySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running daily summary generator for proxyService: " + this.getProxyService() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeMonthly(BAMCalendar loMonth, BAMCalendar hiMonth) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                MonthDimension md = spm.getMonthDimension((Calendar)loMonth);
                if (md == null) {
                    spm.addMonthDimension(loMonth);
                    md = spm.getMonthDimension((Calendar)loMonth);
                }
                MediationSummaryStatistic stat = spm.getProxyServiceStatMonthlySummary(this.getServer().getId(), this.getProxyService().getName(), this.getProxyService().getDirection(), loMonth, hiMonth);
                stat.setName(this.getProxyService().getName());
                stat.setTimeDimensionId(md.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getProxyService().getDirection());
                SummaryPersistenceManager.getInstance().addProxyServiceStatMonthlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running monthly summary generator for proxyService: " + this.getProxyService() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeQuarterly(BAMCalendar loQuarter, BAMCalendar hiQuarter) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                QuarterDimension qd = spm.getQuarterDimension((Calendar)loQuarter);
                if (qd == null) {
                    spm.addQuarterDimension(loQuarter);
                    qd = spm.getQuarterDimension((Calendar)loQuarter);
                }
                MediationSummaryStatistic stat = spm.getProxyServiceStatQuarterlySummary(this.getServer().getId(), this.getProxyService().getName(), this.getProxyService().getDirection(), loQuarter, hiQuarter);
                stat.setName(this.getProxyService().getName());
                stat.setTimeDimensionId(qd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getProxyService().getDirection());
                SummaryPersistenceManager.getInstance().addProxyServiceStatQuarterlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running quarterly summary generator for operaion: " + this.getProxyService() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeYearly(BAMCalendar loYear, BAMCalendar hiYear) {
        block3: {
            try {
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                YearDimension qd = spm.getYearDimension((Calendar)loYear);
                if (qd == null) {
                    spm.addYearDimension(loYear);
                    qd = spm.getYearDimension((Calendar)loYear);
                }
                MediationSummaryStatistic stat = spm.getProxyServiceStatYearlySummary(this.getServer().getId(), this.getProxyService().getName(), this.getProxyService().getDirection(), loYear, hiYear);
                stat.setName(this.getProxyService().getName());
                stat.setTimeDimensionId(qd.getId());
                stat.setServerId(this.getServer().getId());
                stat.setDirection(this.getProxyService().getDirection());
                SummaryPersistenceManager.getInstance().addProxyServiceStatYearlySummary(stat);
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error while running yearly summary generator for operaion: " + this.getProxyService() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestProxyServiceStatSummaryPeriod(this.getTimeInterval(), this.proxyService);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestProxyServiceStatSummaryPeriod(this.getTimeInterval(), this.proxyService);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestProxyServiceStatSummaryPeriod(this.getTimeInterval(), this.proxyService);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestDailySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestProxyServiceStatSummaryPeriod(this.getTimeInterval(), this.proxyService);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        BAMSummaryGenerationDSClient client = BAMUtil.getBAMSummaryGenerationDSClient();
        try {
            Calendar calendar = client.getLatestProxyServiceStatSummaryPeriod(this.getTimeInterval(), this.proxyService);
            return calendar;
        }
        finally {
            client.cleanup();
        }
    }

    @Override
    protected String getInstanceInfo() {
        return "Server: " + this.server.getServerURL() + ", Proxy: " + this.proxyService.getName();
    }

    public MediationDataDO getProxyService() {
        return this.proxyService;
    }

    public void setProxyService(MediationDataDO proxyService) {
        this.proxyService = proxyService;
    }

    public ServerDO getServer() {
        return this.server;
    }

    public void setServer(ServerDO server) {
        this.server = server;
    }
}

