/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary.generators;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.clients.BAMServiceSummaryDSClient;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.common.dataobjects.stats.SummaryStatistic;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.SummaryPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.AbstractSummaryGenerator;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;

public class OperationSummaryGenerator
extends AbstractSummaryGenerator {
    private static Log log = LogFactory.getLog(OperationSummaryGenerator.class);
    private ServiceDO service;
    private ServerDO server;
    private OperationDO operation;

    public OperationSummaryGenerator(ServerDO server, ServiceDO service, OperationDO operation, int timeInterval) {
        super(timeInterval);
        this.service = service;
        this.server = server;
        this.operation = operation;
    }

    @Override
    protected void summarizeHourly(BAMCalendar loHour, BAMCalendar hiHour) {
        block5: {
            try {
                TimeRange retention;
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                HourDimension hd = spm.getHourDimension((Calendar)loHour);
                if (hd == null) {
                    spm.addHourDimension(loHour);
                    hd = spm.getHourDimension((Calendar)loHour);
                }
                if ((stat = spm.getOperationStatHourlySummary(this.getOperation().getOperationID(), loHour, hiHour)) != null) {
                    stat.setTypeId(this.getOperation().getOperationID());
                    stat.setTimeDimensionId(hd.getId());
                    SummaryPersistenceManager.getInstance().addOperationStatHourlySummary(stat);
                }
                if ((retention = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).getDataRetentionPeriod()).getValue() != 0) {
                    BAMCalendar delLoHour = BAMCalendar.getInstance((Calendar)loHour);
                    BAMCalendar delHiHour = BAMCalendar.getInstance((Calendar)hiHour);
                    delHiHour.add(retention.getType(), -1 * retention.getValue());
                    delLoHour.add(retention.getType(), -1 * retention.getValue());
                    spm.deleteOperationData(this.getOperation().getOperationID(), delLoHour, delHiHour);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)("Error while running hourly summary generator for operation: " + this.getOperation().getName() + " of service: " + this.getService().getName() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeDaily(BAMCalendar loDay, BAMCalendar hiDay) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                DayDimension dd = spm.getDayDimension((Calendar)loDay);
                if (dd == null) {
                    spm.addDayDimension(loDay);
                    dd = spm.getDayDimension((Calendar)loDay);
                }
                if ((stat = spm.getOperationStatDailySummary(this.getOperation().getOperationID(), loDay, hiDay)) != null) {
                    stat.setTypeId(this.getOperation().getOperationID());
                    stat.setTimeDimensionId(dd.getId());
                    SummaryPersistenceManager.getInstance().addOperationStatDailySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running daily summary generator for operation: " + this.getOperation().getName() + " of service: " + this.getService().getName() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeMonthly(BAMCalendar loMonth, BAMCalendar hiMonth) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                MonthDimension md = spm.getMonthDimension((Calendar)loMonth);
                if (md == null) {
                    spm.addMonthDimension(loMonth);
                    md = spm.getMonthDimension((Calendar)loMonth);
                }
                if ((stat = spm.getOperationStatMonthlySummary(this.getOperation().getOperationID(), loMonth, hiMonth)) != null) {
                    stat.setTypeId(this.getOperation().getOperationID());
                    stat.setTimeDimensionId(md.getId());
                    SummaryPersistenceManager.getInstance().addOperationStatMonthlySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running monthly summary generator for operation: " + this.getOperation().getName() + " of service: " + this.getService().getName() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeQuarterly(BAMCalendar loQuarter, BAMCalendar hiQuarter) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                QuarterDimension qd = spm.getQuarterDimension((Calendar)loQuarter);
                if (qd == null) {
                    spm.addQuarterDimension(loQuarter);
                    qd = spm.getQuarterDimension((Calendar)loQuarter);
                }
                if ((stat = spm.getOperationStatQuarterlySummary(this.getOperation().getOperationID(), loQuarter, hiQuarter)) != null) {
                    stat.setTypeId(this.getOperation().getOperationID());
                    stat.setTimeDimensionId(qd.getId());
                    SummaryPersistenceManager.getInstance().addOperationStatQuarterlySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running quarterly summary generator for operation: " + this.getOperation().getName() + " of service: " + this.getService().getName() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    @Override
    protected void summarizeYearly(BAMCalendar loYear, BAMCalendar hiYear) {
        block4: {
            try {
                SummaryStatistic stat;
                SummaryPersistenceManager spm = SummaryPersistenceManager.getInstance();
                YearDimension qd = spm.getYearDimension((Calendar)loYear);
                if (qd == null) {
                    spm.addYearDimension(loYear);
                    qd = spm.getYearDimension((Calendar)loYear);
                }
                if ((stat = spm.getOperationStatYearlySummary(this.getOperation().getOperationID(), loYear, hiYear)) != null) {
                    stat.setTypeId(this.getOperation().getOperationID());
                    stat.setTimeDimensionId(qd.getId());
                    SummaryPersistenceManager.getInstance().addOperationStatYearlySummary(stat);
                }
            }
            catch (BAMException e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Error while running yearly summary generator for operation: " + this.getOperation().getName() + " of service: " + this.getService().getName() + " of server: " + this.getServer().getServerURL()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestYearlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestOperationStatSummaryPeriod(this.getTimeInterval(), this.operation.getOperationID());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestQuarterlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestOperationStatSummaryPeriod(this.getTimeInterval(), this.operation.getOperationID());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestMonthlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestOperationStatSummaryPeriod(this.getTimeInterval(), this.operation.getOperationID());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestDailySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestOperationStatSummaryPeriod(this.getTimeInterval(), this.operation.getOperationID());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Calendar getLatestHourlySummaryTime() throws BAMException {
        BAMServiceSummaryDSClient serviceSummaryDSClient = BAMUtil.getBAMServiceSummaryDSClient();
        try {
            Calendar calendar = serviceSummaryDSClient.getLatestOperationStatSummaryPeriod(this.getTimeInterval(), this.operation.getOperationID());
            return calendar;
        }
        finally {
            serviceSummaryDSClient.cleanup();
        }
    }

    @Override
    protected String getInstanceInfo() {
        return "Server: " + this.server.getServerURL() + ", Service: " + this.service.getName() + ", Operation:" + this.operation.getName();
    }

    public ServiceDO getService() {
        return this.service;
    }

    public ServerDO getServer() {
        return this.server;
    }

    public OperationDO getOperation() {
        return this.operation;
    }
}

