/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.summary;

import java.util.List;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.summary.generators.EndpointSummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.OperationSummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.ProxyServiceSummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.SequenceSummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.ServerSummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.ServiceSummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.SummaryGenerator;
import org.wso2.carbon.bam.core.summary.generators.SummaryGeneratorFactory;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMException;

public class SummaryGenerationTask
extends TimerTask {
    private static Log log = LogFactory.getLog(SummaryGenerationTask.class);
    private volatile boolean running = false;
    private boolean signalled = false;
    private BundleContext bundleContext;
    private long taskBreakDownLength;
    private long sleepTimeInBetweenTasks;
    private static final int[] summaryRanges = new int[]{11, 5, 2, 50, 1};

    public SummaryGenerationTask(BundleContext bundleContext, long taskBreakDownLength, long sleepTimeInBetweenTasks) {
        this.bundleContext = bundleContext;
        this.taskBreakDownLength = taskBreakDownLength <= 0L ? -1L : taskBreakDownLength;
        this.sleepTimeInBetweenTasks = sleepTimeInBetweenTasks <= 0L ? -1L : sleepTimeInBetweenTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Task is already running. Skipping this iteration");
            }
            return;
        }
        this.running = true;
        try {
            BAMPersistenceManager bpm = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
            log.info((Object)"Running Summary Generator...");
            List<ServerDO> serverList = bpm.getMonitoredServers(-1);
            if (serverList != null) {
                for (ServerDO svr : serverList) {
                    this.generateServerSummaries(svr);
                    this.generateServiceStatSummaries(svr, bpm);
                    this.generateMediationStatsummaries(svr, bpm);
                    this.generateSummary(svr);
                }
                log.info((Object)"Summary generation successful ...");
            } else {
                log.info((Object)"No servers to generate summary ...");
            }
        }
        catch (Throwable t) {
            log.error((Object)"Server summary generation failed.", t);
        }
        finally {
            this.running = false;
        }
    }

    private void generateSummary(ServerDO svr) {
        if (this.bundleContext == null) {
            log.error((Object)"Unable to get bundle context. Cannot run summary generators");
            return;
        }
        ServiceTracker tracker = new ServiceTracker(this.bundleContext, SummaryGeneratorFactory.class.getName(), null);
        tracker.open();
        Object[] services = tracker.getServices();
        if (services == null) {
            return;
        }
        for (Object service : services) {
            for (int range : summaryRanges) {
                SummaryGenerator sg = ((SummaryGeneratorFactory)service).getSummaryGenerator(svr, range);
                try {
                    sg.generateSummary();
                }
                catch (Exception e) {
                    log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for server:" + svr.getServerURL()), (Throwable)e);
                }
            }
        }
        tracker.close();
    }

    private void generateMediationStatsummaries(ServerDO svr, BAMPersistenceManager bpm) {
        List<MediationDataDO> medDataList;
        try {
            medDataList = bpm.getEndpoints(svr.getId());
            for (MediationDataDO ep : medDataList) {
                this.generateEndpointSummaries(svr, ep);
            }
        }
        catch (BAMException e) {
            log.error((Object)"Failed retrieving endpoint list.", (Throwable)e);
        }
        try {
            medDataList = bpm.getSequences(svr.getId());
            for (MediationDataDO seq : medDataList) {
                this.generateSequenceSummaries(svr, seq);
            }
        }
        catch (BAMException e) {
            log.error((Object)"Failed retrieving sequence list.", (Throwable)e);
        }
        try {
            medDataList = bpm.getProxyServices(svr.getId());
            for (MediationDataDO proxy : medDataList) {
                this.generateProxyServiceSummaries(svr, proxy);
            }
        }
        catch (BAMException e) {
            log.error((Object)"Failed retrieving proxy service list.", (Throwable)e);
        }
    }

    private void generateServiceStatSummaries(ServerDO svr, BAMPersistenceManager bpm) {
        List<ServiceDO> serviceList;
        try {
            serviceList = bpm.getAllServices(svr.getId());
        }
        catch (BAMException e) {
            log.error((Object)("Failed retrieving services list for server: " + svr.getServerURL()), (Throwable)e);
            return;
        }
        int i = 0;
        for (ServiceDO svc : serviceList) {
            List<OperationDO> operationList;
            this.generateServiceSummaries(svr, svc);
            try {
                operationList = bpm.getAllOperations(svc.getId());
            }
            catch (BAMException e) {
                log.error((Object)("Failed retrieving operation list for server: " + svr.getServerURL() + " service:" + svc.getName()), (Throwable)e);
                continue;
            }
            for (OperationDO op : operationList) {
                this.generateOperationSummaries(svr, svc, op);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(i + " mod " + this.taskBreakDownLength + " = " + (long)i % this.taskBreakDownLength));
            }
            if (this.taskBreakDownLength > 0L && this.sleepTimeInBetweenTasks > 0L && (long)i % this.taskBreakDownLength == 0L) {
                try {
                    log.debug((Object)("Summary exceeded task break down limit : " + this.taskBreakDownLength + ". Summary task will sleep for " + this.sleepTimeInBetweenTasks + " ms"));
                    Thread.sleep(this.sleepTimeInBetweenTasks);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private void generateOperationSummaries(ServerDO svr, ServiceDO svc, OperationDO op) {
        for (int range : summaryRanges) {
            OperationSummaryGenerator sg = new OperationSummaryGenerator(svr, svc, op, range);
            try {
                sg.generateSummary();
            }
            catch (Exception e) {
                log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for operation:" + op.getName() + " of service: " + svc.getName() + " of server: " + svr.getServerURL()), (Throwable)e);
            }
        }
    }

    private void generateServiceSummaries(ServerDO svr, ServiceDO svc) {
        for (int range : summaryRanges) {
            ServiceSummaryGenerator sg = new ServiceSummaryGenerator(svr, svc, range);
            try {
                sg.generateSummary();
            }
            catch (Exception e) {
                log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for service: " + svc.getName() + " of server: " + svr.getServerURL()), (Throwable)e);
            }
        }
    }

    private void generateServerSummaries(ServerDO svr) {
        for (int range : summaryRanges) {
            ServerSummaryGenerator sg = new ServerSummaryGenerator(svr, range);
            try {
                sg.generateSummary();
            }
            catch (Exception e) {
                log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for server: " + svr.getServerURL()), (Throwable)e);
            }
        }
    }

    private void generateEndpointSummaries(ServerDO svr, MediationDataDO endpoint) {
        for (int range : summaryRanges) {
            EndpointSummaryGenerator sg = new EndpointSummaryGenerator(svr, endpoint, range);
            try {
                sg.generateSummary();
            }
            catch (Exception e) {
                log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for endpoint:" + endpoint), (Throwable)e);
            }
        }
    }

    private void generateProxyServiceSummaries(ServerDO svr, MediationDataDO proxy) {
        for (int range : summaryRanges) {
            ProxyServiceSummaryGenerator sg = new ProxyServiceSummaryGenerator(svr, proxy, range);
            try {
                sg.generateSummary();
            }
            catch (Exception e) {
                log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for proxy: " + proxy), (Throwable)e);
            }
        }
    }

    private void generateSequenceSummaries(ServerDO svr, MediationDataDO sequence) {
        for (int range : summaryRanges) {
            SequenceSummaryGenerator sg = new SequenceSummaryGenerator(svr, sequence, range);
            try {
                sg.generateSummary();
            }
            catch (Exception e) {
                log.error((Object)(SummaryGenerationTask.getSummaryRangeName(range) + " summary generation failed for sequence:" + sequence), (Throwable)e);
            }
        }
    }

    private static String getSummaryRangeName(int range) {
        switch (range) {
            case 11: {
                return "Hourly";
            }
            case 5: {
                return "Daily";
            }
            case 2: {
                return "Monthly";
            }
            case 50: {
                return "Quarterly";
            }
            case 1: {
                return "Yearly";
            }
        }
        throw new IllegalArgumentException("Unexpected summary range value");
    }

    public boolean getRunningState() {
        return this.running;
    }

    public void setSignalledState(boolean signalled) {
        this.signalled = signalled;
    }
}

