/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.receivers;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.common.EventingServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceStatisticsDO;
import org.wso2.carbon.bam.core.admin.BAMDataServiceAdmin;
import org.wso2.carbon.bam.core.cache.CacheImpl;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.receivers.AbstractQueue;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMException;

public class ServerEventQueue
extends AbstractQueue {
    private static final Log log = LogFactory.getLog(ServerEventQueue.class);
    private CacheImpl cacheImpl;
    public static final String STATISTICS_DATA_NS_URI = "http://wso2.org/ns/2009/09/bam/service/statistics/data";
    public static final String STATISTICS_DATA_ELEMENT_NAME_EVENT = "Event";
    public static final String STATISTICS_DATA_ELEMENT_NAME_SERVICE_STATISTICS_DATA = "ServiceStatisticsData";
    public static final String STATISTICS_DATA_ELEMENT_NAME_TENANT_ID = "TenantID";
    public static final String STATISTICS_DATA_ELEMENT_NAME_SERVER_NAME = "ServerName";
    public static final String STATISTICS_DATA_ELEMENT_NAME_AVG_RESPONSE_TIME = "AverageResponseTime";
    public static final String STATISTICS_DATA_ELEMENT_NAME_MIN_RESPONSE_TIME = "MinimumResponseTime";
    public static final String STATISTICS_DATA_ELEMENT_NAME_MAX_RESPONSE_TIME = "MaximumResponseTime";
    public static final String STATISTICS_DATA_ELEMENT_NAME_REQUEST_COUNT = "RequestCount";
    public static final String STATISTICS_DATA_ELEMENT_NAME_RESPONSE_COUNT = "ResponseCount";
    public static final String STATISTICS_DATA_ELEMENT_NAME_FAULT_COUNT = "FaultCount";
    public static final String STATISTICS_DATA_ELEMENT_NAME_SERVICE_NAME = "ServiceName";
    public static final String STATISTICS_DATA_ELEMENT_NAME_OPERATION_NAME = "OperationName";
    public static final String STATISTICS_DATA_ELEMENT_NAME_TIMESTAMP = "Timestamp";

    public ServerEventQueue(int threadPoolSize) {
        super(threadPoolSize);
    }

    @Override
    protected void processEvents(MessageContext[] messageContexts) {
        this.cacheImpl = new CacheImpl();
        for (int i = 0; i < messageContexts.length; ++i) {
            List<EventData> eventData;
            BAMDataServiceAdmin dsAdmin = new BAMDataServiceAdmin();
            try {
                eventData = this.getEventDataArray((OMElement)messageContexts[i].getEnvelope().getBody());
            }
            catch (BAMException e) {
                log.error((Object)("BAM Statistics MessageReceiver invokeBusinessLogic " + e.getLocalizedMessage() + "\n" + "BAM MR invokeBusinessLogic SOAP Envelope causing the problem" + messageContexts[i].getEnvelope().toString()), (Throwable)e);
                return;
            }
            for (EventData data : eventData) {
                this.storeData(data, dsAdmin);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("BAM MR invokeBusinessLogic SOAP Envelope " + messageContexts[i].getEnvelope().toString()));
        }
    }

    private List<EventData> getEventDataArray(OMElement rootElement) throws BAMException {
        OMElement eventElement = rootElement.getFirstChildWithName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_EVENT));
        if (eventElement == null) {
            throw new BAMException("Event element not found in the message");
        }
        QName serviceStatisticsDataQName = new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_SERVICE_STATISTICS_DATA);
        Iterator serviceStatisticsDataIterator = eventElement.getChildrenWithName(serviceStatisticsDataQName);
        ArrayList<EventData> eventDataList = new ArrayList<EventData>();
        while (serviceStatisticsDataIterator.hasNext()) {
            String serverName;
            EventData eventData = new EventData();
            OMElement serviceStatisticsDataElement = (OMElement)serviceStatisticsDataIterator.next();
            if (serviceStatisticsDataElement == null) {
                throw new BAMException("ServiceStatisticsData element not found in the message");
            }
            int tenantID = this.getIntDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_TENANT_ID), serviceStatisticsDataElement);
            if (tenantID == -1) {
                tenantID = -1234;
            }
            if ((serverName = this.getStringDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_SERVER_NAME), serviceStatisticsDataElement)) == null) {
                throw new BAMException("ServerName element not found in the message");
            }
            double avgResTime = this.getDoubleDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_AVG_RESPONSE_TIME), serviceStatisticsDataElement);
            long minResTime = this.getLongDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_MIN_RESPONSE_TIME), serviceStatisticsDataElement);
            long maxResTime = this.getLongDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_MAX_RESPONSE_TIME), serviceStatisticsDataElement);
            int requestCount = this.getIntDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_REQUEST_COUNT), serviceStatisticsDataElement);
            int responseCount = this.getIntDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_RESPONSE_COUNT), serviceStatisticsDataElement);
            int faultCount = this.getIntDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_FAULT_COUNT), serviceStatisticsDataElement);
            String serviceName = this.getStringDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_SERVICE_NAME), serviceStatisticsDataElement);
            String operationName = this.getStringDataValueWithQName(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_OPERATION_NAME), serviceStatisticsDataElement);
            Timestamp timestamp = this.getTimestampValueWithQname(new QName(STATISTICS_DATA_NS_URI, STATISTICS_DATA_ELEMENT_NAME_TIMESTAMP), serviceStatisticsDataElement);
            eventData.setTenantID(tenantID);
            eventData.setServerName(serverName);
            eventData.setAvgResTime(avgResTime);
            eventData.setMinResTime(minResTime);
            eventData.setMaxResTime(maxResTime);
            eventData.setRequestCount(requestCount);
            eventData.setResponseCount(responseCount);
            eventData.setFaultCount(faultCount);
            eventData.setServiceName(serviceName);
            eventData.setOperationName(operationName);
            eventData.setTimestamp(timestamp);
            eventDataList.add(eventData);
        }
        return eventDataList;
    }

    private void storeData(EventData data, BAMDataServiceAdmin dsAdmin) {
        if (data.operationName != null) {
            this.storeOperationData(data, dsAdmin);
        } else if (data.serviceName != null) {
            this.storeServiceData(data, dsAdmin);
        } else {
            this.storeServerData(data, dsAdmin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOperationData(EventData data, BAMDataServiceAdmin dsAdmin) {
        if (data.operationName != null && !"".equals(data.operationName)) {
            Calendar calendar = Calendar.getInstance();
            if (data.getTimestamp() != null) {
                calendar.setTimeInMillis(data.getTimestamp().getTime());
            }
            OperationStatisticsDO operationStatisticsDO = new OperationStatisticsDO(data.serverName, calendar, data.avgResTime, (double)data.maxResTime, (double)data.minResTime, data.requestCount, data.responseCount, data.faultCount, data.serviceName, data.operationName);
            try {
                OperationDO operation;
                ServerDO monitoringServer = this.cacheImpl.getServer(dsAdmin, data.serverName, data.tenantID, "EventingServer", 1);
                if (monitoringServer == null) {
                    ServerEventQueue serverEventQueue = this;
                    synchronized (serverEventQueue) {
                        if (monitoringServer == null && data.serverName != null) {
                            EventingServerDO server = new EventingServerDO();
                            server.setTenantID(data.tenantID);
                            server.setServerURL(data.serverName);
                            server.setServerType("EventingServer");
                            server.setCategory(1);
                            BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addMonitoredServer((ServerDO)server);
                        }
                        monitoringServer = this.cacheImpl.getServer(dsAdmin, data.serverName, data.tenantID, "EventingServer", 1);
                    }
                }
                operationStatisticsDO.setServerID(monitoringServer.getId());
                ServiceDO service = this.cacheImpl.getService(dsAdmin, data.serverName, data.tenantID, operationStatisticsDO.getServerID(), data.serviceName);
                if (service != null) {
                    operationStatisticsDO.setServiceID(service.getId());
                }
                if ((operation = this.cacheImpl.getOperation(dsAdmin, data.serverName, data.tenantID, operationStatisticsDO.getServiceID(), data.operationName)) != null) {
                    operationStatisticsDO.setOperationID(operation.getOperationID());
                }
                dsAdmin.addOperationStatistics(operationStatisticsDO);
            }
            catch (Exception e) {
                log.error((Object)("Error updating operation statistics data for server " + data.serverName + " service " + data.serviceName + " operation " + data.operationName + " from eventing message receiver \n" + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeServiceData(EventData data, BAMDataServiceAdmin dsAdmin) {
        Calendar calendar = Calendar.getInstance();
        if (data.getTimestamp() != null) {
            calendar.setTimeInMillis(data.getTimestamp().getTime());
        }
        ServiceStatisticsDO serviceStatisticsDO = new ServiceStatisticsDO(data.serverName, calendar, data.avgResTime, (double)data.maxResTime, (double)data.minResTime, data.requestCount, data.responseCount, data.faultCount, data.serviceName);
        try {
            ServerDO monitoringServer = this.cacheImpl.getServer(dsAdmin, data.serverName, data.tenantID, "EventingServer", 1);
            if (monitoringServer == null) {
                ServerEventQueue serverEventQueue = this;
                synchronized (serverEventQueue) {
                    if (monitoringServer == null && data.serverName != null) {
                        ServerDO server = new ServerDO();
                        server.setTenantID(data.tenantID);
                        server.setServerURL(data.serverName);
                        server.setServerType("EventingServer");
                        server.setCategory(1);
                        BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addMonitoredServer(server);
                    }
                    monitoringServer = this.cacheImpl.getServer(dsAdmin, data.serverName, data.tenantID, "EventingServer", 1);
                }
            }
            serviceStatisticsDO.setServerID(monitoringServer.getId());
            ServiceDO service = this.cacheImpl.getService(dsAdmin, data.serverName, data.tenantID, serviceStatisticsDO.getServerID(), data.serviceName);
            if (service != null) {
                serviceStatisticsDO.setServiceID(service.getId());
            }
            dsAdmin.addServiceStatistics(serviceStatisticsDO);
        }
        catch (Exception e) {
            log.error((Object)("Error updating service statistics data for server " + data.serverName + " service " + data.serviceName + " from eventing message receiver " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeServerData(EventData data, BAMDataServiceAdmin dsAdmin) {
        Calendar calendar = Calendar.getInstance();
        if (data.getTimestamp() != null) {
            calendar.setTimeInMillis(data.getTimestamp().getTime());
        }
        ServerStatisticsDO serverStatisticsDO = new ServerStatisticsDO(data.serverName, calendar, data.avgResTime, (double)data.maxResTime, (double)data.minResTime, data.requestCount, data.responseCount, data.faultCount);
        try {
            ServerDO monitoringServer = this.cacheImpl.getServer(dsAdmin, data.serverName, data.tenantID, "EventingServer", 1);
            if (monitoringServer == null) {
                ServerEventQueue serverEventQueue = this;
                synchronized (serverEventQueue) {
                    if (monitoringServer == null && data.serverName != null) {
                        ServerDO server = new ServerDO();
                        server.setTenantID(data.tenantID);
                        server.setServerURL(data.serverName);
                        server.setServerType("EventingServer");
                        server.setCategory(1);
                        BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addMonitoredServer(server);
                    }
                    monitoringServer = dsAdmin.getServer(data.serverName, data.tenantID, "EventingServer", 1);
                }
            }
            int id = monitoringServer.getId();
            serverStatisticsDO.setServerID(id);
            dsAdmin.addServerData(serverStatisticsDO);
        }
        catch (Exception e) {
            log.error((Object)("Error updating system level service statistics data for server " + data.serverName + " from eventing message receiver " + e.getMessage()), (Throwable)e);
        }
    }

    private int getIntDataValueWithQName(QName qName, OMElement serviceStatisticsDataElement) {
        OMElement element = serviceStatisticsDataElement.getFirstChildWithName(qName);
        int value = -1;
        if (element != null) {
            try {
                value = Integer.parseInt(element.getText().trim());
            }
            catch (Exception ignore) {
                log.info((Object)("Data not in required format (Integer) for data field: " + qName.getLocalPart()), (Throwable)ignore);
            }
        }
        return value;
    }

    private long getLongDataValueWithQName(QName qName, OMElement serviceStatisticsDataElement) {
        OMElement element = serviceStatisticsDataElement.getFirstChildWithName(qName);
        long value = -1L;
        if (element != null) {
            try {
                value = Long.parseLong(element.getText().trim());
            }
            catch (Exception ignore) {
                log.info((Object)("Data not in required format (Long) for data field: " + qName.getLocalPart()), (Throwable)ignore);
            }
        }
        return value;
    }

    private Double getDoubleDataValueWithQName(QName qName, OMElement serviceStatisticsDataElement) {
        OMElement element = serviceStatisticsDataElement.getFirstChildWithName(qName);
        double value = -1.0;
        if (element != null) {
            try {
                value = Double.parseDouble(element.getText().trim());
            }
            catch (Exception ignore) {
                log.info((Object)("Data not in required format (Double) for data field: " + qName.getLocalPart()), (Throwable)ignore);
            }
        }
        return value;
    }

    private String getStringDataValueWithQName(QName qName, OMElement serviceStatisticsDataElement) {
        OMElement element = serviceStatisticsDataElement.getFirstChildWithName(qName);
        String value = null;
        if (element != null) {
            value = element.getText().trim();
        }
        return value;
    }

    private Timestamp getTimestampValueWithQname(QName qName, OMElement serviceStatisticsDataElement) {
        OMElement element = serviceStatisticsDataElement.getFirstChildWithName(qName);
        Timestamp timestamp = null;
        if (element != null) {
            timestamp = Timestamp.valueOf(element.getText());
        }
        return timestamp;
    }

    class EventData {
        String serverName;
        int tenantID;
        long minResTime;
        double avgResTime;
        long maxResTime;
        int requestCount;
        int responseCount;
        int faultCount;
        String serviceName;
        String operationName;
        Timestamp timestamp;

        EventData() {
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public int getFaultCount() {
            return this.faultCount;
        }

        public void setFaultCount(int faultCount) {
            this.faultCount = faultCount;
        }

        public int getResponseCount() {
            return this.responseCount;
        }

        public void setResponseCount(int responseCount) {
            this.responseCount = responseCount;
        }

        public int getRequestCount() {
            return this.requestCount;
        }

        public void setRequestCount(int requestCount) {
            this.requestCount = requestCount;
        }

        public long getMaxResTime() {
            return this.maxResTime;
        }

        public void setMaxResTime(long maxResTime) {
            this.maxResTime = maxResTime;
        }

        public double getAvgResTime() {
            return this.avgResTime;
        }

        public void setAvgResTime(double avgResTime) {
            this.avgResTime = avgResTime;
        }

        public long getMinResTime() {
            return this.minResTime;
        }

        public void setMinResTime(long minResTime) {
            this.minResTime = minResTime;
        }

        public int getTenantID() {
            return this.tenantID;
        }

        public void setTenantID(int tenantID) {
            this.tenantID = tenantID;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }
    }
}

