/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.receivers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.wso2.carbon.bam.common.dataobjects.activity.ActivityDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDataDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessagePropertyDO;
import org.wso2.carbon.bam.common.dataobjects.activity.PropertyFilterDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.core.admin.BAMDataServiceAdmin;
import org.wso2.carbon.bam.core.internal.BAMServiceComponent;
import org.wso2.carbon.bam.core.util.SimpleLRUCache;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public class ActivityMessageReceiver
extends AbstractMessageReceiver {
    private String messageFaultReason = "";
    private Map<String, ServerDO> serverMap = new ConcurrentHashMap<String, ServerDO>();
    private Map<String, ServiceDO> serviceMap = new ConcurrentHashMap<String, ServiceDO>();
    private Map<String, OperationDO> operationMap = new ConcurrentHashMap<String, OperationDO>();
    private Map<String, ActivityDO> activityMap = new SimpleLRUCache<String, ActivityDO>(100);

    protected void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
        BAMServiceComponent.getActivityEventQueue().enqueue(messageContext);
    }

    private void storeXPathData(PropertyFilterData data, BAMDataServiceAdmin dsAdmin) {
        block12: {
            try {
                ServerDO serverDO = dsAdmin.getServer(data.getServerName());
                if (serverDO != null && data != null) {
                    PropertyFilterDO propertyFilterDO = dsAdmin.getXpathConfiguration(data.getExpressionKey(), serverDO.getId());
                    if (propertyFilterDO != null) {
                        if (this.isEqualConfigurations(propertyFilterDO, data)) break block12;
                        try {
                            dsAdmin.updateXpathConfiguration(data.getAlias(), data.getExpressionKey(), data.getExpression(), serverDO.getId(), propertyFilterDO.getId());
                        }
                        catch (BAMException e) {
                            log.error((Object)"Could not update xpath configuration in database..");
                            return;
                        }
                        try {
                            dsAdmin.deleteNamespaceData(propertyFilterDO.getId());
                        }
                        catch (BAMException e) {
                            log.error((Object)"Failed to delete existing namespace data in database. New namespace changes won't be written..", (Throwable)e);
                            return;
                        }
                        this.storeNamespaceData(data, propertyFilterDO, dsAdmin);
                        break block12;
                    }
                    try {
                        dsAdmin.addXpathConfiguration(data.getAlias(), data.getExpressionKey(), data.getExpression(), serverDO.getId());
                    }
                    catch (BAMException e) {
                        log.error((Object)"Could not add xpath configuration to the database..");
                        return;
                    }
                    propertyFilterDO = dsAdmin.getXpathConfiguration(data.getExpressionKey(), serverDO.getId());
                    if (propertyFilterDO != null) {
                        this.storeNamespaceData(data, propertyFilterDO, dsAdmin);
                    } else {
                        log.error((Object)"Error adding xpath configuration to database..");
                    }
                    break block12;
                }
                log.error((Object)("Server is not in the Database " + data.getServerName()));
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve server from DB ", (Throwable)e);
            }
        }
    }

    private void storeNamespaceData(PropertyFilterData data, PropertyFilterDO propertyFilterDO, BAMDataServiceAdmin dsAdmin) {
        for (String ns : data.getNamespaces()) {
            String[] tokens = ns.split("@");
            if (tokens == null || tokens.length != 2) continue;
            String prefix = tokens[0];
            String uri = tokens[1];
            try {
                dsAdmin.addNamespaceData(propertyFilterDO.getId(), prefix, uri);
            }
            catch (BAMException e) {
                log.error((Object)("Error adding xpath namespace " + ns + "to the database"), (Throwable)e);
            }
        }
    }

    private boolean isEqualConfigurations(PropertyFilterDO filterDO, PropertyFilterData filterData) {
        if (filterDO.getExpression() != null && filterData.getExpression() != null && filterDO.getExpressionKey() != null && filterData.getExpressionKey() != null && filterDO.getExpressionKey().trim().equals(filterData.getExpressionKey().trim()) && filterDO.getExpression().trim().equals(filterData.getExpression().trim())) {
            if (filterDO.getAlias() != null && filterData.getAlias() != null ? !filterDO.getAlias().trim().equals(filterData.getAlias().trim()) : filterDO.getAlias() != null || filterData.getAlias() != null) {
                return false;
            }
            if (filterDO.getNamespaces() != null && filterData.getNamespaces() != null) {
                for (String ns : filterDO.getNamespaces()) {
                    boolean nsFound = false;
                    for (String innerNs : filterData.getNamespaces()) {
                        if (!ns.trim().equals(innerNs.trim())) continue;
                        nsFound = true;
                    }
                    if (nsFound) continue;
                    return false;
                }
                return true;
            }
            if (filterDO.getNamespaces() != null || filterData.getNamespaces() != null) {
                if (filterDO.getNamespaces() != null && filterDO.getNamespaces().length == 0 && (filterData.getNamespaces() == null || filterData.getNamespaces().length == 0)) {
                    return true;
                }
                return filterData.getNamespaces() != null && filterData.getNamespaces().length == 0 && (filterDO.getNamespaces() == null || filterData.getNamespaces().length == 0);
            }
            return true;
        }
        return false;
    }

    private void storeMessage(ActivityData data, BAMDataServiceAdmin dsAdmin) {
        if (data.getServiceName() != null && data.getOperationName() != null && data.getActivityId() != null) {
            if (!(data.getOperationName().equals("") || data.getServiceName().equals("") || data.getActivityId().equals(""))) {
                MessageDO messageDO = data.getTimeStamp() != null ? (data.getTimeStamp().equals("") ? new MessageDO(data.getMessageId(), BAMCalendar.getInstance((Calendar)Calendar.getInstance()).getBAMTimestamp(), data.getRemoteIPAddress(), data.getUserAgent()) : new MessageDO(data.getMessageId(), data.getTimeStamp(), data.getRemoteIPAddress(), data.getUserAgent())) : new MessageDO(data.getMessageId(), BAMCalendar.getInstance((Calendar)Calendar.getInstance()).getBAMTimestamp(), data.getRemoteIPAddress(), data.getUserAgent());
                ServerDO serverDO = null;
                try {
                    if (this.serverMap.containsKey(data.getServerName())) {
                        serverDO = this.serverMap.get(data.getServerName());
                    } else {
                        serverDO = dsAdmin.getServer(data.getServerName());
                        if (serverDO == null) {
                            log.error((Object)("Server is not in the Database " + data.getServerName()));
                            return;
                        }
                        this.serverMap.put(data.getServerName(), serverDO);
                    }
                    messageDO.setServerId(serverDO.getId());
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve server from DB ", (Throwable)e);
                }
                ServiceDO serviceDO = null;
                try {
                    String key = messageDO.getServerId() + "-" + data.getServiceName();
                    if (this.serviceMap.containsKey(key)) {
                        serviceDO = this.serviceMap.get(key);
                    } else {
                        serviceDO = dsAdmin.getService(messageDO.getServerId(), data.getServiceName());
                        if (serviceDO == null) {
                            serviceDO = new ServiceDO();
                            serviceDO.setServerID(serverDO.getId());
                            serviceDO.setName(data.getServiceName());
                            dsAdmin.addService(serviceDO);
                            serviceDO = dsAdmin.getService(messageDO.getServerId(), data.getServiceName());
                        }
                        this.serviceMap.put(key, serviceDO);
                    }
                    messageDO.setServiceId(serviceDO.getId());
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve service from DB ", (Throwable)e);
                }
                try {
                    OperationDO operationDO;
                    String key = messageDO.getServiceId() + "-" + data.getOperationName();
                    if (this.operationMap.containsKey(key)) {
                        operationDO = this.operationMap.get(key);
                    } else {
                        operationDO = dsAdmin.getOperation(messageDO.getServiceId(), data.getOperationName());
                        if (operationDO == null) {
                            operationDO = new OperationDO();
                            operationDO.setServiceID(serviceDO.getId());
                            operationDO.setName(data.getOperationName());
                            dsAdmin.addOperation(operationDO);
                            operationDO = dsAdmin.getOperation(messageDO.getServiceId(), data.getOperationName());
                        }
                        this.operationMap.put(key, operationDO);
                    }
                    messageDO.setOperationId(operationDO.getOperationID());
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve operation from DB ", (Throwable)e);
                }
                try {
                    ActivityDO activity = null;
                    if (this.activityMap.containsKey(data.getActivityId())) {
                        activity = this.activityMap.get(data.getActivityId());
                    } else {
                        activity = dsAdmin.getActivityForActivityID(data.getActivityId());
                        if (activity == null) {
                            activity = new ActivityDO();
                            activity.setActivityId(data.getActivityId());
                            activity.setName(data.getActivityName());
                            activity.setDescription(data.getActivityDescription());
                            dsAdmin.addActivity(activity);
                            activity = dsAdmin.getActivityForActivityID(data.getActivityId());
                        }
                        this.activityMap.put(data.getActivityId(), activity);
                    }
                    messageDO.setActivityKeyId(activity.getActivityKeyId());
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve activity from DB ", (Throwable)e);
                }
                try {
                    MessageDO msg = dsAdmin.getMessage(data.getMessageId(), messageDO.getOperationId(), messageDO.getActivityKeyId());
                    if (msg != null) {
                        messageDO.setMessageKeyId(msg.getMessageKeyId());
                    } else {
                        dsAdmin.addMessageData(messageDO);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Message is saved");
                        }
                    }
                }
                catch (BAMException e) {
                    log.error((Object)("Error updating Message statistics data for server " + data.getServerName() + " service " + data.getServiceName() + " operation " + data.getOperationName() + " from eventing message receiver " + e.getLocalizedMessage()));
                }
            } else {
                this.messageFaultReason = "Required element is empty ;\n Service :" + data.getServiceName() + "\n Operation:" + data.getOperationName() + "\n ActivityID:" + data.getActivityId();
            }
        } else {
            this.messageFaultReason = "Required element is null ;\n Service :" + data.getServiceName() + "\n Operation:" + data.getOperationName() + "\n ActivityID:" + data.getActivityId();
        }
    }

    private void storeActivity(ActivityData data, BAMDataServiceAdmin dsAdmin) {
        if (data.getActivityId() != null && !data.getActivityId().equals("")) {
            ActivityDO activityDO = new ActivityDO(data.getActivityId(), data.getActivityName(), data.getActivityDescription());
            try {
                ActivityDO act = dsAdmin.getActivityForActivityID(data.getActivityId());
                if (act == null) {
                    try {
                        dsAdmin.addActivityData(activityDO);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Activity is saved");
                        }
                        act = dsAdmin.getActivityForActivityID(data.getActivityId());
                    }
                    catch (Exception ignore) {
                        log.error((Object)"Recovered successfully from race condition - trying to add the same activity from two events.");
                    }
                }
                activityDO.setActivityKeyId(act.getActivityKeyId());
            }
            catch (Exception e) {
                log.error((Object)"Couldn't add activity  : ", (Throwable)e);
            }
        }
    }

    private ActivityData processActivityElement(OMElement activityElement) {
        HashMap<PropertyFilterData, String> xpathEvaluations = new HashMap<PropertyFilterData, String>();
        HashMap<String, String> activityProperties = new HashMap<String, String>();
        ActivityData data = new ActivityData();
        if (activityElement != null) {
            OMElement properties;
            String serverName = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ServerName"), activityElement);
            String messageId = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "MessageID"), activityElement);
            String activityId = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ActivityID"), activityElement);
            String activityName = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ActivityName"), activityElement);
            String activityDescription = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ActivityDescription"), activityElement);
            String remoteIPAddress = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "RemoteIPAddress"), activityElement);
            String userAgent = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "UserAgent"), activityElement);
            String serviceName = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ServiceName"), activityElement);
            String operationName = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "OperationName"), activityElement);
            String messageDirection = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "MessageDirection"), activityElement);
            String messageBody = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "MessageBody"), activityElement);
            String timeStamp = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "TimeStamp"), activityElement);
            OMElement xpathExpressions = activityElement.getFirstChildWithName(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "XPathExpressions"));
            if (xpathExpressions != null) {
                Iterator xpathExpressionItr = xpathExpressions.getChildrenWithName(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "XPathExpression"));
                while (xpathExpressionItr.hasNext()) {
                    OMElement xpathExpression = (OMElement)xpathExpressionItr.next();
                    String expressionKey = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ExpressionKey"), xpathExpression);
                    String xpath = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "Expression"), xpathExpression);
                    String alias = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "Alias"), xpathExpression);
                    OMElement namespaces = activityElement.getFirstChildWithName(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "Namespaces"));
                    ArrayList<String> nsList = new ArrayList<String>();
                    if (namespaces != null) {
                        Iterator namespaceItr = xpathExpressions.getChildrenWithName(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "Namespace"));
                        while (namespaceItr.hasNext()) {
                            OMElement namespace = (OMElement)namespaceItr.next();
                            String ns = namespace.getText();
                            nsList.add(ns);
                        }
                    }
                    PropertyFilterData propertyFilterData = new PropertyFilterData();
                    propertyFilterData.setServerName(serverName);
                    propertyFilterData.setExpressionKey(expressionKey);
                    propertyFilterData.setExpression(xpath);
                    propertyFilterData.setAlias(alias);
                    propertyFilterData.setNamespaces(nsList.toArray(new String[nsList.size()]));
                    String xpathValue = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "XPathValue"), xpathExpression);
                    xpathEvaluations.put(propertyFilterData, xpathValue);
                }
            }
            if ((properties = activityElement.getFirstChildWithName(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ActivityProperties"))) != null) {
                Iterator propertiesItr = properties.getChildrenWithName(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ActivityProperty"));
                while (propertiesItr.hasNext()) {
                    OMElement property = (OMElement)propertiesItr.next();
                    String propertyChild = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ActivityPropertyChild"), property);
                    String propertyChildValue = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "PropertyValue"), property);
                    activityProperties.put(propertyChild, propertyChildValue);
                }
            }
            String outMessageID = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "OutMessageID"), activityElement);
            String requestMessageStatus = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "RequestMessageStatus"), activityElement);
            String responseMessageStatus = this.getDataWithQNameFromElement(new QName("http://wso2.org/ns/2009/09/bam/service/activity/data", "ResponseMessageStatus"), activityElement);
            if (requestMessageStatus != null) {
                if (requestMessageStatus.equals("0")) {
                    requestMessageStatus = "SUCCESS MESSAGE";
                }
                if (requestMessageStatus.equals("1")) {
                    requestMessageStatus = "FAULTY MESSAGE";
                }
                if (requestMessageStatus.equals("-1")) {
                    requestMessageStatus = "UNDEFINED STATUS";
                }
            }
            if (responseMessageStatus != null) {
                if (responseMessageStatus.equals("0")) {
                    responseMessageStatus = "SUCCESS MESSAGE";
                }
                if (responseMessageStatus.equals("1")) {
                    responseMessageStatus = "FAULTY MESSAGE";
                }
                if (responseMessageStatus.equals("-1")) {
                    responseMessageStatus = "UNDEFINED STATUS";
                }
            }
            data.setServerName(serverName);
            data.setServiceName(serviceName);
            data.setOperationName(operationName);
            data.setMessageId(messageId);
            data.setActivityId(activityId);
            data.setActivityName(activityName);
            data.setActivityDescription(activityDescription);
            data.setUserAgent(userAgent);
            data.setRemoteIPAddress(remoteIPAddress);
            data.setTimeStamp(timeStamp);
            data.setMessageDirection(messageDirection);
            data.setMessageBody(messageBody);
            data.setXPathEvaluations(xpathEvaluations);
            data.setRequestMessageStatus(requestMessageStatus);
            data.setResponseMessageStatus(responseMessageStatus);
            data.setOutMessageID(outMessageID);
            data.setProperties(activityProperties);
        }
        return data;
    }

    private String getDataWithQNameFromElement(QName qName, OMElement element) {
        OMElement dataElement = element.getFirstChildWithName(qName);
        String value = null;
        if (dataElement != null) {
            value = dataElement.getText();
        }
        return value;
    }

    private void storeMessageData(ActivityData data, BAMDataServiceAdmin dsAdmin) {
        if (data.getServiceName() != null && data.getOperationName() != null && data.getActivityId() != null) {
            if (!(data.getOperationName().equals("") || data.getServiceName().equals("") || data.getActivityId().equals(""))) {
                int serverId;
                ServerDO serverDO;
                MessageDataDO messageDataDO = data.getTimeStamp() != null ? new MessageDataDO(data.getTimeStamp(), data.getRemoteIPAddress(), data.getMessageDirection(), data.getMessageBody(), data.getRequestMessageStatus(), data.getResponseMessageStatus()) : new MessageDataDO(BAMCalendar.getInstance((Calendar)Calendar.getInstance()).getBAMTimestamp(), data.getRemoteIPAddress(), data.getMessageDirection(), data.getMessageBody(), data.getRequestMessageStatus(), data.getResponseMessageStatus());
                try {
                    serverDO = dsAdmin.getServer(data.getServerName());
                    if (serverDO != null) {
                        serverId = serverDO.getId();
                        messageDataDO.setServerId(serverId);
                    } else {
                        log.error((Object)("Server is not in the Database" + data.getServerName()));
                    }
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve server from DB ", (Throwable)e);
                }
                try {
                    if (dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()) == null) {
                        ServiceDO service = new ServiceDO();
                        serverDO = dsAdmin.getServer(data.getServerName());
                        if (serverDO != null) {
                            serverId = serverDO.getId();
                            service.setServerID(serverId);
                            service.setName(data.getServiceName());
                            dsAdmin.addService(service);
                            messageDataDO.setServiceId(dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()).getId());
                        }
                    } else {
                        messageDataDO.setServiceId(dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()).getId());
                    }
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve service from DB ", (Throwable)e);
                }
                try {
                    if (dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()) == null) {
                        OperationDO operation = new OperationDO();
                        ServiceDO serviceDO = dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName());
                        if (serviceDO != null) {
                            operation.setServiceID(serviceDO.getId());
                            operation.setName(data.getOperationName());
                            dsAdmin.addOperation(operation);
                            messageDataDO.setOperationId(dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()).getOperationID());
                        } else {
                            serviceDO = new ServiceDO();
                            serviceDO.setServerID(messageDataDO.getServerId());
                            serviceDO.setName(data.getServiceName());
                            dsAdmin.addService(serviceDO);
                            messageDataDO.setServiceId(dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()).getId());
                            operation.setServiceID(messageDataDO.getServiceId());
                            operation.setName(data.getOperationName());
                            dsAdmin.addOperation(operation);
                            messageDataDO.setOperationId(dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()).getOperationID());
                        }
                    } else {
                        messageDataDO.setOperationId(dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()).getOperationID());
                    }
                }
                catch (BAMException e) {
                    log.error((Object)"Could not retrieve operation from DB ", (Throwable)e);
                }
                this.checkForActivityExistense(data, dsAdmin, messageDataDO);
                try {
                    MessageDO msg = dsAdmin.getMessage(data.getMessageId(), messageDataDO.getOperationId(), messageDataDO.getActivityKeyId());
                    if (msg != null) {
                        messageDataDO.setMessageKeyId(msg.getMessageKeyId());
                    } else {
                        MessageDO mesg = new MessageDO();
                        mesg.setMessageId(data.getMessageId());
                        mesg.setActivityKeyId(messageDataDO.getActivityKeyId());
                        mesg.setOperationId(messageDataDO.getOperationId());
                        mesg.setTimestamp(data.getTimeStamp());
                        mesg.setIPAddress(data.getRemoteIPAddress());
                        mesg.setUserAgent(data.getUserAgent());
                        dsAdmin.addMessage(mesg);
                        messageDataDO.setMessageKeyId(dsAdmin.getMessage(data.getMessageId(), messageDataDO.getOperationId(), messageDataDO.getActivityKeyId()).getMessageKeyId());
                    }
                }
                catch (BAMException e) {
                    log.error((Object)("Error updating Message statistics data for server " + data.getServerName() + " service " + data.getServiceName() + " operation " + data.getOperationName() + " from eventing message receiver " + e.getLocalizedMessage()));
                }
                try {
                    MessageDataDO msgDat = dsAdmin.getMessageDataForActivityKeyIDandMessageKeyID(messageDataDO.getMessageKeyId(), messageDataDO.getActivityKeyId());
                    if (msgDat != null) {
                        messageDataDO.setMessageDataKeyId(msgDat.getMessageDataKeyId());
                    } else {
                        if (data.getMessageDirection() != null) {
                            dsAdmin.addMessageDataDump(messageDataDO, data.getMessageDirection());
                            messageDataDO.setMessageDataKeyId(dsAdmin.getMessageDataForActivityKeyIDandMessageKeyID(messageDataDO.getMessageKeyId(), messageDataDO.getActivityKeyId()).getMessageDataKeyId());
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Message Data is saved");
                        }
                    }
                }
                catch (BAMException e) {
                    log.error((Object)"Could not dump the full message to DB", (Throwable)e);
                }
            } else {
                this.messageFaultReason = "Required element is empty ;\n Service :" + data.getServiceName() + "\n Operation :" + data.getOperationName() + "\n ActivityID :" + data.getActivityId();
            }
        } else {
            this.messageFaultReason = "Required element is null ; \n Service :" + data.getServiceName() + "\n Operation :" + data.getOperationName() + "\n ActivityID :" + data.getActivityId();
        }
    }

    private void storeMessageStatusData(ActivityData data, BAMDataServiceAdmin dsAdmin) {
        block35: {
            if (data.getServiceName() != null && data.getOperationName() != null && data.getActivityId() != null) {
                if (!(data.getOperationName().equals("") || data.getServiceName().equals("") || data.getActivityId().equals(""))) {
                    String direction;
                    ServerDO serverDO;
                    MessageDataDO messageDataDO = data.getTimeStamp() != null ? (data.getTimeStamp().equals("") ? new MessageDataDO(BAMCalendar.getInstance((Calendar)Calendar.getInstance()).getBAMTimestamp(), data.getRemoteIPAddress(), data.getMessageDirection(), data.getMessageBody(), data.getRequestMessageStatus(), data.getResponseMessageStatus()) : new MessageDataDO(data.getTimeStamp(), data.getRemoteIPAddress(), data.getMessageDirection(), data.getMessageBody(), data.getRequestMessageStatus(), data.getResponseMessageStatus())) : new MessageDataDO(BAMCalendar.getInstance((Calendar)Calendar.getInstance()).getBAMTimestamp(), data.getRemoteIPAddress(), data.getMessageDirection(), data.getMessageBody(), data.getRequestMessageStatus(), data.getResponseMessageStatus());
                    try {
                        serverDO = dsAdmin.getServer(data.getServerName());
                        if (serverDO != null) {
                            messageDataDO.setServerId(serverDO.getId());
                        } else {
                            log.error((Object)("Server is not in the Database" + data.getServerName()));
                        }
                    }
                    catch (BAMException e) {
                        log.error((Object)"Could not retrieve server from DB ", (Throwable)e);
                    }
                    try {
                        if (dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()) == null) {
                            ServiceDO service = new ServiceDO();
                            serverDO = dsAdmin.getServer(data.getServerName());
                            if (serverDO != null) {
                                service.setServerID(serverDO.getId());
                                service.setName(data.getServiceName());
                                dsAdmin.addService(service);
                                messageDataDO.setServiceId(dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()).getId());
                            }
                        } else {
                            messageDataDO.setServiceId(dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()).getId());
                        }
                    }
                    catch (BAMException e) {
                        log.error((Object)"Could not retrieve service from DB ", (Throwable)e);
                    }
                    try {
                        if (dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()) == null) {
                            OperationDO operation = new OperationDO();
                            ServiceDO serviceDO = dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName());
                            if (serviceDO != null) {
                                operation.setServiceID(serviceDO.getId());
                                operation.setName(data.getOperationName());
                                dsAdmin.addOperation(operation);
                                messageDataDO.setOperationId(dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()).getOperationID());
                            } else {
                                serviceDO = new ServiceDO();
                                serviceDO.setServerID(messageDataDO.getServerId());
                                serviceDO.setName(data.getServiceName());
                                dsAdmin.addService(serviceDO);
                                messageDataDO.setServiceId(dsAdmin.getService(messageDataDO.getServerId(), data.getServiceName()).getId());
                                operation.setServiceID(messageDataDO.getServiceId());
                                operation.setName(data.getOperationName());
                                dsAdmin.addOperation(operation);
                                messageDataDO.setOperationId(dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()).getOperationID());
                            }
                        } else {
                            messageDataDO.setOperationId(dsAdmin.getOperation(messageDataDO.getServiceId(), data.getOperationName()).getOperationID());
                        }
                    }
                    catch (BAMException e) {
                        log.error((Object)"Could not retrieve operation from DB ", (Throwable)e);
                    }
                    this.checkForActivityExistense(data, dsAdmin, messageDataDO);
                    try {
                        MessageDO inMsg = dsAdmin.getMessage(data.getMessageId(), messageDataDO.getOperationId(), messageDataDO.getActivityKeyId());
                        if (inMsg != null) {
                            messageDataDO.setMessageKeyId(inMsg.getMessageKeyId());
                        } else {
                            MessageDO mesg_in = new MessageDO();
                            mesg_in.setMessageId(data.getMessageId());
                            mesg_in.setActivityKeyId(messageDataDO.getActivityKeyId());
                            mesg_in.setOperationId(messageDataDO.getOperationId());
                            mesg_in.setTimestamp(data.getTimeStamp());
                            mesg_in.setIPAddress(data.getRemoteIPAddress());
                            mesg_in.setUserAgent(data.getUserAgent());
                            dsAdmin.addMessage(mesg_in);
                            messageDataDO.setMessageKeyId(dsAdmin.getMessage(data.getMessageId(), messageDataDO.getOperationId(), messageDataDO.getActivityKeyId()).getMessageKeyId());
                        }
                    }
                    catch (BAMException e) {
                        log.error((Object)("Error updating Message statistics data for server " + data.getServerName() + " service " + data.getServiceName() + " operation " + data.getOperationName() + " from eventing message receiver " + e.getLocalizedMessage()));
                    }
                    try {
                        MessageDataDO msgDat_in = dsAdmin.getMessageDataForActivityKeyIDandMessageKeyID(messageDataDO.getMessageKeyId(), messageDataDO.getActivityKeyId());
                        if (msgDat_in != null) {
                            messageDataDO.setMessageDataKeyId(msgDat_in.getMessageDataKeyId());
                            dsAdmin.updateMessageStatus(data.getRequestMessageStatus(), msgDat_in.getMessageDataKeyId());
                        } else {
                            direction = "Request";
                            dsAdmin.addMessageDataDump(messageDataDO, direction);
                        }
                    }
                    catch (BAMException e) {
                        log.error((Object)"Could not dump the full message to DB", (Throwable)e);
                    }
                    try {
                        String out_msg_id = data.getOutMessageID();
                        if (out_msg_id != null && !"".equals(out_msg_id)) {
                            MessageDO outMsg = dsAdmin.getMessage(data.getOutMessageID(), messageDataDO.getOperationId(), messageDataDO.getActivityKeyId());
                            if (outMsg != null) {
                                messageDataDO.setMessageKeyId(outMsg.getMessageKeyId());
                            } else {
                                MessageDO mesg_out = new MessageDO();
                                mesg_out.setMessageId(data.getOutMessageID());
                                mesg_out.setActivityKeyId(messageDataDO.getActivityKeyId());
                                mesg_out.setOperationId(messageDataDO.getOperationId());
                                mesg_out.setTimestamp(data.getTimeStamp());
                                mesg_out.setIPAddress(data.getRemoteIPAddress());
                                mesg_out.setUserAgent(data.getUserAgent());
                                dsAdmin.addMessage(mesg_out);
                                messageDataDO.setMessageKeyId(dsAdmin.getMessage(data.getOutMessageID(), messageDataDO.getOperationId(), messageDataDO.getActivityKeyId()).getMessageKeyId());
                            }
                        }
                    }
                    catch (BAMException e) {
                        log.error((Object)("Error updating Message statistics data for server " + data.getServerName() + " service " + data.getServiceName() + " operation " + data.getOperationName() + " from eventing message receiver " + e.getLocalizedMessage()));
                    }
                    try {
                        MessageDataDO msgDat_out = dsAdmin.getMessageDataForActivityKeyIDandMessageKeyID(messageDataDO.getMessageKeyId(), messageDataDO.getActivityKeyId());
                        if (msgDat_out != null) {
                            messageDataDO.setMessageDataKeyId(msgDat_out.getMessageDataKeyId());
                            dsAdmin.updateMessageStatus(data.getResponseMessageStatus(), msgDat_out.getMessageDataKeyId());
                            break block35;
                        }
                        direction = "Response";
                        dsAdmin.addMessageDataDump(messageDataDO, direction);
                    }
                    catch (BAMException e) {
                        log.error((Object)"Could not dump the full message to DB", (Throwable)e);
                    }
                } else {
                    this.messageFaultReason = "Required element is empty ; \n Service :" + data.getServiceName() + "\n Operation:" + data.getOperationName() + "\n ActivityID:" + data.getActivityId();
                }
            } else {
                this.messageFaultReason = "Required element is null ; \n Service :" + data.getServiceName() + "\n Operation:" + data.getOperationName() + "\n ActivityID:" + data.getActivityId();
            }
        }
    }

    private void checkForActivityExistense(ActivityData data, BAMDataServiceAdmin dsAdmin, MessageDataDO messageDataDO) {
        ActivityDO activity = null;
        try {
            if (this.activityMap.containsKey(data.getActivityId())) {
                activity = this.activityMap.get(data.getActivityId());
            } else {
                if (dsAdmin.getActivityForActivityID(data.getActivityId()) == null) {
                    activity = new ActivityDO();
                    activity.setActivityId(data.getActivityId());
                    activity.setName(data.getActivityName());
                    activity.setDescription(data.getActivityDescription());
                    dsAdmin.addActivity(activity);
                }
                activity = dsAdmin.getActivityForActivityID(data.getActivityId());
                this.activityMap.put(activity.getActivityId(), activity);
            }
            messageDataDO.setActivityKeyId(activity.getActivityKeyId());
        }
        catch (BAMException e) {
            log.error((Object)"Could not retrieve activity from DB ", (Throwable)e);
        }
    }

    private void storeProperties(ActivityData data, BAMDataServiceAdmin dsAdmin) {
        if (!(data.getServiceName() == null || data.getOperationName() == null || data.getActivityId() == null || data.getOperationName().equals("") || data.getServiceName().equals("") || data.getActivityId().equals("") || data.getProperties() == null || data.getProperties().size() <= 0)) {
            String dbtime = null;
            MessagePropertyDO messagePropertyDO = new MessagePropertyDO();
            ServerDO serverDO = null;
            try {
                if (this.serverMap.containsKey(data.getServerName())) {
                    serverDO = this.serverMap.get(data.getServerName());
                } else {
                    serverDO = dsAdmin.getServer(data.getServerName());
                    if (serverDO == null) {
                        log.error((Object)("Server is not in the Database " + data.getServerName()));
                        return;
                    }
                    this.serverMap.put(data.getServerName(), serverDO);
                }
                messagePropertyDO.setServerId(serverDO.getId());
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve server from DB ", (Throwable)e);
            }
            ServiceDO serviceDO = null;
            try {
                String key = messagePropertyDO.getServerId() + "-" + data.getServiceName();
                if (this.serviceMap.containsKey(key)) {
                    serviceDO = this.serviceMap.get(key);
                } else {
                    serviceDO = dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName());
                    if (serviceDO == null) {
                        serviceDO = new ServiceDO();
                        serviceDO.setServerID(serverDO.getId());
                        serviceDO.setName(data.getServiceName());
                        dsAdmin.addService(serviceDO);
                        serviceDO = dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName());
                    }
                    this.serviceMap.put(key, serviceDO);
                }
                messagePropertyDO.setServiceId(serviceDO.getId());
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve service from DB ", (Throwable)e);
            }
            OperationDO operationDO = null;
            try {
                String key = messagePropertyDO.getServiceId() + "-" + data.getOperationName();
                if (this.operationMap.containsKey(key)) {
                    operationDO = this.operationMap.get(key);
                } else {
                    operationDO = dsAdmin.getOperation(messagePropertyDO.getServiceId(), data.getOperationName());
                    if (operationDO == null) {
                        operationDO = new OperationDO();
                        operationDO.setServiceID(serviceDO.getId());
                        operationDO.setName(data.getOperationName());
                        dsAdmin.addOperation(operationDO);
                        operationDO = dsAdmin.getOperation(messagePropertyDO.getServiceId(), data.getOperationName());
                    }
                    this.operationMap.put(key, operationDO);
                }
                messagePropertyDO.setOperationId(operationDO.getOperationID());
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve operation from DB ", (Throwable)e);
            }
            ActivityDO activity = null;
            try {
                if (this.activityMap.containsKey(data.getActivityId())) {
                    activity = this.activityMap.get(data.getActivityId());
                } else {
                    activity = dsAdmin.getActivityForActivityID(data.getActivityId());
                    if (activity == null) {
                        activity = new ActivityDO();
                        activity.setActivityId(data.getActivityId());
                        activity.setName(data.getActivityName());
                        activity.setDescription(data.getActivityDescription());
                        dsAdmin.addActivity(activity);
                        activity = dsAdmin.getActivityForActivityID(data.getActivityId());
                    }
                    this.activityMap.put(data.getActivityId(), activity);
                }
                messagePropertyDO.setActivityKeyId(activity.getActivityKeyId());
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve activity from DB ", (Throwable)e);
            }
            try {
                MessageDO msg = dsAdmin.getMessage(data.getMessageId(), messagePropertyDO.getOperationId(), messagePropertyDO.getActivityKeyId());
                if (msg != null) {
                    messagePropertyDO.setMessageKeyId(msg.getMessageKeyId());
                    dbtime = msg.getTimestamp();
                } else {
                    MessageDO mesg = new MessageDO();
                    if (activity != null) {
                        mesg.setMessageId(data.getMessageId());
                        mesg.setActivityKeyId(messagePropertyDO.getActivityKeyId());
                        mesg.setOperationId(messagePropertyDO.getOperationId());
                        mesg.setTimestamp(data.getTimeStamp());
                        mesg.setIPAddress(data.getRemoteIPAddress());
                        mesg.setUserAgent(data.getUserAgent());
                        dsAdmin.addMessage(mesg);
                        messagePropertyDO.setMessageKeyId(dsAdmin.getMessage(data.getMessageId(), messagePropertyDO.getOperationId(), messagePropertyDO.getActivityKeyId()).getMessageKeyId());
                        dbtime = data.getTimeStamp();
                    }
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve message from DB", (Throwable)e);
            }
            try {
                HashMap<String, String> propertyList = new HashMap<String, String>();
                for (String actProperty : data.getProperties().keySet()) {
                    propertyList.put(actProperty, data.getProperties().get(actProperty));
                }
                ArrayList<String> keyList = new ArrayList<String>();
                ArrayList<String> valueList = new ArrayList<String>();
                Set keys = propertyList.keySet();
                for (String key : keys) {
                    String value = (String)propertyList.get(key);
                    keyList.add(key);
                    valueList.add(value);
                }
                String[] valueArray = new String[keyList.size()];
                String[] keyArray = new String[keyList.size()];
                keyList.toArray(keyArray);
                valueList.toArray(valueArray);
                messagePropertyDO.setKeyArray(keyArray);
                messagePropertyDO.setValueArray(valueArray);
                dsAdmin.addMessageProperty(messagePropertyDO);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Message Properties are saved");
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not add message property ", (Throwable)e);
            }
        }
    }

    private void storeXPathProperties(ActivityData data, BAMDataServiceAdmin dsAdmin) {
        if (!(data.getServiceName() == null || data.getOperationName() == null || data.getActivityId() == null || data.getOperationName().equals("") || data.getServiceName().equals("") || data.getActivityId().equals("") || data.getXPathEvaluations() == null)) {
            ServerDO serverDO;
            MessagePropertyDO messagePropertyDO = null;
            messagePropertyDO = new MessagePropertyDO();
            try {
                serverDO = dsAdmin.getServer(data.getServerName());
                if (serverDO != null) {
                    messagePropertyDO.setServerId(serverDO.getId());
                } else {
                    log.error((Object)("Server is not in the Database" + data.getServerName()));
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve server from DB ", (Throwable)e);
            }
            try {
                if (dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName()) == null) {
                    ServiceDO service = new ServiceDO();
                    serverDO = dsAdmin.getServer(data.getServerName());
                    if (serverDO != null) {
                        service.setServerID(serverDO.getId());
                        service.setName(data.getServiceName());
                        dsAdmin.addService(service);
                        messagePropertyDO.setServiceId(dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName()).getId());
                    }
                } else {
                    messagePropertyDO.setServiceId(dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName()).getId());
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve service from DB ", (Throwable)e);
            }
            try {
                if (dsAdmin.getOperation(messagePropertyDO.getServiceId(), data.getOperationName()) == null) {
                    OperationDO operation = new OperationDO();
                    ServiceDO serviceDO = dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName());
                    if (serviceDO != null) {
                        operation.setServiceID(messagePropertyDO.getServiceId());
                        operation.setName(data.getOperationName());
                        dsAdmin.addOperation(operation);
                        messagePropertyDO.setOperationId(dsAdmin.getOperation(messagePropertyDO.getServiceId(), data.getOperationName()).getOperationID());
                    } else {
                        serviceDO = new ServiceDO();
                        serviceDO.setServerID(messagePropertyDO.getServerId());
                        serviceDO.setName(data.getServiceName());
                        dsAdmin.addService(serviceDO);
                        messagePropertyDO.setServiceId(dsAdmin.getService(messagePropertyDO.getServerId(), data.getServiceName()).getId());
                        operation.setServiceID(messagePropertyDO.getServiceId());
                        operation.setName(data.getOperationName());
                        dsAdmin.addOperation(operation);
                        messagePropertyDO.setOperationId(dsAdmin.getOperation(messagePropertyDO.getServiceId(), data.getOperationName()).getOperationID());
                    }
                } else {
                    messagePropertyDO.setOperationId(dsAdmin.getOperation(messagePropertyDO.getServiceId(), data.getOperationName()).getOperationID());
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve operation from DB ", (Throwable)e);
            }
            try {
                if (dsAdmin.getActivityForActivityID(data.getActivityId()) == null) {
                    ActivityDO activity = new ActivityDO();
                    activity.setActivityId(data.getActivityId());
                    activity.setName(data.getActivityName());
                    activity.setDescription(data.getActivityDescription());
                    dsAdmin.addActivity(activity);
                    messagePropertyDO.setActivityKeyId(dsAdmin.getActivityForActivityID(data.getActivityId()).getActivityKeyId());
                } else {
                    messagePropertyDO.setActivityKeyId(dsAdmin.getActivityForActivityID(data.getActivityId()).getActivityKeyId());
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve activity from DB ", (Throwable)e);
            }
            try {
                MessageDO msg = dsAdmin.getMessage(data.getMessageId(), messagePropertyDO.getOperationId(), messagePropertyDO.getActivityKeyId());
                if (msg != null) {
                    messagePropertyDO.setMessageKeyId(msg.getMessageKeyId());
                } else {
                    MessageDO mesg = new MessageDO();
                    ActivityDO activityDO = dsAdmin.getActivityForActivityID(data.getActivityId());
                    if (activityDO != null) {
                        mesg.setMessageId(data.getMessageId());
                        mesg.setActivityKeyId(messagePropertyDO.getActivityKeyId());
                        mesg.setOperationId(messagePropertyDO.getOperationId());
                        mesg.setTimestamp(BAMCalendar.getInstance((Calendar)Calendar.getInstance()).getBAMTimestamp());
                        mesg.setIPAddress(data.getRemoteIPAddress());
                        mesg.setUserAgent(data.getUserAgent());
                        dsAdmin.addMessage(mesg);
                        messagePropertyDO.setMessageKeyId(dsAdmin.getMessage(data.getMessageId(), messagePropertyDO.getOperationId(), messagePropertyDO.getActivityKeyId()).getMessageKeyId());
                    }
                }
            }
            catch (BAMException e) {
                log.error((Object)"Could not retrieve message from DB", (Throwable)e);
            }
            try {
                HashMap<String, String> propertyList = new HashMap<String, String>();
                for (PropertyFilterData propertyFilterData : data.getXPathEvaluations().keySet()) {
                    propertyList.put(propertyFilterData.getExpressionKey(), data.getXPathEvaluations().get(propertyFilterData));
                }
                ArrayList<String> keyList = new ArrayList<String>();
                ArrayList<String> valueList = new ArrayList<String>();
                Set keys = propertyList.keySet();
                for (String key : keys) {
                    String value = (String)propertyList.get(key);
                    keyList.add(key);
                    valueList.add(value);
                }
                String[] valueArray = new String[keyList.size()];
                String[] keyArray = new String[keyList.size()];
                keyList.toArray(keyArray);
                valueList.toArray(valueArray);
                messagePropertyDO.setKeyArray(keyArray);
                messagePropertyDO.setValueArray(valueArray);
                dsAdmin.addMessageProperty(messagePropertyDO);
            }
            catch (BAMException e) {
                log.error((Object)"Could not add message property ", (Throwable)e);
            }
        }
    }

    class PropertyFilterData {
        private String serverName;
        private String expressionKey;
        private String alias;
        private String expression;
        private String[] namespaces;

        PropertyFilterData() {
        }

        public String getExpressionKey() {
            return this.expressionKey;
        }

        public void setExpressionKey(String expressionKey) {
            this.expressionKey = expressionKey;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String[] getNamespaces() {
            return this.namespaces;
        }

        public void setNamespaces(String[] namespaces) {
            this.namespaces = namespaces;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }
    }

    class ActivityData {
        private String activityId;
        private String messageId;
        private String operationName;
        private String serverName;
        private String serviceName;
        private String activityName;
        private String activityDescription;
        private String userAgent;
        private String remoteIPAddress;
        private String messageDirection;
        private String messageBody;
        private String timeStamp;
        private String requestMessageStatus;
        private String responseMessageStatus;
        private String outMessageID;
        private Map<String, String> properties;
        private Map<PropertyFilterData, String> xpathEvaluations;

        ActivityData() {
        }

        public String getActivityId() {
            return this.activityId;
        }

        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        public String getActivityDescription() {
            return this.activityDescription;
        }

        public void setActivityDescription(String activityDescription) {
            this.activityDescription = activityDescription;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        public String getRemoteIPAddress() {
            return this.remoteIPAddress;
        }

        public void setRemoteIPAddress(String remoteIPAddress) {
            this.remoteIPAddress = remoteIPAddress;
        }

        public String getMessageDirection() {
            return this.messageDirection;
        }

        public void setMessageDirection(String messageDirection) {
            this.messageDirection = messageDirection;
        }

        public String getMessageBody() {
            return this.messageBody;
        }

        public void setMessageBody(String messageBody) {
            this.messageBody = messageBody;
        }

        public String getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(String timeStamp) {
            this.timeStamp = timeStamp;
        }

        public Map<PropertyFilterData, String> getXPathEvaluations() {
            return this.xpathEvaluations;
        }

        public void setXPathEvaluations(Map<PropertyFilterData, String> xpathEvaluations) {
            this.xpathEvaluations = xpathEvaluations;
        }

        public String getRequestMessageStatus() {
            return this.requestMessageStatus;
        }

        public void setRequestMessageStatus(String requestMessageStatus) {
            this.requestMessageStatus = requestMessageStatus;
        }

        public String getResponseMessageStatus() {
            return this.responseMessageStatus;
        }

        public void setResponseMessageStatus(String responseMessageStatus) {
            this.responseMessageStatus = responseMessageStatus;
        }

        public String getOutMessageID() {
            return this.outMessageID;
        }

        public void setOutMessageID(String outMessageID) {
            this.outMessageID = outMessageID;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

