/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.receivers;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractQueue {
    private Queue<MessageContext> serverQueue = new ArrayBlockingQueue<MessageContext>(5000);
    private ExecutorService exec;
    private boolean shutdown = false;
    private static final Log log = LogFactory.getLog(AbstractQueue.class);

    public AbstractQueue(int threadPoolSize) {
        this.exec = Executors.newFixedThreadPool(threadPoolSize);
    }

    public void enqueue(MessageContext messageContext) {
        if (this.shutdown) {
            log.warn((Object)"The queue is shutting down... Not accepting the new events...");
            return;
        }
        messageContext.getEnvelope().build();
        boolean queued = this.serverQueue.offer(messageContext);
        if (queued) {
            if (this.serverQueue.size() > 0) {
                this.exec.submit(new ServerWorker());
            }
        } else {
            log.warn((Object)"Queue filled up. Event rejected");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Event rejected : " + messageContext.getEnvelope().toString()));
            }
        }
    }

    public void cleanup() {
        this.shutdown = true;
        while (this.serverQueue.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for the queue to become empty");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.exec.shutdownNow();
    }

    private void clearEventsInQueue(int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("No of messages in queue : " + size));
        }
        if (size == 0) {
            return;
        }
        MessageContext[] messageContexts = new MessageContext[size];
        for (int i = 0; i < size; ++i) {
            messageContexts[i] = this.serverQueue.poll();
        }
        this.processEvents(messageContexts);
    }

    protected abstract void processEvents(MessageContext[] var1);

    private class ServerWorker
    implements Runnable {
        private ServerWorker() {
        }

        @Override
        public void run() {
            AbstractQueue.this.clearEventsInQueue(AbstractQueue.this.serverQueue.size());
        }
    }
}

