/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.collector;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.stats.StatisticsDO;
import org.wso2.carbon.bam.core.clients.StatisticsAdminClient;
import org.wso2.carbon.bam.core.collector.AbstractDataPuller;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.core.util.ClientAuthHandler;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.statistics.stub.types.carbon.ServiceStatistics;

public class ServiceStatisticsDataPuller
extends AbstractDataPuller {
    public ServiceStatisticsDataPuller(ServerDO server) {
        this.setServer(server);
    }

    @Override
    public StatisticsDO pullData(Object ctx) throws BAMException, RemoteException {
        BAMPersistenceManager pm = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
        String svcName = (String)ctx;
        String sessionCookie = ClientAuthHandler.getClientAuthHandler().getSessionString(this.getServer());
        StatisticsAdminClient client = new StatisticsAdminClient(this.getServer().getServerURL(), sessionCookie);
        ServiceStatistics svcStatistics = client.getServiceStatistics(svcName);
        ServiceStatisticsDO statisticsDO = new ServiceStatisticsDO();
        statisticsDO.setServerID(this.getServer().getId());
        statisticsDO.setServerURL(this.getServer().getServerURL());
        statisticsDO.setServiceName(svcName);
        int serviceId = statisticsDO.getServiceID();
        ServiceDO svc = serviceId > 0 ? pm.getService(serviceId) : pm.getService(statisticsDO.getServerID(), statisticsDO.getServiceName());
        if (svc == null) {
            svc = new ServiceDO();
            svc.setName(svcName);
            svc.setServerID(this.getServer().getId());
            BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry()).addService(svc);
        }
        statisticsDO.setServiceID(svc.getId());
        statisticsDO.setTimestamp(Calendar.getInstance());
        ServiceStatisticsDataPuller.populateServiceStatisticsDO(statisticsDO, svcStatistics);
        return statisticsDO;
    }

    private static void populateServiceStatisticsDO(ServiceStatisticsDO statisticsDO, ServiceStatistics statistics) {
        statisticsDO.setAvgResTime(statistics.getAvgResponseTime());
        statisticsDO.setMaxResTime((double)statistics.getMaxResponseTime());
        statisticsDO.setMinResTime((double)statistics.getMinResponseTime());
        statisticsDO.setReqCount(statistics.getTotalRequestCount());
        statisticsDO.setResCount(statistics.getTotalResponseCount());
        statisticsDO.setFaultCount(statistics.getTotalFaultCount());
    }
}

