/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.collector;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.stats.StatisticsDO;
import org.wso2.carbon.bam.core.clients.StatisticsAdminClient;
import org.wso2.carbon.bam.core.collector.AbstractDataPuller;
import org.wso2.carbon.bam.core.util.ClientAuthHandler;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.statistics.stub.types.carbon.SystemStatistics;

public class ServerStatisticsDataPuller
extends AbstractDataPuller {
    public ServerStatisticsDataPuller(ServerDO server) {
        this.setServer(server);
    }

    public StatisticsDO pullDataInternal(ServerDO server) throws BAMException, RemoteException {
        String sessionCookie = ClientAuthHandler.getClientAuthHandler().getSessionString(server);
        String serverUrl = server.getServerURL();
        StatisticsAdminClient client = new StatisticsAdminClient(serverUrl, sessionCookie);
        SystemStatistics sysStatistics = client.getSystemStatistics();
        ServerStatisticsDO statisticsDO = new ServerStatisticsDO();
        statisticsDO.setServerID(server.getId());
        statisticsDO.setServerURL(serverUrl);
        statisticsDO.setTimestamp(Calendar.getInstance());
        ServerStatisticsDataPuller.populateServerStatisticsDO(statisticsDO, sysStatistics);
        return statisticsDO;
    }

    @Override
    public StatisticsDO pullData(Object serverObj) throws BAMException, RemoteException {
        StatisticsDO statisticsDO;
        block2: {
            statisticsDO = null;
            ServerDO server = (ServerDO)serverObj;
            try {
                statisticsDO = this.pullDataInternal(server);
            }
            catch (AxisFault axisFault) {
                if (!ClientAuthHandler.checkAuthException(axisFault)) break block2;
                ClientAuthHandler.getClientAuthHandler().authenticateForcefully(this.getServer());
                statisticsDO = this.pullDataInternal(server);
            }
        }
        return statisticsDO;
    }

    private static void populateServerStatisticsDO(ServerStatisticsDO statisticsDO, SystemStatistics statistics) {
        statisticsDO.setAvgResTime(statistics.getAvgResponseTime());
        statisticsDO.setMaxResTime((double)statistics.getMaxResponseTime());
        statisticsDO.setMinResTime((double)statistics.getMinResponseTime());
        statisticsDO.setReqCount(statistics.getTotalRequestCount());
        statisticsDO.setResCount(statistics.getTotalResponseCount());
        statisticsDO.setFaultCount(statistics.getTotalFaultCount());
    }
}

