/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.collector;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.core.collector.DataPuller;
import org.wso2.carbon.bam.core.collector.OperationStatisticsDataPuller;
import org.wso2.carbon.bam.core.collector.ServerStatisticsDataPuller;
import org.wso2.carbon.bam.core.collector.ServiceStatisticsDataPuller;

public class DataPullerFactory {
    public static final String SERVICE_STATISTICS_PULLER = "SVC_STATS_PULLER";
    public static final String SERVER_STATISTICS_PULLER = "SVR_STATS_PULLER";
    public static final String OPERTION_STATISTICS_PULLER = "OP_STATS_PULLER";
    private static Map<Integer, Map<String, DataPuller>> pullers = new ConcurrentHashMap<Integer, Map<String, DataPuller>>();

    public static DataPuller getDataPuller(ServerDO server, String type) {
        DataPuller puller;
        Map<String, DataPuller> serverPullers = pullers.get(server.getId());
        if (serverPullers != null) {
            puller = serverPullers.get(type);
            if (puller != null) {
                return puller;
            }
        } else {
            serverPullers = new ConcurrentHashMap<String, DataPuller>();
            pullers.put(server.getId(), serverPullers);
        }
        if (type.compareTo(SERVICE_STATISTICS_PULLER) == 0) {
            puller = new ServiceStatisticsDataPuller(server);
        } else if (type.compareTo(SERVER_STATISTICS_PULLER) == 0) {
            puller = new ServerStatisticsDataPuller(server);
        } else if (type.compareTo(OPERTION_STATISTICS_PULLER) == 0) {
            puller = new OperationStatisticsDataPuller(server);
        } else {
            throw new RuntimeException("unexpected puller type");
        }
        serverPullers.put(type, puller);
        return puller;
    }
}

