/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.collector;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerStatisticsDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceStatisticsDO;
import org.wso2.carbon.bam.core.admin.BAMDataServiceAdmin;
import org.wso2.carbon.bam.core.admin.MonitoredServerServiceInfoAdmin;
import org.wso2.carbon.bam.core.collector.DataPuller;
import org.wso2.carbon.bam.core.collector.DataPullerFactory;
import org.wso2.carbon.bam.core.persistence.BAMPersistenceManager;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.core.util.BackOffCounter;
import org.wso2.carbon.bam.util.BAMException;

public class DataCollector
extends TimerTask {
    private static Log log = LogFactory.getLog(DataCollector.class);
    private boolean running = false;
    private boolean signalled = false;

    @Override
    public void run() {
        BAMPersistenceManager persistenceManager;
        if (this.signalled) {
            this.running = false;
            return;
        }
        this.running = true;
        List<ServerDO> serverList = null;
        BAMDataServiceAdmin statisticsAdmin = new BAMDataServiceAdmin();
        try {
            persistenceManager = BAMPersistenceManager.getPersistenceManager(BAMUtil.getRegistry());
            if (persistenceManager == null) {
                throw new BAMException("Can't initialize BAMPersistenceManager");
            }
            serverList = Arrays.asList(persistenceManager.getMonitoredServersByType("PullServer"));
        }
        catch (Exception e) {
            log.warn((Object)"Error occurred while retrieving the server list for polling data");
            if (log.isDebugEnabled()) {
                log.error((Object)"Error occurred while retrieving the server list for polling data", (Throwable)e);
            }
            return;
        }
        if (serverList != null && serverList.size() > 0) {
            BackOffCounter backoffcounter = BackOffCounter.getInstance();
            for (ServerDO server : serverList) {
                boolean isServerUp = this.isServerUpAndRunning(server);
                try {
                    Boolean state = false;
                    if (server.getActive()) {
                        state = true;
                    }
                    if (!state.booleanValue() || backoffcounter.shouldBackoff(server) || !isServerUp) continue;
                    DataPuller svrDataPuller = DataPullerFactory.getDataPuller(server, "SVR_STATS_PULLER");
                    MonitoredServerServiceInfoAdmin serviceInfoAdmin = new MonitoredServerServiceInfoAdmin();
                    String[] serviceNames = serviceInfoAdmin.getServiceNames(server);
                    ServerStatisticsDO svrStatisticsDO = (ServerStatisticsDO)svrDataPuller.pullData(server);
                    statisticsAdmin.addServerStatistics(svrStatisticsDO);
                    if (serviceNames != null && serviceNames.length > 0) {
                        DataPuller dataPuller = DataPullerFactory.getDataPuller(server, "SVC_STATS_PULLER");
                        for (String serviceName : serviceNames) {
                            ServiceStatisticsDO svcStatisticsDO = (ServiceStatisticsDO)dataPuller.pullData(serviceName);
                            if (svcStatisticsDO != null) {
                                statisticsAdmin.addServiceStatistics(svcStatisticsDO);
                            }
                            ServiceDO svc = persistenceManager.getService(server.getId(), serviceName);
                            String[] operationNames = serviceInfoAdmin.getOperationNames(server, serviceName);
                            if (operationNames == null || operationNames.length <= 0) continue;
                            DataPuller opDataPuller = DataPullerFactory.getDataPuller(server, "OP_STATS_PULLER");
                            for (String operationName : operationNames) {
                                OperationDO operationDO = new OperationDO();
                                operationDO.setName(operationName);
                                operationDO.setServiceID(svc.getId());
                                OperationStatisticsDO opStatisticsDO = (OperationStatisticsDO)opDataPuller.pullData(operationDO);
                                statisticsAdmin.addOperationStatistics(opStatisticsDO);
                            }
                        }
                    }
                    backoffcounter.resetFailCount(server);
                }
                catch (Exception e) {
                    backoffcounter.incrementFailCount(server);
                    log.warn((Object)("Error occurred while polling data from server " + server.getServerURL()));
                    if (!log.isDebugEnabled()) continue;
                    log.error((Object)("Error occurred while polling data from server " + server.getServerURL()), (Throwable)e);
                }
            }
        }
    }

    private boolean isServerUpAndRunning(ServerDO server) {
        boolean isServerUp;
        String protocol;
        int firstElement = 0;
        int secondElement = 1;
        String[] urlAndPort = server.getServerURL().split("://")[secondElement].split(":");
        String url = urlAndPort[firstElement];
        String port = urlAndPort.length > 1 ? (urlAndPort[secondElement].contains("/") ? urlAndPort[secondElement].split("/")[firstElement] : urlAndPort[secondElement]) : ("http".equals(protocol = server.getServerURL().split("://")[firstElement]) ? "80" : "443");
        try {
            Socket socket = new Socket(url, Integer.parseInt(port));
            isServerUp = true;
        }
        catch (IOException e) {
            isServerUp = false;
        }
        return isServerUp;
    }

    public boolean getRunningState() {
        return this.running;
    }

    public void setSignalledState(boolean signalled) {
        this.signalled = signalled;
    }
}

