/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.clients;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.xmlbeans.xml.stream.XMLStreamException;
import org.wso2.carbon.bam.core.clients.AbstractAdminClient;
import org.wso2.carbon.dataservices.core.DBInOnlyMessageReceiver;
import org.wso2.carbon.dataservices.core.DBInOutMessageReceiver;
import org.wso2.carbon.utils.ConfigurationContextService;

public abstract class AbstractDSClient<T extends Stub>
extends AbstractAdminClient<T> {
    protected ConfigurationContextService ccService;

    protected OMElement invokeDataServiceOperation(String opName, OMElement soapBody, MEP mep) throws AxisFault, XMLStreamException {
        Object msgReceiver = mep == MEP.INOUT ? new DBInOutMessageReceiver() : new DBInOnlyMessageReceiver();
        MessageContext msgCtx = this.buildMessageContext(opName);
        SOAP12Factory soapFactory = new SOAP12Factory();
        SOAPEnvelope env = soapFactory.getDefaultEnvelope();
        env.getBody().addChild((OMNode)soapBody);
        msgCtx.setEnvelope(env);
        SOAPBody bodyEle = null;
        if (mep == MEP.INOUT) {
            MessageContext retMsgCtx = new MessageContext();
            msgReceiver.invokeBusinessLogic(msgCtx, retMsgCtx);
            bodyEle = retMsgCtx.getEnvelope().getBody();
        } else {
            ((DBInOnlyMessageReceiver)msgReceiver).invokeBusinessLogic(msgCtx);
        }
        return bodyEle;
    }

    protected abstract AxisService getAxisService() throws AxisFault;

    protected static AxisOperation getAxisOperation(AxisService svc, String opName) {
        return svc.getOperationByAction(opName);
    }

    protected MessageContext buildMessageContext(String opName) throws AxisFault {
        MessageContext msgCtx = new MessageContext();
        AxisService svc = this.getAxisService();
        msgCtx.setAxisService(svc);
        msgCtx.setAxisOperation(AbstractDSClient.getAxisOperation(svc, opName));
        return msgCtx;
    }

    protected static Map getOMElementNamespaces(OMElement element) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Iterator namespaceIterator = element.getAllDeclaredNamespaces();
        while (namespaceIterator.hasNext()) {
            OMNamespace ns = (OMNamespace)namespaceIterator.next();
            returnMap.put(ns.getPrefix(), ns.getNamespaceURI());
        }
        return returnMap;
    }

    protected static enum MEP {
        INONLY,
        INOUT;

    }
}

