/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.cache;

import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.core.cache.CacheData;
import org.wso2.carbon.bam.core.util.BAMUtil;

public class CacheTask
extends TimerTask {
    private static final Log log = LogFactory.getLog(CacheTask.class);

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cache Cleaned Started..");
        }
        HashMap<String, CacheData> cacheMap = BAMUtil.getBAMCache();
        boolean cacheCleaned = false;
        Thread.currentThread().setName("BAM-Caching-Thread");
        try {
            for (Map.Entry<String, CacheData> entry : cacheMap.entrySet()) {
                CacheData cacheData = entry.getValue();
                if (cacheData == null) continue;
                long cachedTime = cacheData.getTimestamp().getTimeInMillis();
                long currentTime = Calendar.getInstance().getTimeInMillis();
                long timeDiff = currentTime - cachedTime;
                if (timeDiff <= 1200000L) continue;
                cacheMap.remove(entry.getKey());
                cacheCleaned = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Cached Cleaned for Key: " + entry.getKey()));
            }
            if (cacheCleaned) {
                log.info((Object)"Cache Cleaned..");
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

